/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.data.CellRenderData;
import com.deepoove.poi.data.MergeCellRule;
import com.deepoove.poi.data.ParagraphRenderData;
import com.deepoove.poi.data.RowRenderData;
import com.deepoove.poi.data.TableRenderData;
import com.deepoove.poi.data.style.CellStyle;
import com.deepoove.poi.data.style.ParagraphStyle;
import com.deepoove.poi.data.style.TableStyle;
import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.policy.ParagraphRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.util.StyleUtils;
import com.deepoove.poi.util.TableTools;
import com.deepoove.poi.xwpf.BodyContainer;
import com.deepoove.poi.xwpf.BodyContainerFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public class TableRenderPolicy
extends AbstractRenderPolicy<TableRenderData> {
    @Override
    protected boolean validate(TableRenderData data) {
        int[] colWidths;
        if (null == data || 0 == data.obtainColSize()) {
            return false;
        }
        List<RowRenderData> rows = data.getRows();
        int col = data.obtainColSize();
        for (RowRenderData row : rows) {
            if (col == row.obtainColSize()) continue;
            throw new IllegalArgumentException("Number of cells in each row should be the same!");
        }
        TableStyle tableStyle = data.getTableStyle();
        if (null != tableStyle && null != (colWidths = tableStyle.getColWidths()) && colWidths.length != col) {
            throw new IllegalArgumentException("The length of Colwidth array and number of columns must be the same!");
        }
        return true;
    }

    @Override
    public void doRender(RenderContext<TableRenderData> context) throws Exception {
        Helper.renderTable(context.getRun(), context.getData());
    }

    @Override
    protected void afterRender(RenderContext<TableRenderData> context) {
        this.clearPlaceholder(context, true);
    }

    public static class Helper {
        public static void renderTable(XWPFRun run, TableRenderData data) throws Exception {
            BodyContainer bodyContainer = BodyContainerFactory.getBodyContainer(run);
            XWPFTable table = bodyContainer.insertNewTable(run, data.obtainRowSize(), data.obtainColSize());
            StyleUtils.styleTable(table, data.getTableStyle());
            int size = table.getRows().size();
            for (int i = 0; i < size; ++i) {
                Helper.renderRow((XWPFTableRow)table.getRows().get(i), data.getRows().get(i));
            }
            Helper.applyMergeRule(table, data.getMergeRule());
        }

        public static void renderRow(XWPFTableRow row, RowRenderData data) throws Exception {
            if (null == data) {
                return;
            }
            int size = row.getTableCells().size();
            if (size != data.obtainColSize()) {
                throw new IllegalArgumentException("Number of cells and render data should be the same!");
            }
            StyleUtils.styleTableRow(row, data.getRowStyle());
            CellStyle defaultCellStyle = null == data.getRowStyle() ? null : data.getRowStyle().getDefaultCellStyle();
            for (int i = 0; i < size; ++i) {
                Helper.renderCell(row.getCell(i), data.getCells().get(i), defaultCellStyle);
            }
        }

        public static void renderCell(XWPFTableCell cell, CellRenderData data, CellStyle defaultCellStyle) throws Exception {
            if (null == data) {
                return;
            }
            StyleUtils.styleTableCell(cell, defaultCellStyle);
            StyleUtils.styleTableCell(cell, data.getCellStyle());
            ArrayList<ParagraphStyle> defaultParaStyles = new ArrayList<ParagraphStyle>();
            if (null != defaultCellStyle) {
                defaultParaStyles.add(defaultCellStyle.getDefaultParagraphStyle());
            } else if (null != data.getCellStyle()) {
                defaultParaStyles.add(data.getCellStyle().getDefaultParagraphStyle());
            }
            List<ParagraphRenderData> contents = data.getParagraphs();
            if (null != contents && !contents.isEmpty()) {
                BodyContainer bodyContainer = BodyContainerFactory.getBodyContainer((IBody)cell);
                XWPFParagraph placeHolder = cell.getParagraphArray(0);
                if (null == placeHolder) {
                    placeHolder = cell.addParagraph();
                }
                for (ParagraphRenderData item : contents) {
                    XWPFParagraph paragraph = bodyContainer.insertNewParagraph(placeHolder.getCTP().newCursor());
                    ParagraphRenderPolicy.Helper.renderParagraph(paragraph.createRun(), item, defaultParaStyles);
                }
                List paragraphs = cell.getParagraphs();
                int pos = paragraphs.indexOf(placeHolder);
                if (-1 != pos) {
                    cell.removeParagraph(pos);
                }
            }
        }

        private static void applyMergeRule(XWPFTable table, MergeCellRule mergeRule) {
            if (null == mergeRule) {
                return;
            }
            byte[][] markRemovedCell = new byte[TableTools.obtainRowSize(table)][TableTools.obtainColumnSize(table)];
            Iterator<Map.Entry<MergeCellRule.Grid, MergeCellRule.Grid>> iterator = mergeRule.mappingIterator();
            while (iterator.hasNext()) {
                int endJ;
                Map.Entry<MergeCellRule.Grid, MergeCellRule.Grid> next = iterator.next();
                MergeCellRule.Grid key = next.getKey();
                MergeCellRule.Grid value = next.getValue();
                int startI = key.getI() > value.getI() ? value.getI() : key.getI();
                int startJ = key.getJ() > value.getJ() ? value.getJ() : key.getJ();
                int endI = key.getI() > value.getI() ? key.getI() : value.getI();
                int n = endJ = key.getJ() > value.getJ() ? key.getJ() : value.getJ();
                if (startI != endI) {
                    for (int j = startJ; j <= endJ; ++j) {
                        TableTools.mergeCellsVertically(table, j, startI, endI);
                    }
                }
                if (startJ == endJ) continue;
                for (int i = startI; i <= endI; ++i) {
                    TableTools.mergeCellsHorizontalWithoutRemove(table, i, startJ, endJ);
                    for (int removedCol = startJ + 1; removedCol <= endJ; ++removedCol) {
                        markRemovedCell[i][removedCol] = 1;
                    }
                }
            }
            for (int i = 0; i < markRemovedCell.length; ++i) {
                for (int j = markRemovedCell[i].length - 1; j >= 0; --j) {
                    if (markRemovedCell[i][j] < 1) continue;
                    table.getRow(i).removeCell(j);
                    if (table.getRow(i).getTableCells().size() == table.getRow(i).getCtRow().sizeOfTcArray()) continue;
                    table.getRow(i).getCtRow().removeTc(j);
                }
            }
        }
    }
}

