/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class PictureRenderPolicy
extends AbstractRenderPolicy<PictureRenderData> {
    @Override
    protected boolean validate(PictureRenderData data) {
        if (null == data) {
            return false;
        }
        if (null == data.getPictureType()) {
            throw new RenderException("PictureRenderData must set picture type!");
        }
        return true;
    }

    @Override
    public void doRender(RenderContext<PictureRenderData> context) throws Exception {
        Helper.renderPicture(context.getRun(), context.getData());
    }

    @Override
    protected void afterRender(RenderContext<PictureRenderData> context) {
        this.clearPlaceholder(context, false);
    }

    @Override
    protected void reThrowException(RenderContext<PictureRenderData> context, Exception e) {
        this.logger.info("Render picture " + context.getEleTemplate() + " error: {}", (Object)e.getMessage());
        context.getRun().setText(context.getData().getAltMeta(), 0);
    }

    public static class Helper {
        public static void renderPicture(XWPFRun run, PictureRenderData picture) throws Exception {
            if (null == picture.getImage()) {
                throw new IllegalStateException("Can't get input data from picture!");
            }
            try (ByteArrayInputStream stream = new ByteArrayInputStream(picture.getImage());){
                run.addPicture((InputStream)stream, picture.getPictureType().type(), "Generated", Units.pixelToEMU((int)picture.getWidth()), Units.pixelToEMU((int)picture.getHeight()));
            }
        }
    }
}

