/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

import com.deepoove.poi.data.Cells;
import com.deepoove.poi.data.MergeCellRule;
import com.deepoove.poi.data.RenderDataBuilder;
import com.deepoove.poi.data.RowRenderData;
import com.deepoove.poi.data.Rows;
import com.deepoove.poi.data.TableRenderData;
import com.deepoove.poi.data.style.TableStyle;
import com.deepoove.poi.util.UnitUtils;
import java.util.Arrays;
import org.apache.poi.xwpf.usermodel.TableRowAlign;

public class Tables {
    private Tables() {
    }

    public static TableBuilder of(RowRenderData ... row) {
        TableBuilder inst = Tables.ofA4Width();
        if (null != row) {
            Arrays.stream(row).forEach(inst::addRow);
        }
        return inst;
    }

    public static TableBuilder of(String[][] strings) {
        TableBuilder inst = Tables.ofA4Width();
        if (null != strings) {
            Arrays.stream(strings).map(string -> {
                Rows.RowBuilder row = Rows.of();
                Arrays.stream(string).map(text -> Cells.of(text).create()).forEach(row::addCell);
                return row.create();
            }).forEach(inst::addRow);
        }
        return inst;
    }

    public static TableBuilder ofWidth(double cm) {
        return Tables.ofWidth(cm, null);
    }

    public static TableBuilder ofA4Width() {
        return Tables.ofWidth(14.63f);
    }

    public static TableBuilder ofA4NarrowWidth() {
        return Tables.ofWidth(18.45f);
    }

    public static TableBuilder ofA4MediumWidth() {
        return Tables.ofWidth(17.17f);
    }

    public static TableBuilder ofA4ExtendWidth() {
        return Tables.ofWidth(10.83f);
    }

    public static TableBuilder ofWidth(double cmWidth, double[] colCmWidths) {
        TableBuilder inst = new TableBuilder();
        inst.width(cmWidth, colCmWidths);
        return inst;
    }

    public static TableBuilder ofPercentWidth(String percent) {
        TableBuilder inst = new TableBuilder();
        TableStyle style = new TableStyle();
        style.setWidth(percent);
        inst.data.setTableStyle(style);
        return inst;
    }

    public static TableRenderData create(RowRenderData ... row) {
        return Tables.of(row).create();
    }

    public static TableBuilder ofAutoWidth() {
        return Tables.ofPercentWidth("auto");
    }

    public static class TableBuilder
    implements RenderDataBuilder<TableRenderData> {
        private TableRenderData data = new TableRenderData();

        private TableBuilder() {
        }

        public TableBuilder width(double cmWidth, double[] colCmWidths) {
            TableStyle style = this.getTableStyle();
            style.setWidth(UnitUtils.cm2Twips(cmWidth) + "");
            if (null != colCmWidths) {
                int[] colWidths = Arrays.stream(colCmWidths).mapToInt(UnitUtils::cm2Twips).toArray();
                style.setColWidths(colWidths);
            }
            return this;
        }

        private TableStyle getTableStyle() {
            TableStyle style = this.data.getTableStyle();
            if (null == style) {
                style = new TableStyle();
                this.data.setTableStyle(style);
            }
            return style;
        }

        public TableBuilder center() {
            TableStyle style = this.getTableStyle();
            style.setAlign(TableRowAlign.CENTER);
            return this;
        }

        public TableBuilder border(TableStyle.BorderStyle border) {
            this.getTableStyle().setLeftBorder(border);
            this.getTableStyle().setRightBorder(border);
            this.getTableStyle().setTopBorder(border);
            this.getTableStyle().setBottomBorder(border);
            this.getTableStyle().setInsideHBorder(border);
            this.getTableStyle().setInsideVBorder(border);
            return this;
        }

        public TableBuilder addRow(RowRenderData row) {
            this.data.addRow(row);
            return this;
        }

        public TableBuilder mergeRule(MergeCellRule rule) {
            this.data.setMergeRule(rule);
            return this;
        }

        @Override
        public TableRenderData create() {
            return this.data;
        }
    }
}

