/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

import com.deepoove.poi.data.PictureType;
import com.deepoove.poi.data.RenderData;
import com.deepoove.poi.util.BufferedImageUtils;
import com.deepoove.poi.util.ByteUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;

public class PictureRenderData
implements RenderData {
    private static final long serialVersionUID = 1L;
    private int width;
    private int height;
    private byte[] image;
    private PictureType pictureType;
    private String altMeta = "";

    PictureRenderData() {
    }

    public PictureRenderData(int width, int height, String path) {
        this(width, height, new File(path));
    }

    public PictureRenderData(int width, int height, File picture) {
        this(width, height, PictureType.suggestFileType(picture.getPath()), ByteUtils.getLocalByteArray(picture));
    }

    public PictureRenderData(int width, int height, PictureType pictureType, InputStream inputStream) {
        this(width, height, pictureType, ByteUtils.toByteArray(inputStream));
    }

    public PictureRenderData(int width, int height, PictureType pictureType, BufferedImage image) {
        this(width, height, pictureType, BufferedImageUtils.getBufferByteArray(image, pictureType.format()));
    }

    public PictureRenderData(int width, int height, PictureType pictureType, byte[] data) {
        this.width = width;
        this.height = height;
        this.pictureType = pictureType;
        this.image = data;
    }

    @Deprecated
    public PictureRenderData(int width, int height, String format, InputStream input) {
        this(width, height, format, ByteUtils.toByteArray(input));
    }

    @Deprecated
    public PictureRenderData(int width, int height, String format, BufferedImage image) {
        this(width, height, format, BufferedImageUtils.getBufferByteArray(image, format));
    }

    @Deprecated
    public PictureRenderData(int width, int height, String format, byte[] data) {
        this.width = width;
        this.height = height;
        this.pictureType = PictureType.suggestFileType(format);
        this.image = data;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public byte[] getImage() {
        return this.image;
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    public String getAltMeta() {
        return this.altMeta;
    }

    public void setAltMeta(String altMeta) {
        this.altMeta = altMeta;
    }

    public PictureType getPictureType() {
        return this.pictureType;
    }

    public void setPictureType(PictureType pictureType) {
        this.pictureType = pictureType;
    }
}

