/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.template.run.RunTemplate;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class PictureRenderPolicy
extends AbstractRenderPolicy<PictureRenderData> {
    @Override
    protected boolean validate(PictureRenderData data) {
        return null != data.getData() || null != data.getPath();
    }

    @Override
    public void doRender(RunTemplate runTemplate, PictureRenderData picture, XWPFTemplate template) throws Exception {
        XWPFRun run = runTemplate.getRun();
        Helper.renderPicture(run, picture);
    }

    @Override
    protected void afterRender(RenderContext context) {
        this.clearPlaceholder(context, false);
    }

    @Override
    protected void doRenderException(RunTemplate runTemplate, PictureRenderData data, Exception e) {
        logger.info("Render picture " + runTemplate + " error: {}", (Object)e.getMessage());
        runTemplate.getRun().setText(data.getAltMeta(), 0);
    }

    public static class Helper {
        public static final int EMU = 9525;

        public static void renderPicture(XWPFRun run, PictureRenderData picture) throws Exception {
            int suggestFileType = Helper.suggestFileType(picture.getPath());
            InputStream ins = null == picture.getData() ? new FileInputStream(picture.getPath()) : new ByteArrayInputStream(picture.getData());
            run.addPicture(ins, suggestFileType, "Generated", picture.getWidth() * 9525, picture.getHeight() * 9525);
        }

        public static int suggestFileType(String imgFile) {
            int format = 0;
            if (imgFile.endsWith(".emf")) {
                format = 2;
            } else if (imgFile.endsWith(".wmf")) {
                format = 3;
            } else if (imgFile.endsWith(".pict")) {
                format = 4;
            } else if (imgFile.endsWith(".jpeg") || imgFile.endsWith(".jpg")) {
                format = 5;
            } else if (imgFile.endsWith(".png")) {
                format = 6;
            } else if (imgFile.endsWith(".dib")) {
                format = 7;
            } else if (imgFile.endsWith(".gif")) {
                format = 8;
            } else if (imgFile.endsWith(".tiff")) {
                format = 9;
            } else if (imgFile.endsWith(".eps")) {
                format = 10;
            } else if (imgFile.endsWith(".bmp")) {
                format = 11;
            } else if (imgFile.endsWith(".wpg")) {
                format = 12;
            } else {
                throw new RenderException("Unsupported picture: " + imgFile + ". Expected emf|wmf|pict|jpeg|png|dib|gif|tiff|eps|bmp|wpg");
            }
            return format;
        }
    }
}

