/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.data.NumbericRenderData;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.data.style.Style;
import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.template.run.RunTemplate;
import com.deepoove.poi.util.StyleUtils;
import java.math.BigInteger;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTParaRPr;

public class NumbericRenderPolicy
extends AbstractRenderPolicy<NumbericRenderData> {
    @Override
    protected boolean validate(NumbericRenderData data) {
        if (CollectionUtils.isEmpty(data.getNumbers())) {
            logger.debug("Empty NumbericRenderData datamodel: {}", (Object)data);
            return false;
        }
        return true;
    }

    @Override
    public void doRender(RunTemplate runTemplate, NumbericRenderData numbericData, XWPFTemplate template) throws Exception {
        XWPFRun run = runTemplate.getRun();
        Helper.renderNumberic(run, numbericData);
    }

    @Override
    protected void afterRender(RenderContext context) {
        this.clearPlaceholder(context, true);
    }

    public static class Helper {
        public static void renderNumberic(XWPFRun run, NumbericRenderData numbericData) {
            NiceXWPFDocument doc = (NiceXWPFDocument)run.getParent().getDocument();
            List<TextRenderData> datas = numbericData.getNumbers();
            Style fmtStyle = numbericData.getFmtStyle();
            BigInteger numID = doc.addNewNumbericId(numbericData.getNumFmt());
            for (TextRenderData line : datas) {
                XWPFParagraph paragraph = doc.insertNewParagraph(run);
                paragraph.setNumID(numID);
                CTP ctp = paragraph.getCTP();
                CTPPr pPr = ctp.isSetPPr() ? ctp.getPPr() : ctp.addNewPPr();
                CTParaRPr pr = pPr.isSetRPr() ? pPr.getRPr() : pPr.addNewRPr();
                StyleUtils.styleRpr(pr, fmtStyle);
                XWPFRun newRun = paragraph.createRun();
                StyleUtils.styleRun(newRun, line.getStyle());
                newRun.setText(line.getText());
            }
        }
    }
}

