/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.data.CellRenderData;
import com.deepoove.poi.data.MiniTableRenderData;
import com.deepoove.poi.data.RowRenderData;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.data.style.TableStyle;
import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.policy.TextRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.template.run.RunTemplate;
import com.deepoove.poi.util.ObjectUtils;
import com.deepoove.poi.util.StyleUtils;
import com.deepoove.poi.util.TableTools;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;

public class MiniTableRenderPolicy
extends AbstractRenderPolicy<MiniTableRenderData> {
    @Override
    protected boolean validate(MiniTableRenderData data) {
        if (!data.isSetBody() && !data.isSetHeader()) {
            logger.debug("Empty MiniTableRenderData datamodel: {}", (Object)data);
            return false;
        }
        return true;
    }

    @Override
    public void doRender(RunTemplate runTemplate, MiniTableRenderData data, XWPFTemplate template) throws Exception {
        NiceXWPFDocument doc = template.getXWPFDocument();
        XWPFRun run = runTemplate.getRun();
        if (!data.isSetBody()) {
            this.renderNoDataTable(doc, run, data);
        } else {
            this.renderTable(doc, run, data);
        }
    }

    @Override
    protected void afterRender(RenderContext context) {
        this.clearPlaceholder(context, true);
    }

    private void renderTable(NiceXWPFDocument doc, XWPFRun run, MiniTableRenderData tableData) {
        int row = tableData.getDatas().size();
        int col = 0;
        if (!tableData.isSetHeader()) {
            col = this.getMaxColumFromData(tableData.getDatas());
        } else {
            ++row;
            col = tableData.getHeader().size();
        }
        XWPFTable table = doc.insertNewTable(run, row, col);
        this.initBasicTable(table, col, tableData.getWidth(), tableData.getStyle());
        int startRow = 0;
        if (tableData.isSetHeader()) {
            Helper.renderRow(table, startRow++, tableData.getHeader());
        }
        for (RowRenderData data : tableData.getDatas()) {
            Helper.renderRow(table, startRow++, data);
        }
    }

    private void renderNoDataTable(NiceXWPFDocument doc, XWPFRun run, MiniTableRenderData tableData) {
        int row = 2;
        int col = tableData.getHeader().size();
        XWPFTable table = doc.insertNewTable(run, row, col);
        this.initBasicTable(table, col, tableData.getWidth(), tableData.getStyle());
        Helper.renderRow(table, 0, tableData.getHeader());
        TableTools.mergeCellsHorizonal(table, 1, 0, tableData.getHeader().size() - 1);
        XWPFTableCell cell = table.getRow(1).getCell(0);
        cell.setText(tableData.getNoDatadesc());
    }

    private void initBasicTable(XWPFTable table, int col, float width, TableStyle style) {
        TableTools.widthTable(table, width, col);
        TableTools.borderTable(table, 4);
        StyleUtils.styleTable(table, style);
    }

    private int getMaxColumFromData(List<RowRenderData> datas) {
        int maxColom = 0;
        for (RowRenderData obj : datas) {
            if (null == obj || obj.size() <= maxColom) continue;
            maxColom = obj.size();
        }
        return maxColom;
    }

    public static class Helper {
        public static void renderRow(XWPFTable table, int row, RowRenderData rowData) {
            if (null == rowData || rowData.size() <= 0) {
                return;
            }
            XWPFTableRow tableRow = table.getRow(row);
            ObjectUtils.requireNonNull(tableRow, "Row " + row + " do not exist in the table");
            TableStyle rowStyle = rowData.getRowStyle();
            List<CellRenderData> cellList = rowData.getCellDatas();
            XWPFTableCell cell = null;
            for (int i = 0; i < cellList.size(); ++i) {
                cell = tableRow.getCell(i);
                if (null == cell) {
                    RenderPolicy.logger.warn("Extra cell data at row {}, but no extra cell: col {}", (Object)row, (Object)cell);
                    break;
                }
                Helper.renderCell(cell, cellList.get(i), rowStyle);
            }
        }

        public static void renderCell(XWPFTableCell cell, CellRenderData cellData, TableStyle rowStyle) {
            TextRenderData renderData;
            String cellText;
            TableStyle cellStyle;
            TableStyle tableStyle = cellStyle = null == cellData.getCellStyle() ? rowStyle : cellData.getCellStyle();
            if (null != cellStyle && null != cellStyle.getBackgroundColor()) {
                cell.setColor(cellStyle.getBackgroundColor());
            }
            if (StringUtils.isBlank((CharSequence)(cellText = (renderData = cellData.getRenderData()).getText()))) {
                return;
            }
            CTTc ctTc = cell.getCTTc();
            CTP ctP = ctTc.sizeOfPArray() == 0 ? ctTc.addNewP() : ctTc.getPArray(0);
            XWPFParagraph par = new XWPFParagraph(ctP, (IBody)cell);
            StyleUtils.styleTableParagraph(par, cellStyle);
            String text = renderData.getText();
            String[] fragment = text.split("\\n", -1);
            if (fragment.length <= 1) {
                TextRenderPolicy.Helper.renderTextRun(par.createRun(), renderData);
            } else {
                for (int j = 0; j < fragment.length; ++j) {
                    if (0 != j) {
                        par = cell.addParagraph();
                        StyleUtils.styleTableParagraph(par, cellStyle);
                    }
                    XWPFRun run = par.createRun();
                    StyleUtils.styleRun(run, renderData.getStyle());
                    run.setText(fragment[j]);
                }
            }
        }
    }
}

