/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public abstract class AbstractRenderPolicy<T>
implements RenderPolicy {
    protected boolean validate(T data) {
        return true;
    }

    protected void doValidError(RenderContext context) {
        logger.debug("Validate the data of the element {} error, the data may be null or empty: {}", (Object)context.getEleTemplate().getSource(), context.getData());
        if (context.getTemplate().getConfig().isNullToBlank()) {
            logger.debug("[config.isNullToBlank == true] clear the element {} from the word file.", (Object)context.getEleTemplate().getSource());
            this.clearPlaceholder(context, false);
        } else {
            logger.debug("The element {} Unable to be rendered, nothing to do.", (Object)context.getEleTemplate().getSource());
        }
    }

    protected void beforeRender(RenderContext context) {
    }

    protected void afterRender(RenderContext context) {
    }

    public abstract void doRender(RunTemplate var1, T var2, XWPFTemplate var3) throws Exception;

    @Override
    public void render(ElementTemplate eleTemplate, Object data, XWPFTemplate template) {
        RunTemplate runTemplate = (RunTemplate)eleTemplate;
        Object model = null;
        try {
            model = data;
        }
        catch (ClassCastException e) {
            throw new RenderException("Error Render Data format for template: " + eleTemplate.getSource(), e);
        }
        RenderContext context = new RenderContext(eleTemplate, data, template);
        if (null == model || !this.validate(model)) {
            this.doValidError(context);
            return;
        }
        try {
            this.beforeRender(context);
            this.doRender(runTemplate, model, template);
            this.afterRender(context);
        }
        catch (Exception e) {
            this.doRenderException(runTemplate, model, e);
        }
    }

    protected void doRenderException(RunTemplate runTemplate, T data, Exception e) {
        throw new RenderException("Render template:" + runTemplate + " error", e);
    }

    protected void clearPlaceholder(RenderContext context, boolean clearParagraph) {
        XWPFRun run = ((RunTemplate)context.getEleTemplate()).getRun();
        run.setText("", 0);
        IRunBody parent = run.getParent();
        if (clearParagraph && parent instanceof XWPFParagraph) {
            NiceXWPFDocument doc = context.getTemplate().getXWPFDocument();
            int posOfParagraph = doc.getPosOfParagraph((XWPFParagraph)parent);
            doc.removeBodyElement(posOfParagraph);
        }
    }
}

