/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi;

import java.lang.reflect.Field;
import java.util.List;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.IRunElement;
import org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XWPFParagraphWrapper {
    private static Logger logger = LoggerFactory.getLogger(XWPFParagraphWrapper.class);
    XWPFParagraph paragraph;

    public XWPFParagraphWrapper(XWPFParagraph paragraph) {
        this.paragraph = paragraph;
    }

    public XWPFHyperlinkRun createHyperLinkRun(String link) {
        PackageRelationship relationship = this.paragraph.getDocument().getPackagePart().addExternalRelationship(link, XWPFRelation.HYPERLINK.getRelation());
        CTHyperlink hyperlink = this.paragraph.getCTP().addNewHyperlink();
        hyperlink.setId(relationship.getId());
        CTR ctr = hyperlink.addNewR();
        XWPFHyperlinkRun xwpfRun = new XWPFHyperlinkRun(hyperlink, ctr, (IRunBody)this.paragraph);
        this.getRuns().add((XWPFRun)xwpfRun);
        this.getIRuns().add((IRunElement)xwpfRun);
        return xwpfRun;
    }

    public XWPFRun insertNewHyperLinkRun(int pos, String link) {
        if (pos >= 0 && pos <= this.paragraph.getRuns().size()) {
            XWPFRun oldAtPos;
            int oldAt;
            PackageRelationship relationship = this.paragraph.getDocument().getPackagePart().addExternalRelationship(link, XWPFRelation.HYPERLINK.getRelation());
            CTHyperlink hyperlink = this.paragraph.getCTP().insertNewHyperlink(pos);
            hyperlink.setId(relationship.getId());
            CTR ctr = hyperlink.addNewR();
            XWPFHyperlinkRun newRun = new XWPFHyperlinkRun(hyperlink, ctr, (IRunBody)this.paragraph);
            List<IRunElement> iruns = this.getIRuns();
            List<XWPFRun> runs = this.getRuns();
            int iPos = iruns.size();
            if (pos < runs.size() && (oldAt = iruns.indexOf(oldAtPos = runs.get(pos))) != -1) {
                iPos = oldAt;
            }
            iruns.add(iPos, (IRunElement)newRun);
            runs.add(pos, (XWPFRun)newRun);
            return newRun;
        }
        return null;
    }

    private List<XWPFRun> getRuns() {
        try {
            Field runsField = XWPFParagraph.class.getDeclaredField("runs");
            runsField.setAccessible(true);
            return (List)runsField.get(this.paragraph);
        }
        catch (Exception e) {
            logger.error("Cannot get XWPFParagraph'runs", (Throwable)e);
            return null;
        }
    }

    private List<IRunElement> getIRuns() {
        try {
            Field runsField = XWPFParagraph.class.getDeclaredField("iruns");
            runsField.setAccessible(true);
            return (List)runsField.get(this.paragraph);
        }
        catch (Exception e) {
            logger.error("Cannot get XWPFParagraph'iRuns", (Throwable)e);
            return null;
        }
    }
}

