/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.plugin.field;

import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.template.run.RunTemplate;
import com.deepoove.poi.util.StyleUtils;
import com.deepoove.poi.xwpf.XWPFParagraphWrapper;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFldChar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STFldCharType;

public class SimpleFieldRenderPolicy
extends AbstractRenderPolicy<String> {
    @Override
    public void doRender(RenderContext<String> context) throws Exception {
        RunTemplate runTemplate = (RunTemplate)context.getEleTemplate();
        XWPFRun run = context.getRun();
        run.setText("", 0);
        XWPFParagraph paragraph = (XWPFParagraph)run.getParent();
        XWPFParagraphWrapper paragraphWrapper = new XWPFParagraphWrapper(paragraph);
        XWPFRun startRun = paragraphWrapper.insertNewRun(runTemplate.getRunPos());
        StyleUtils.styleRun(startRun, run);
        CTR ctr = startRun.getCTR();
        CTFldChar addNewFldChar = ctr.addNewFldChar();
        addNewFldChar.setFldCharType(STFldCharType.BEGIN);
        XWPFRun instrRun = paragraphWrapper.insertNewRun(runTemplate.getRunPos());
        StyleUtils.styleRun(instrRun, run);
        ctr = instrRun.getCTR();
        CTText addNewInstrText = ctr.addNewInstrText();
        addNewInstrText.setStringValue(context.getData());
        XWPFRun sepRun = paragraphWrapper.insertNewRun(runTemplate.getRunPos());
        StyleUtils.styleRun(sepRun, run);
        ctr = sepRun.getCTR();
        addNewFldChar = ctr.addNewFldChar();
        addNewFldChar.setFldCharType(STFldCharType.SEPARATE);
        XWPFRun endRun = paragraphWrapper.insertNewRun(runTemplate.getRunPos());
        StyleUtils.styleRun(endRun, run);
        ctr = endRun.getCTR();
        addNewFldChar = ctr.addNewFldChar();
        addNewFldChar.setFldCharType(STFldCharType.END);
    }
}

