/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.data.AttachmentRenderData;
import com.deepoove.poi.data.AttachmentType;
import com.deepoove.poi.data.RenderDataBuilder;
import com.deepoove.poi.exception.ResolverException;
import com.deepoove.poi.util.ByteUtils;
import com.deepoove.poi.util.PoitlIOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.ooxml.POIXMLDocument;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class Attachments {
    private Attachments() {
    }

    public static AttachmentBuilder ofLocal(String src, AttachmentType fileType) {
        return Attachments.ofBytes(ByteUtils.getLocalByteArray(new File(src)), fileType);
    }

    public static AttachmentBuilder ofWord(XWPFDocument src) {
        try {
            return Attachments.ofStream(PoitlIOUtils.docToInputStream((POIXMLDocument)src), AttachmentType.DOCX);
        }
        catch (IOException e) {
            throw new ResolverException("Cannot compile attachment document", e);
        }
    }

    public static AttachmentBuilder ofWordTemplate(XWPFTemplate src) {
        try {
            return Attachments.ofStream(PoitlIOUtils.templateToInputStream(src), AttachmentType.DOCX);
        }
        catch (IOException e) {
            throw new ResolverException("Cannot compile attachment document", e);
        }
    }

    public static AttachmentBuilder ofWorkbook(XSSFWorkbook src) {
        try {
            return Attachments.ofStream(PoitlIOUtils.docToInputStream((POIXMLDocument)src), AttachmentType.XLSX);
        }
        catch (IOException e) {
            throw new ResolverException("Cannot compile attachment document", e);
        }
    }

    public static AttachmentBuilder ofStream(InputStream inputStream, AttachmentType fileType) {
        return Attachments.ofBytes(ByteUtils.toByteArray(inputStream), fileType);
    }

    public static AttachmentBuilder ofBytes(byte[] bytes, AttachmentType fileType) {
        return new AttachmentBuilder(bytes, fileType);
    }

    public static class AttachmentBuilder
    implements RenderDataBuilder<AttachmentRenderData> {
        AttachmentRenderData data;

        private AttachmentBuilder(byte[] bytes, AttachmentType fileType) {
            this.data = new AttachmentRenderData(bytes);
            this.data.setFileType(fileType);
        }

        @Override
        public AttachmentRenderData create() {
            return this.data;
        }
    }
}

