/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.util.StringUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class DmdbPooledConnection
implements PooledConnection {
    private Map<ConnectionEventListener, ConnectionEventListener> connectionEventListeners = new HashMap<ConnectionEventListener, ConnectionEventListener>();
    private Map<StatementEventListener, StatementEventListener> statementEventListeners = new HashMap<StatementEventListener, StatementEventListener>();
    protected Connection connection;
    private Connection logicConnection;

    public DmdbPooledConnection(Connection connection) throws SQLException {
        this.connection = connection;
        this.logicConnection = this.createConnectionProxy(connection);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.logicConnection;
    }

    @Override
    public synchronized void close() throws SQLException {
        this.connection.close();
        this.connection = null;
        this.logicConnection = null;
    }

    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.put(listener, listener);
    }

    @Override
    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.remove(listener);
    }

    @Override
    public synchronized void addStatementEventListener(StatementEventListener listener) {
        this.statementEventListeners.put(listener, listener);
    }

    @Override
    public synchronized void removeStatementEventListener(StatementEventListener listener) {
        this.statementEventListeners.remove(listener);
    }

    private synchronized void fireConnectionEvent(boolean closed, SQLException e2) {
        Iterator<Map.Entry<ConnectionEventListener, ConnectionEventListener>> iterator = this.connectionEventListeners.entrySet().iterator();
        while (iterator.hasNext()) {
            ConnectionEventListener listener = iterator.next().getValue();
            if (closed) {
                listener.connectionClosed(new ConnectionEvent(this, e2));
                continue;
            }
            listener.connectionErrorOccurred(new ConnectionEvent(this, e2));
        }
    }

    private synchronized void fireStatementEvent(PreparedStatement pstmt, boolean closed, SQLException e2) {
        Iterator<Map.Entry<StatementEventListener, StatementEventListener>> iterator = this.statementEventListeners.entrySet().iterator();
        while (iterator.hasNext()) {
            StatementEventListener listener = iterator.next().getValue();
            if (closed) {
                listener.statementClosed(new StatementEvent(this, pstmt));
                continue;
            }
            listener.statementErrorOccurred(new StatementEvent(this, pstmt, e2));
        }
    }

    private Connection createConnectionProxy(final Connection connection) {
        return (Connection)Proxy.newProxyInstance(connection.getClass().getClassLoader(), connection.getClass().getInterfaces(), new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String mname = method.getName();
                if (StringUtil.equals(mname, "close")) {
                    DmdbPooledConnection.this.fireConnectionEvent(true, null);
                    return null;
                }
                Object ret = null;
                try {
                    ret = method.invoke((Object)connection, args);
                }
                catch (InvocationTargetException e2) {
                    int errCode;
                    Throwable cause = e2.getCause();
                    if (cause instanceof SQLException && ((errCode = ((SQLException)cause).getErrorCode()) == DBError.ECJDBC_CONNECTION_CLOSED.errCode || errCode == DBError.ECJDBC_COMMUNITION_ERROR.errCode)) {
                        DmdbPooledConnection.this.fireConnectionEvent(false, (SQLException)cause);
                    }
                    throw cause;
                }
                if (ret instanceof PreparedStatement) {
                    ret = DmdbPooledConnection.this.createPreparedStatamentProxy((PreparedStatement)ret);
                }
                return ret;
            }
        });
    }

    private PreparedStatement createPreparedStatamentProxy(final PreparedStatement pstmt) {
        return (PreparedStatement)Proxy.newProxyInstance(pstmt.getClass().getClassLoader(), pstmt.getClass().getInterfaces(), new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String mname = method.getName();
                if (StringUtil.equals(mname, "close")) {
                    DmdbPooledConnection.this.fireStatementEvent((PreparedStatement)proxy, true, null);
                }
                Object ret = null;
                try {
                    ret = method.invoke((Object)pstmt, args);
                }
                catch (InvocationTargetException e2) {
                    int errCode;
                    Throwable cause = e2.getCause();
                    if (cause instanceof SQLException && ((errCode = ((SQLException)cause).getErrorCode()) == DBError.ECJDBC_CONNECTION_CLOSED.errCode || errCode == DBError.ECJDBC_COMMUNITION_ERROR.errCode)) {
                        DmdbPooledConnection.this.fireStatementEvent((PreparedStatement)proxy, false, (SQLException)cause);
                    }
                    throw cause;
                }
                return ret;
            }
        });
    }
}

