/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbArray;
import dm.jdbc.driver.DmdbBFile;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbReader;
import dm.jdbc.driver.DmdbRef;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbSQLOutput;
import dm.jdbc.driver.DmdbSQLXML;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbStruct;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.internal.convert.DB2J;
import dm.jdbc.internal.convert.J2DB;
import dm.jdbc.internal.convert.OffRowData;
import dm.jdbc.internal.desc.ComplexTypeDesc;
import dm.jdbc.internal.desc.ExecuteRetInfo;
import dm.jdbc.internal.desc.Parameter;
import dm.jdbc.util.MiscUtil;
import dm.jdbc.util.StringUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Map;

public class DmdbCallableStatement
extends DmdbPreparedStatement
implements CallableStatement {
    private boolean wasNull;
    private int nameBindCount = 0;
    public boolean nameBindAtLeast;
    public boolean ordinalBindAtLeast;
    public boolean hasDefault;

    public DmdbCallableStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean fromPool) throws SQLException {
        super(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability, fromPool);
    }

    @Override
    protected void prepareSql(String sql) throws SQLException {
        super.prepareSql(sql);
        Parameter[] parameterArray = this.serverParameters;
        int n2 = this.serverParameters.length;
        int n3 = 0;
        while (n3 < n2) {
            Parameter param = parameterArray[n3];
            if (param != null && param.hasDefault) {
                this.hasDefault = true;
                break;
            }
            ++n3;
        }
    }

    @Override
    public int do_getUpdateCount() {
        boolean hasCursor = false;
        Parameter[] parameterArray = this.bindParameters;
        int n2 = this.bindParameters.length;
        int n3 = 0;
        while (n3 < n2) {
            Parameter param = parameterArray[n3];
            if (param.type == 120) {
                hasCursor = true;
                break;
            }
            ++n3;
        }
        return hasCursor ? -1 : super.do_getUpdateCount();
    }

    @Override
    public void do_clearParameters() {
        super.do_clearParameters();
        if (this.multiRowDatas.size() == 0) {
            this.nameBindCount = 0;
            this.nameBindAtLeast = false;
            this.ordinalBindAtLeast = false;
        }
    }

    @Override
    protected void checkBindParameters() throws SQLException {
        if (this.nameBindAtLeast && this.ordinalBindAtLeast) {
            DBError.ECJDBC_NOT_ALLOWED_OPTION.throwz("Ordinal binding and Named binding cannot be combined!");
        }
        int iparam = 0;
        while (iparam < this.paramCount) {
            if (this.bindParameters[iparam].ioType == -1) {
                if (this.serverParameters[iparam] != null && this.serverParameters[iparam].ioType == 1) {
                    this.do_setNull(iparam + 1, 0);
                } else {
                    DBError.ECJDBC_UNBINDED_PARAMETER.throwz(iparam);
                }
            }
            if (this.bindParameters[iparam].type == 120) {
                this.bindParameters[iparam].ioType = (byte)2;
            } else if (this.ordinalBindAtLeast && this.serverParameters[iparam] != null && this.serverParameters[iparam].ioType != this.bindParameters[iparam].ioType) {
                this.bindParameters[iparam].ioType = this.serverParameters[iparam].ioType;
            }
            ++iparam;
        }
    }

    @Override
    protected void beforeExectueWithParameters(boolean batch) throws SQLException {
        super.beforeExectueWithParameters(batch);
        if (!this.hasPrepared) {
            return;
        }
        int i2 = 0;
        while (i2 < this.paramCount) {
            if (this.serverParameters[i2] != null && !StringUtil.equals(this.serverParameters[i2].name, this.bindParameters[i2].name)) {
                this.connection.dbAccess.a(this, this.bindParameters);
                break;
            }
            ++i2;
        }
    }

    protected int bindOutParam(int parameterIndex, int dtype) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
        }
        int icol = parameterIndex - 1;
        this.bindOutParamInternal(this.serverParameters[icol], this.bindParameters[icol], dtype);
        this.ordinalBindAtLeast = true;
        return icol;
    }

    protected int bindOutParam(String parameterName, int dtype) throws SQLException {
        Parameter serverParam = null;
        Parameter bindParam = null;
        int icol = -1;
        icol = this.findParameterInternal(this.serverParameters, parameterName);
        Parameter parameter = serverParam = icol < 0 ? null : this.serverParameters[icol];
        if (!(serverParam == null || this.hasDefault && this.connection.supportNameParameter)) {
            return this.bindOutParam(icol + 1, dtype);
        }
        if (!this.connection.supportNameParameter) {
            DBError.ECJDBC_INVALID_PARAMETER_NAME.throwz(parameterName);
        }
        Parameter parameter2 = bindParam = (icol = this.findParameterInternal(this.bindParameters, parameterName)) < 0 ? null : this.bindParameters[icol];
        if (bindParam == null) {
            if (this.nameBindCount == this.paramCount) {
                DBError.ECJDBC_INVALID_PARAMETER_NAME.throwz(parameterName);
            }
            icol = this.nameBindCount++;
            bindParam = this.bindParameters[icol];
        }
        bindParam.name = parameterName;
        this.bindOutParamInternal(serverParam, bindParam, dtype);
        this.nameBindAtLeast = true;
        return icol;
    }

    protected void bindOutParamInternal(Parameter serverParam, Parameter bindParam, int dtype) throws SQLException {
        if (this.irow > 0) {
            return;
        }
        if (bindParam.ioType == 1 || bindParam.ioType == -1) {
            if (serverParam == null) {
                bindParam.resetType(dtype);
            } else {
                bindParam.name = serverParam.name;
                bindParam.typeDescriptor = serverParam.typeDescriptor;
                bindParam.mask = serverParam.mask;
                bindParam.typeFlag = serverParam.typeFlag;
                bindParam.recommendType(this.connection, serverParam, dtype, false);
            }
            if (bindParam.type == 120) {
                bindParam.ioType = (byte)2;
                if (bindParam.cursorStmt == null) {
                    bindParam.cursorStmt = this.connection.createCursorStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
                }
            }
        }
        bindParam.ioType = (byte)(bindParam.ioType == 0 || bindParam.ioType == 2 ? 2 : 1);
    }

    public void do_registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.do_registerOutParameter(parameterName, sqlType, -1, null);
    }

    public void do_registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.do_registerOutParameter(parameterName, sqlType, scale, null);
    }

    public void do_registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.do_registerOutParameter(parameterName, sqlType, -1, typeName);
    }

    public void do_registerOutParameter(String parameterName, int sqlType, int scale, String typeName) throws SQLException {
        int dtype = DmdbType.j2dType(sqlType);
        if (sqlType == 2003 || sqlType == 2002 || sqlType == 2000) {
            ComplexTypeDesc desc = new ComplexTypeDesc(typeName, this.connection);
            dtype = desc.getDType();
        }
        int icol = this.bindOutParam(parameterName, dtype);
        this.bindParameters[icol].outJType = this.bindParameters[icol].type == 120 ? 120 : sqlType;
        this.bindParameters[icol].outScale = scale;
        this.bindParameters[icol].outObjectName = typeName;
    }

    public void do_registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.do_registerOutParameter(parameterIndex, sqlType, -1, null);
    }

    public void do_registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.do_registerOutParameter(parameterIndex, sqlType, scale, null);
    }

    public void do_registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.do_registerOutParameter(parameterIndex, sqlType, -1, typeName);
    }

    public void do_registerOutParameter(int parameterIndex, int sqlType, int scale, String typeName) throws SQLException {
        int dtype = DmdbType.j2dType(sqlType);
        if (StringUtil.isNotEmpty(typeName) && (sqlType == 2003 || sqlType == 2002 || sqlType == 2000)) {
            ComplexTypeDesc desc = new ComplexTypeDesc(typeName, this.connection);
            dtype = desc.getDType();
        }
        int icol = this.bindOutParam(parameterIndex, dtype);
        this.bindParameters[icol].outJType = this.bindParameters[icol].type == 120 ? 120 : sqlType;
        this.bindParameters[icol].outScale = scale;
        this.bindParameters[parameterIndex - 1].outObjectName = typeName;
    }

    public void do_registerOutParameter(int parameterIndex, SQLType sqlType) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public void do_registerOutParameter(int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public void do_registerOutParameter(int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public void do_registerOutParameter(String parameterName, SQLType sqlType) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public void do_registerOutParameter(String parameterName, SQLType sqlType, int scale) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public void do_registerOutParameter(String parameterName, SQLType sqlType, String typeName) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public boolean do_wasNull() throws SQLException {
        return this.wasNull;
    }

    public int findParameter(String parameterName) throws SQLException {
        int iparam = this.findParameterInternal(this.bindParameters, parameterName);
        if (iparam == -1) {
            DBError.ECJDBC_INVALID_PARAMETER_NAME.throwz(parameterName);
        }
        return iparam + 1;
    }

    private int findParameterInternal(Parameter[] parameters, String parameterName) throws SQLException {
        int iparam = -1;
        int i2 = 0;
        while (i2 < parameters.length) {
            if (parameters[i2] != null && (StringUtil.equals(parameters[i2].name, parameterName) || this.connection.getIgnoreCase() && StringUtil.equalsIgnoreCase(parameters[i2].name, parameterName))) {
                iparam = i2;
                break;
            }
            ++i2;
        }
        return iparam;
    }

    public boolean do_getBoolean(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getBoolean(parameterIndex);
    }

    public byte do_getByte(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getByte(parameterIndex);
    }

    public short do_getShort(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getShort(parameterIndex);
    }

    public int do_getInt(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getInt(parameterIndex);
    }

    public long do_getLong(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getLong(parameterIndex);
    }

    public float do_getFloat(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getFloat(parameterIndex);
    }

    public double do_getDouble(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getDouble(parameterIndex);
    }

    public BigDecimal do_getBigDecimal(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getBigDecimal(parameterIndex);
    }

    public byte[] do_getBytes(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getBytes(parameterIndex);
    }

    public String do_getString(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getString(parameterIndex);
    }

    public Date do_getDate(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getDate(parameterIndex);
    }

    public Date do_getDate(String parameterName, Calendar cal) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getDate(parameterIndex, cal);
    }

    public Time do_getTime(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getTime(parameterIndex);
    }

    public Time do_getTime(String parameterName, Calendar cal) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getTime(parameterIndex, cal);
    }

    public Timestamp do_getTimestamp(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getTimestamp(parameterIndex);
    }

    public Timestamp do_getTimestamp(String parameterName, Calendar cal) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getTimestamp(parameterIndex, cal);
    }

    public DmdbIntervalYM do_getINTERVALYM(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getINTERVALYM(parameterIndex);
    }

    public DmdbIntervalDT do_getINTERVALDT(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getINTERVALDT(parameterIndex);
    }

    public DmdbTimestamp do_getTIMESTAMP(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getTIMESTAMP(parameterIndex);
    }

    public DmdbBlob do_getBlob(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getBlob(parameterIndex);
    }

    public DmdbClob do_getClob(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getClob(parameterIndex);
    }

    public DmdbArray do_getArray(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getArray(parameterIndex);
    }

    public DmdbReader do_getCharacterStream(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getCharacterStream(parameterIndex);
    }

    public Object do_getObject(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getObject(parameterIndex);
    }

    public Object do_getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getObject(parameterIndex, map);
    }

    public ResultSet do_getCursor(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getCursor(parameterIndex);
    }

    public URL do_getURL(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getURL(parameterIndex);
    }

    public Ref do_getRef(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getRef(parameterIndex);
    }

    public String do_getNString(String parameterName) throws SQLException {
        return this.do_getString(parameterName);
    }

    public DmdbReader do_getNCharacterStream(String parameterName) throws SQLException {
        return this.do_getCharacterStream(parameterName);
    }

    public RowId do_getRowId(String parameterName) throws SQLException {
        return this.do_getRowId(this.findParameter(parameterName));
    }

    public NClob do_getNClob(String parameterName) throws SQLException {
        return (NClob)((Object)this.do_getClob(parameterName));
    }

    public SQLXML do_getSQLXML(String parameterName) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getSQLXML(parameterIndex);
    }

    public <T> T do_getObject(String parameterName, Class<T> type) throws SQLException {
        int parameterIndex = this.findParameter(parameterName);
        return this.do_getObject(parameterIndex, type);
    }

    @Override
    protected int bindInParam(int paramIndex, int dtype, boolean isNull) throws SQLException {
        int ret = super.bindInParam(paramIndex, dtype, isNull);
        this.ordinalBindAtLeast = true;
        return ret;
    }

    protected int bindInParam(String parameterName, int dtype, boolean isNull) throws SQLException {
        Parameter serverParam = null;
        Parameter bindParam = null;
        int icol = this.nameBindCount;
        icol = this.findParameterInternal(this.serverParameters, parameterName);
        Parameter parameter = serverParam = icol < 0 ? null : this.serverParameters[icol];
        if (!(serverParam == null || this.hasDefault && this.connection.supportNameParameter)) {
            return this.bindInParam(icol + 1, dtype, isNull);
        }
        if (!this.connection.supportNameParameter) {
            DBError.ECJDBC_INVALID_PARAMETER_NAME.throwz(parameterName);
        }
        Parameter parameter2 = bindParam = (icol = this.findParameterInternal(this.bindParameters, parameterName)) < 0 ? null : this.bindParameters[icol];
        if (bindParam == null) {
            if (this.nameBindCount == this.paramCount) {
                DBError.ECJDBC_INVALID_PARAMETER_NAME.throwz(parameterName);
            }
            icol = this.nameBindCount++;
            bindParam = this.bindParameters[icol];
        }
        bindParam.name = parameterName;
        this.bindInParamInternal(serverParam, bindParam, dtype, isNull);
        this.nameBindAtLeast = true;
        return icol;
    }

    public void do_setNull(String parameterName, int sqlType) throws SQLException {
        int icol = this.bindInParam(parameterName, DmdbType.j2dType(sqlType), true);
        this.curRowDatas[icol] = null;
    }

    public void do_setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.do_setNull(parameterName, sqlType);
    }

    public void do_setBoolean(String parameterName, boolean x2) throws SQLException {
        int icol = this.bindInParam(parameterName, 5, false);
        this.curRowDatas[icol] = J2DB.fromBoolean(x2, this.bindParameters[icol], this.connection);
    }

    public void do_setByte(String parameterName, byte x2) throws SQLException {
        int icol = this.bindInParam(parameterName, 5, false);
        this.curRowDatas[icol] = J2DB.fromLong(x2, this.bindParameters[icol], this.connection);
    }

    public void do_setShort(String parameterName, short x2) throws SQLException {
        int icol = this.bindInParam(parameterName, 6, false);
        this.curRowDatas[icol] = J2DB.fromLong(x2, this.bindParameters[icol], this.connection);
    }

    public void do_setInt(String parameterName, int x2) throws SQLException {
        int icol = this.bindInParam(parameterName, 7, false);
        this.curRowDatas[icol] = J2DB.fromLong(x2, this.bindParameters[icol], this.connection);
    }

    public void do_setLong(String parameterName, long x2) throws SQLException {
        int icol = this.bindInParam(parameterName, 8, false);
        this.curRowDatas[icol] = J2DB.fromLong(x2, this.bindParameters[icol], this.connection);
    }

    public void do_setFloat(String parameterName, float x2) throws SQLException {
        int icol = this.bindInParam(parameterName, 10, false);
        this.curRowDatas[icol] = J2DB.fromFloat(x2, this.bindParameters[icol], this.connection);
    }

    public void do_setDouble(String parameterName, double x2) throws SQLException {
        int icol = this.bindInParam(parameterName, 11, false);
        this.curRowDatas[icol] = J2DB.fromDouble(x2, this.bindParameters[icol], this.connection);
    }

    public void do_setBigDecimal(String parameterName, BigDecimal x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterName, 2);
            return;
        }
        int icol = this.bindInParam(parameterName, 2, false);
        this.curRowDatas[icol] = J2DB.fromBigDecimal(x2, this.bindParameters[icol], this.connection);
    }

    public void do_setString(String parameterName, String x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterName, 2);
            return;
        }
        int len = x2.length();
        int dtype = len < Short.MAX_VALUE ? 2 : 19;
        int icol = this.bindInParam(parameterName, dtype, false);
        this.curRowDatas[icol] = J2DB.fromString(x2, this.bindParameters[icol], this.connection);
    }

    public void do_setBytes(String parameterName, byte[] x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterName, 18);
            return;
        }
        int len = x2.length;
        int dtype = len < Short.MAX_VALUE ? 18 : 12;
        int icol = this.bindInParam(parameterName, dtype, false);
        this.curRowDatas[icol] = J2DB.fromBytes(x2, this.bindParameters[icol], this.connection);
    }

    public void do_setDate(String parameterName, Date x2) throws SQLException {
        this.do_setDate(parameterName, x2, null);
    }

    public void do_setDate(String parameterName, Date x2, Calendar cal) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterName, 14);
            return;
        }
        int icol = this.bindInParam(parameterName, 14, false);
        this.curRowDatas[icol] = J2DB.fromDate(x2, this.bindParameters[icol], this.connection, cal);
    }

    public void do_setTime(String parameterName, Time x2) throws SQLException {
        this.do_setTime(parameterName, x2, null);
    }

    public void do_setTime(String parameterName, Time x2, Calendar cal) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterName, 15);
            return;
        }
        int icol = this.bindInParam(parameterName, 15, false);
        this.curRowDatas[icol] = J2DB.fromDate(x2, this.bindParameters[icol], this.connection, cal);
    }

    public void do_setTimestamp(String parameterName, Timestamp x2) throws SQLException {
        this.do_setTimestamp(parameterName, x2, null);
    }

    public void do_setTimestamp(String parameterName, Timestamp x2, Calendar cal) throws SQLException {
        if (x2 instanceof DmdbTimestamp) {
            this.do_setTIMESTAMP(parameterName, (DmdbTimestamp)x2);
            return;
        }
        if (x2 == null) {
            this.do_setNull(parameterName, 16);
            return;
        }
        int icol = this.bindInParam(parameterName, 16, false);
        this.curRowDatas[icol] = J2DB.fromDate(x2, this.bindParameters[icol], this.connection, cal);
    }

    public void do_setTIMESTAMP(String parameterName, DmdbTimestamp x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterName, 16);
            return;
        }
        int icol = this.bindInParam(parameterName, 16, false);
        this.curRowDatas[icol] = J2DB.fromDmdbTimestamp(x2, this.bindParameters[icol], this.connection);
    }

    public void do_setINTERVALDT(String parameterName, DmdbIntervalDT x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterName, 21);
            return;
        }
        int icol = this.bindInParam(parameterName, 21, false);
        if (this.bindParameters[icol].typeFlag != 1) {
            this.bindParameters[icol].scale = x2.getScaleForSvr();
        }
        this.curRowDatas[icol] = J2DB.fromDmdbIntervalDT(x2, this.bindParameters[icol], this.connection);
    }

    public void do_setINTERVALYM(String parameterName, DmdbIntervalYM x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterName, 20);
            return;
        }
        int icol = this.bindInParam(parameterName, 20, false);
        if (this.bindParameters[icol].typeFlag != 1) {
            this.bindParameters[icol].scale = x2.getScaleForSvr();
        }
        this.curRowDatas[icol] = J2DB.fromDmdbIntervalYM(x2, this.bindParameters[icol], this.connection);
    }

    public void do_setAsciiStream(String parameterName, InputStream x2) throws SQLException {
        this.do_setAsciiStream(parameterName, x2, -1);
    }

    public void do_setAsciiStream(String parameterName, InputStream x2, int length) throws SQLException {
        this.do_setAsciiStream(parameterName, x2, (long)length);
    }

    public void do_setAsciiStream(String parameterName, InputStream x2, long length) throws SQLException {
        this.do_setInputStream(parameterName, x2, length, 2, 2);
    }

    public void do_setBinaryStream(String parameterName, InputStream x2) throws SQLException {
        this.do_setBinaryStream(parameterName, x2, -1);
    }

    public void do_setBinaryStream(String parameterName, InputStream x2, int length) throws SQLException {
        this.do_setBinaryStream(parameterName, x2, (long)length);
    }

    public void do_setBinaryStream(String parameterName, InputStream x2, long length) throws SQLException {
        this.do_setInputStream(parameterName, x2, length, 18, 1);
    }

    public void do_setInputStream(String parameterName, InputStream x2, long length, int dtype, int streamType) throws SQLException {
        if (x2 instanceof DmdbInputStream) {
            DmdbInputStream dmStream = (DmdbInputStream)x2;
            Object obj = dmStream.useRealObject(length);
            if (obj instanceof DmdbBlob) {
                this.do_setBlob(parameterName, (Blob)obj);
                return;
            }
            if (obj instanceof DmdbClob) {
                this.do_setClob(parameterName, (Clob)obj);
                return;
            }
            if (obj instanceof byte[]) {
                this.do_setBytes(parameterName, (byte[])obj);
                return;
            }
        }
        if (x2 == null) {
            this.do_setNull(parameterName, dtype);
            return;
        }
        long avilable = length != -1L ? length : MiscUtil.available(x2);
        int recDtype = dtype;
        recDtype = dtype == 2 ? (avilable > 0L && avilable < 32767L ? 2 : 19) : (avilable > 0L && avilable < 32767L ? 18 : 12);
        int icol = this.bindInParam(parameterName, recDtype, false);
        switch (streamType) {
            case 2: {
                this.curRowDatas[icol] = J2DB.fromAsciiStream(x2, this.bindParameters[icol], this.connection, length);
                break;
            }
            case 3: {
                this.curRowDatas[icol] = J2DB.fromUnicodeStream(x2, this.bindParameters[icol], this.connection, length);
                break;
            }
            case 1: {
                this.curRowDatas[icol] = J2DB.fromBinaryStream(x2, this.bindParameters[icol], this.connection, length);
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
        }
        if (!(this.curRowDatas[icol] instanceof OffRowData) && this.bindParameters[icol].typeFlag != 1) {
            this.bindParameters[icol].recommendType(this.connection, this.serverParameters[icol], dtype, false);
        }
    }

    public void do_setCharacterStream(String parameterName, Reader x2) throws SQLException {
        this.do_setCharacterStream(parameterName, x2, -1);
    }

    public void do_setCharacterStream(String parameterName, Reader x2, int length) throws SQLException {
        this.do_setCharacterStream(parameterName, x2, (long)length);
    }

    public void do_setCharacterStream(String parameterName, Reader x2, long length) throws SQLException {
        int dtype;
        int n2 = dtype = length != -1L && length < 32767L ? 2 : 19;
        if (x2 == null) {
            this.do_setNull(parameterName, dtype);
            return;
        }
        int icol = this.bindInParam(parameterName, dtype, false);
        this.curRowDatas[icol] = J2DB.fromReader(x2, this.bindParameters[icol], this.connection, length);
        if (!(this.curRowDatas[icol] instanceof OffRowData) && this.bindParameters[icol].typeFlag != 1) {
            this.bindParameters[icol].recommendType(this.connection, this.serverParameters[icol], 2, false);
        }
    }

    public void do_setBlob(String parameterName, Blob x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterName, 12);
            return;
        }
        int icol = this.bindInParam(parameterName, 12, false);
        this.curRowDatas[icol] = x2 instanceof DmdbBlob ? J2DB.fromBlob((DmdbBlob)x2, this.bindParameters[icol], this.connection) : J2DB.fromBinaryStream(x2.getBinaryStream(), this.bindParameters[icol], this.connection, -1L);
    }

    public void do_setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.do_setBlob(parameterName, inputStream, -1L);
    }

    public void do_setBlob(String parameterName, InputStream x2, long length) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterName, 12);
            return;
        }
        int icol = this.bindInParam(parameterName, 12, false);
        this.curRowDatas[icol] = J2DB.fromBinaryStream(x2, this.bindParameters[icol], this.connection, length);
    }

    public void do_setClob(String parameterName, Clob x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterName, 19);
            return;
        }
        int icol = this.bindInParam(parameterName, 19, false);
        this.curRowDatas[icol] = x2 instanceof DmdbClob ? J2DB.fromClob((DmdbClob)x2, this.bindParameters[icol], this.connection) : J2DB.fromReader(x2.getCharacterStream(), this.bindParameters[icol], this.connection, -1L);
    }

    public void do_setClob(String parameterName, Reader reader) throws SQLException {
        this.do_setClob(parameterName, reader, -1L);
    }

    public void do_setClob(String parameterName, Reader x2, long length) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterName, 19);
            return;
        }
        int icol = this.bindInParam(parameterName, 19, false);
        this.curRowDatas[icol] = J2DB.fromReader(x2, this.bindParameters[icol], this.connection, length);
    }

    public void do_setObject(String parameterName, Object x2) throws SQLException {
        this.do_setObject(parameterName, x2, 0, -1);
    }

    public void do_setObject(String parameterName, Object x2, int targetSqlType) throws SQLException {
        this.do_setObject(parameterName, x2, targetSqlType, -1);
    }

    public void do_setObject(String parameterName, Object x2, int targetSqlType, int scaleOrLength) throws SQLException {
        if (scaleOrLength != -1 && (targetSqlType == 3 || targetSqlType == 2) && DmdbType.canCastToDecimal(x2)) {
            String strValue = "";
            strValue = x2 instanceof Boolean ? ((Boolean)x2 != false ? "1" : "0") : String.valueOf(x2);
            BigDecimal bgd = new BigDecimal(strValue);
            x2 = bgd.setScale(scaleOrLength, 4);
        }
        if (x2 == null) {
            this.do_setNull(parameterName, targetSqlType);
        } else if (x2 instanceof Boolean) {
            this.do_setBoolean(parameterName, (boolean)((Boolean)x2));
        } else if (x2 instanceof Byte) {
            this.do_setByte(parameterName, (byte)((Byte)x2));
        } else if (x2 instanceof Short) {
            this.do_setShort(parameterName, (short)((Short)x2));
        } else if (x2 instanceof Integer) {
            this.do_setInt(parameterName, (int)((Integer)x2));
        } else if (x2 instanceof Long) {
            this.do_setLong(parameterName, (long)((Long)x2));
        } else if (x2 instanceof Float) {
            this.do_setFloat(parameterName, ((Float)x2).floatValue());
        } else if (x2 instanceof Double) {
            this.do_setDouble(parameterName, (double)((Double)x2));
        } else if (x2 instanceof BigDecimal) {
            this.do_setBigDecimal(parameterName, (BigDecimal)x2);
        } else if (x2 instanceof byte[]) {
            this.do_setBytes(parameterName, (byte[])x2);
        } else if (x2 instanceof String) {
            this.do_setString(parameterName, (String)x2);
        } else if (x2 instanceof Clob) {
            this.do_setClob(parameterName, (Clob)x2);
        } else if (x2 instanceof Blob) {
            this.do_setBlob(parameterName, (Blob)x2);
        } else if (x2 instanceof InputStream) {
            this.do_setBinaryStream(parameterName, (InputStream)x2, scaleOrLength);
        } else if (x2 instanceof Reader) {
            this.do_setCharacterStream(parameterName, (Reader)x2, scaleOrLength);
        } else if (x2 instanceof Array) {
            this.do_setArray(parameterName, (Array)x2);
        } else if (x2 instanceof BigInteger) {
            this.do_setBigDecimal(parameterName, new BigDecimal((BigInteger)x2));
        } else if (x2 instanceof Character) {
            this.do_setString(parameterName, x2.toString());
        } else if (x2 instanceof DmdbBFile) {
            this.do_setString(parameterName, ((DmdbBFile)x2).getFileName());
        } else if (x2 instanceof Struct) {
            this.do_setStruct(parameterName, (Struct)x2);
        } else if (x2 instanceof SQLData) {
            this.do_setSQLData(parameterName, (SQLData)x2);
        } else if (x2 instanceof RowId) {
            this.do_setRowId(parameterName, (RowId)x2);
        } else if (x2 instanceof DmdbTimestamp) {
            this.do_setTIMESTAMP(parameterName, (DmdbTimestamp)x2);
        } else if (x2 instanceof DmdbIntervalDT) {
            this.do_setINTERVALDT(parameterName, (DmdbIntervalDT)x2);
        } else if (x2 instanceof DmdbIntervalYM) {
            this.do_setINTERVALYM(parameterName, (DmdbIntervalYM)x2);
        } else if (x2 instanceof Date) {
            this.do_setDate(parameterName, (Date)x2);
        } else if (x2 instanceof Time) {
            this.do_setTime(parameterName, (Time)x2);
        } else if (x2 instanceof Timestamp) {
            this.do_setTimestamp(parameterName, (Timestamp)x2);
        } else if (x2 instanceof java.util.Date) {
            this.do_setTIMESTAMP(parameterName, DmdbTimestamp.valueOf((java.util.Date)x2));
        } else if (x2 instanceof LocalDate) {
            this.do_setTIMESTAMP(parameterName, DmdbTimestamp.valueOf((LocalDate)x2));
        } else if (x2 instanceof LocalTime) {
            this.do_setTIMESTAMP(parameterName, DmdbTimestamp.valueOf((LocalTime)x2));
        } else if (x2 instanceof LocalDateTime) {
            this.do_setTIMESTAMP(parameterName, DmdbTimestamp.valueOf((LocalDateTime)x2));
        } else if (x2 instanceof ZonedDateTime) {
            this.do_setTIMESTAMP(parameterName, DmdbTimestamp.valueOf((ZonedDateTime)x2));
        } else if (x2 instanceof OffsetDateTime) {
            this.do_setTIMESTAMP(parameterName, DmdbTimestamp.valueOf((OffsetDateTime)x2));
        } else if (x2 instanceof OffsetTime) {
            this.do_setTIMESTAMP(parameterName, DmdbTimestamp.valueOf((OffsetTime)x2));
        } else if (x2 instanceof SQLXML) {
            this.do_setSQLXML(parameterName, (SQLXML)x2);
        } else if (x2 instanceof Ref) {
            this.do_setRef(parameterName, (Ref)x2);
        } else if (x2 instanceof URL) {
            this.do_setURL(parameterName, (URL)x2);
        } else {
            DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
        }
    }

    private void do_setSQLData(String parameterName, SQLData x2) throws SQLException {
        String typeName = x2.getSQLTypeName();
        if (this.connection.do_getTypeMap().containsKey(typeName) && x2.getClass() == this.connection.do_getTypeMap().get(typeName)) {
            ComplexTypeDesc desc = new ComplexTypeDesc(typeName, this.connection);
            DmdbSQLOutput stream = new DmdbSQLOutput();
            x2.writeSQL(stream);
            DmdbStruct struct = new DmdbStruct(desc, this.connection, stream.getAttribs());
            this.do_setStruct(parameterName, (Struct)struct);
        } else {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        }
    }

    private void do_setStruct(String parameterName, Struct x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterName, 119);
            return;
        }
        int icol = this.bindInParam(parameterName, ((DmdbStruct)x2).getDType(), false);
        this.curRowDatas[icol] = J2DB.fromStruct((DmdbStruct)x2, this.bindParameters[icol], this.connection);
    }

    private void do_setArray(String parameterName, Array x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterName, 117);
            return;
        }
        int icol = this.bindInParam(parameterName, ((DmdbArray)x2).getDType(), false);
        this.curRowDatas[icol] = J2DB.fromArray((DmdbArray)x2, this.bindParameters[icol], this.connection);
    }

    public void do_setURL(String parameterName, URL val) throws SQLException {
        if (val == null) {
            this.do_setNull(parameterName, 70);
            return;
        }
        this.do_setString(parameterName, val.toString());
    }

    public void do_setNString(String parameterName, String value) throws SQLException {
        this.do_setString(parameterName, value);
    }

    public void do_setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.do_setCharacterStream(parameterName, value, length);
    }

    public void do_setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.do_setClob(parameterName, reader, length);
    }

    public void do_setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.do_setCharacterStream(parameterName, value);
    }

    public void do_setNClob(String parameterName, Reader reader) throws SQLException {
        this.do_setClob(parameterName, reader);
    }

    public void do_setRowId(String parameterName, RowId x2) throws SQLException {
        int dtype;
        int n2 = dtype = this.connection.msgVersion >= 9 ? 28 : 8;
        if (x2 == null) {
            this.do_setNull(parameterName, dtype);
        } else {
            int icol = this.bindInParam(parameterName, dtype, false);
            this.curRowDatas[icol] = J2DB.fromRowId(x2, this.bindParameters[icol], this.connection);
        }
    }

    public void do_setNClob(String parameterName, NClob value) throws SQLException {
        this.do_setClob(parameterName, (Clob)value);
    }

    public void do_setSQLXML(String parameterName, SQLXML x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterName, 2);
            return;
        }
        int icol = this.bindInParam(parameterName, 2, false);
        this.curRowDatas[icol] = J2DB.fromReader(((DmdbSQLXML)x2).serializeAsCharacterStream(), this.bindParameters[icol], this.connection, -1L);
    }

    public void do_setRef(String parameterName, Ref x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterName, 2);
            return;
        }
        int icol = this.bindInParam(parameterName, 2, false);
        this.curRowDatas[icol] = J2DB.fromObject(((DmdbRef)x2).getObject(), this.bindParameters[icol], this.connection);
    }

    public void do_setObject(String parameterName, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public void do_setObject(String parameterName, Object x2, SQLType targetSqlType) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    protected void checkOutParameter(int paramIndex) throws SQLException {
        if (paramIndex < 1 || paramIndex > this.paramCount) {
            DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
        }
        if (this.bindParameters[paramIndex - 1].ioType == 0 || this.bindParameters[paramIndex - 1].ioType == -1) {
            DBError.ECJDBC_NOT_OUT_PARAM.throwz(new Object[0]);
        }
    }

    protected byte[] getOutData(int parameterIndex) throws SQLException {
        this.checkOutParameter(parameterIndex);
        if (this.execInfo.outParamDatas == null || this.execInfo.outParamDatas.size() == 0 || this.execInfo.outParamDatas.get(0).length < parameterIndex) {
            this.wasNull = true;
            return null;
        }
        byte[] bytes = this.execInfo.outParamDatas.get(0)[parameterIndex - 1];
        this.wasNull = bytes == null;
        return bytes;
    }

    public boolean do_getBoolean(int parameterIndex) throws SQLException {
        byte[] bytes = this.getOutData(parameterIndex);
        return bytes != null && DB2J.toBoolean(bytes, this.bindParameters[parameterIndex - 1], this.connection);
    }

    public byte do_getByte(int parameterIndex) throws SQLException {
        byte[] bytes = this.getOutData(parameterIndex);
        return bytes != null ? DB2J.toByte(bytes, this.bindParameters[parameterIndex - 1], this.connection) : (byte)0;
    }

    public short do_getShort(int parameterIndex) throws SQLException {
        byte[] bytes = this.getOutData(parameterIndex);
        return bytes != null ? DB2J.toShort(bytes, this.bindParameters[parameterIndex - 1], this.connection) : (short)0;
    }

    public int do_getInt(int parameterIndex) throws SQLException {
        byte[] bytes = this.getOutData(parameterIndex);
        return bytes != null ? DB2J.toInt(bytes, this.bindParameters[parameterIndex - 1], this.connection) : 0;
    }

    public long do_getLong(int parameterIndex) throws SQLException {
        byte[] bytes = this.getOutData(parameterIndex);
        return bytes != null ? DB2J.toLong(bytes, this.bindParameters[parameterIndex - 1], this.connection) : 0L;
    }

    public float do_getFloat(int parameterIndex) throws SQLException {
        byte[] bytes = this.getOutData(parameterIndex);
        return bytes != null ? DB2J.toFloat(bytes, this.bindParameters[parameterIndex - 1], this.connection) : 0.0f;
    }

    public double do_getDouble(int parameterIndex) throws SQLException {
        byte[] bytes = this.getOutData(parameterIndex);
        return bytes != null ? DB2J.toDouble(bytes, this.bindParameters[parameterIndex - 1], this.connection) : 0.0;
    }

    public BigDecimal do_getBigDecimal(int parameterIndex) throws SQLException {
        return this.do_getBigDecimal(parameterIndex, this.bindParameters[parameterIndex - 1].outScale);
    }

    public BigDecimal do_getBigDecimal(int parameterIndex, int scale) throws SQLException {
        byte[] bytes = this.getOutData(parameterIndex);
        return bytes != null ? DB2J.toBigDecimal(bytes, this.bindParameters[parameterIndex - 1], this.connection, scale) : null;
    }

    public byte[] do_getBytes(int parameterIndex) throws SQLException {
        byte[] bytes = this.getOutData(parameterIndex);
        return bytes != null ? DB2J.toBytes(bytes, this.bindParameters[parameterIndex - 1], this.connection) : null;
    }

    public String do_getString(int parameterIndex) throws SQLException {
        byte[] bytes = this.getOutData(parameterIndex);
        return bytes != null ? DB2J.toString(bytes, this.bindParameters[parameterIndex - 1], this.connection) : null;
    }

    public Date do_getDate(int parameterIndex) throws SQLException {
        return this.do_getDate(parameterIndex, null);
    }

    public Date do_getDate(int parameterIndex, Calendar cal) throws SQLException {
        byte[] bytes = this.getOutData(parameterIndex);
        return bytes != null ? DB2J.toDate(bytes, this.bindParameters[parameterIndex - 1], this.connection, cal) : null;
    }

    public Time do_getTime(int parameterIndex) throws SQLException {
        return this.do_getTime(parameterIndex, null);
    }

    public Time do_getTime(int parameterIndex, Calendar cal) throws SQLException {
        byte[] bytes = this.getOutData(parameterIndex);
        return bytes != null ? DB2J.toTime(bytes, this.bindParameters[parameterIndex - 1], this.connection, cal) : null;
    }

    public Timestamp do_getTimestamp(int parameterIndex) throws SQLException {
        return this.do_getTimestamp(parameterIndex, null);
    }

    public Timestamp do_getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        byte[] bytes = this.getOutData(parameterIndex);
        return bytes != null ? DB2J.toTimestamp(bytes, this.bindParameters[parameterIndex - 1], this.connection, cal) : null;
    }

    public DmdbBlob do_getBlob(int parameterIndex) throws SQLException {
        byte[] bytes = this.getOutData(parameterIndex);
        return bytes != null ? DB2J.toBlob(bytes, this.bindParameters[parameterIndex - 1], this.connection) : null;
    }

    public DmdbClob do_getClob(int parameterIndex) throws SQLException {
        byte[] bytes = this.getOutData(parameterIndex);
        return bytes != null ? DB2J.toClob(bytes, this.bindParameters[parameterIndex - 1], this.connection) : null;
    }

    public DmdbArray do_getArray(int parameterIndex) throws SQLException {
        byte[] bytes = this.getOutData(parameterIndex);
        return bytes != null ? DB2J.toArray(bytes, this.bindParameters[parameterIndex - 1], this.connection) : null;
    }

    public DmdbStruct do_getStruct(int parameterIndex) throws SQLException {
        byte[] bytes = this.getOutData(parameterIndex);
        return bytes != null ? DB2J.toStruct(bytes, this.bindParameters[parameterIndex - 1], this.connection) : null;
    }

    public DmdbReader do_getCharacterStream(int parameterIndex) throws SQLException {
        byte[] bytes = this.getOutData(parameterIndex);
        return bytes != null ? DB2J.toCharacterStream(bytes, this.bindParameters[parameterIndex - 1], this.connection) : null;
    }

    public Object do_getObject(int parameterIndex) throws SQLException {
        return this.do_getObject(parameterIndex, this.connection.do_getTypeMap());
    }

    public Object do_getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        byte[] bytes;
        this.checkOutParameter(parameterIndex);
        Parameter param = this.bindParameters[parameterIndex - 1];
        Object val = null;
        boolean unknownTargetType = true;
        if (param.outJType != Integer.MIN_VALUE) {
            unknownTargetType = false;
            switch (param.outJType) {
                case 120: {
                    val = this.do_getCursor(parameterIndex);
                    break;
                }
                case -7: 
                case 16: {
                    val = this.do_getBoolean(parameterIndex);
                    break;
                }
                case -6: {
                    val = this.do_getByte(parameterIndex);
                    break;
                }
                case 5: {
                    val = this.do_getShort(parameterIndex);
                    break;
                }
                case 4: {
                    val = this.do_getInt(parameterIndex);
                    break;
                }
                case -5: {
                    val = this.do_getLong(parameterIndex);
                    break;
                }
                case 2: 
                case 3: {
                    val = this.do_getBigDecimal(parameterIndex);
                    break;
                }
                case 6: 
                case 7: {
                    val = Float.valueOf(this.do_getFloat(parameterIndex));
                    break;
                }
                case 8: {
                    val = this.do_getDouble(parameterIndex);
                    break;
                }
                case 91: {
                    val = this.do_getDate(parameterIndex);
                    break;
                }
                case 92: {
                    val = this.do_getTime(parameterIndex);
                    break;
                }
                case 93: {
                    val = this.do_getTimestamp(parameterIndex);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    val = this.do_getBytes(parameterIndex);
                    break;
                }
                case 2004: {
                    if (DmdbType.isComplexType(param.type, param.scale)) {
                        bytes = this.getOutData(parameterIndex);
                        val = bytes != null ? DB2J.toComplexType(bytes, param, this.connection, map) : null;
                        break;
                    }
                    if (StringUtil.equalsIgnoreCase(param.typeName, "LONGVARBINARY")) {
                        val = this.do_getBytes(parameterIndex);
                        break;
                    }
                    val = this.do_getBlob(parameterIndex);
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    val = this.do_getString(parameterIndex);
                    if (val == null || param.mask != 3) break;
                    val = new DmdbBFile((String)val);
                    break;
                }
                case 2005: {
                    val = StringUtil.equalsIgnoreCase(param.typeName, "LONGVARCHAR") ? this.do_getString(parameterIndex) : this.do_getClob(parameterIndex);
                    break;
                }
                case 2002: 
                case 2003: {
                    bytes = this.getOutData(parameterIndex);
                    val = bytes != null ? DB2J.toComplexType(bytes, param, this.connection, map) : null;
                    break;
                }
                case -8: {
                    val = this.do_getRowId(parameterIndex);
                    break;
                }
                default: {
                    unknownTargetType = true;
                }
            }
        }
        if (!unknownTargetType) {
            return this.wasNull ? null : val;
        }
        if (this.connection.compatibleOracle() && DmdbType.isNumber(param.type)) {
            return this.do_getBigDecimal(parameterIndex);
        }
        switch (param.type) {
            case 3: 
            case 13: {
                val = this.do_getBoolean(parameterIndex);
                break;
            }
            case 5: {
                val = this.do_getByte(parameterIndex);
                break;
            }
            case 6: {
                val = this.do_getShort(parameterIndex);
                break;
            }
            case 7: {
                val = this.do_getInt(parameterIndex);
                break;
            }
            case 8: {
                val = this.do_getLong(parameterIndex);
                break;
            }
            case 9: {
                val = this.do_getBigDecimal(parameterIndex);
                break;
            }
            case 10: {
                val = Float.valueOf(this.do_getFloat(parameterIndex));
                break;
            }
            case 11: {
                val = this.do_getDouble(parameterIndex);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                val = this.do_getTIMESTAMP(parameterIndex);
                break;
            }
            case 17: 
            case 18: {
                val = this.do_getBytes(parameterIndex);
                break;
            }
            case 12: {
                if (DmdbType.isComplexType(param.type, param.scale)) {
                    bytes = this.getOutData(parameterIndex);
                    val = bytes != null ? DB2J.toComplexType(bytes, param, this.connection, map) : null;
                    break;
                }
                if (StringUtil.equalsIgnoreCase(param.typeName, "LONGVARBINARY")) {
                    val = this.do_getBytes(parameterIndex);
                    break;
                }
                val = this.do_getBlob(parameterIndex);
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                val = this.do_getString(parameterIndex);
                if (val == null || param.mask != 3) break;
                val = new DmdbBFile((String)val);
                break;
            }
            case 19: {
                val = StringUtil.equalsIgnoreCase(param.typeName, "LONGVARCHAR") ? this.do_getString(parameterIndex) : this.do_getClob(parameterIndex);
                break;
            }
            case 20: {
                val = this.do_getINTERVALYM(parameterIndex);
                break;
            }
            case 21: {
                val = this.do_getINTERVALDT(parameterIndex);
                break;
            }
            case 117: 
            case 119: 
            case 121: 
            case 122: {
                bytes = this.getOutData(parameterIndex);
                val = bytes != null ? DB2J.toComplexType(bytes, param, this.connection, map) : null;
                break;
            }
            case 120: {
                val = this.do_getCursor(parameterIndex);
                break;
            }
            case 28: {
                val = this.do_getRowId(parameterIndex);
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
        }
        return this.wasNull ? null : val;
    }

    public URL do_getURL(int parameterIndex) throws SQLException {
        String str = this.do_getString(parameterIndex);
        if (str == null) {
            return null;
        }
        try {
            return new URL(str);
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public Ref do_getRef(int parameterIndex) throws SQLException {
        Object obj = this.do_getObject(parameterIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Struct || obj instanceof SQLData) {
            return new DmdbRef(obj);
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return null;
    }

    public ResultSet do_getCursor(int parameterIndex) throws SQLException {
        this.checkOutParameter(parameterIndex);
        if (this.bindParameters[parameterIndex - 1].type != 120) {
            DBError.ECJDBC_PTYPE_NOT_CURSOR.throwz(new Object[0]);
        }
        DmdbStatement destStmt = this.bindParameters[parameterIndex - 1].cursorStmt;
        destStmt.clearResultSets();
        ExecuteRetInfo execInfo = this.connection.dbAccess.a(destStmt, (short)1);
        if (execInfo.hasResultSet) {
            this.wasNull = false;
            destStmt.curResultSet = new DmdbResultSet(1, destStmt, execInfo);
            return destStmt.curResultSet;
        }
        this.wasNull = true;
        return null;
    }

    public DmdbIntervalYM do_getINTERVALYM(int parameterIndex) throws SQLException {
        byte[] bytes = this.getOutData(parameterIndex);
        return bytes != null ? new DmdbIntervalYM(bytes) : null;
    }

    public DmdbIntervalDT do_getINTERVALDT(int parameterIndex) throws SQLException {
        byte[] bytes = this.getOutData(parameterIndex);
        return bytes != null ? new DmdbIntervalDT(bytes) : null;
    }

    public DmdbTimestamp do_getTIMESTAMP(int parameterIndex) throws SQLException {
        byte[] bytes = this.getOutData(parameterIndex);
        return bytes != null ? DB2J.toDmdbTimestamp(bytes, this.bindParameters[parameterIndex - 1], this.connection) : null;
    }

    public String do_getNString(int parameterIndex) throws SQLException {
        return this.do_getString(parameterIndex);
    }

    public DmdbReader do_getNCharacterStream(int parameterIndex) throws SQLException {
        return this.do_getCharacterStream(parameterIndex);
    }

    public RowId do_getRowId(int parameterIndex) throws SQLException {
        byte[] bytes = this.getOutData(parameterIndex);
        return bytes == null ? null : DB2J.toRowId(bytes, this.bindParameters[parameterIndex - 1], this.connection);
    }

    public NClob do_getNClob(int parameterIndex) throws SQLException {
        return (NClob)((Object)this.do_getClob(parameterIndex));
    }

    public SQLXML do_getSQLXML(int parameterIndex) throws SQLException {
        byte[] bytes = this.getOutData(parameterIndex);
        return bytes == null ? null : new DmdbSQLXML(bytes, this.bindParameters[parameterIndex - 1], this.connection);
    }

    public <T> T do_getObject(int parameterIndex, Class<T> type) throws SQLException {
        if (type == String.class) {
            return (T)this.do_getString(parameterIndex);
        }
        if (type == Clob.class) {
            return (T)this.do_getClob(parameterIndex);
        }
        if (type == NClob.class) {
            return (T)this.do_getNClob(parameterIndex);
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(this.do_getBoolean(parameterIndex));
        }
        if (type == Long.class) {
            return (T)Long.valueOf(this.do_getLong(parameterIndex));
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(this.do_getInt(parameterIndex));
        }
        if (type == Short.class) {
            return (T)Short.valueOf(this.do_getShort(parameterIndex));
        }
        if (type == BigDecimal.class) {
            return (T)this.do_getBigDecimal(parameterIndex);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(this.do_getFloat(parameterIndex));
        }
        if (type == Double.class) {
            return (T)Double.valueOf(this.do_getDouble(parameterIndex));
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(this.do_getByte(parameterIndex));
        }
        if (type == byte[].class) {
            return (T)this.do_getBytes(parameterIndex);
        }
        if (type == Blob.class) {
            return (T)this.do_getBlob(parameterIndex);
        }
        if (type == Date.class) {
            return (T)this.do_getDate(parameterIndex);
        }
        if (type == Time.class) {
            return (T)this.do_getTime(parameterIndex);
        }
        if (type == Timestamp.class) {
            return (T)this.do_getTimestamp(parameterIndex);
        }
        if (type == java.util.Date.class) {
            Timestamp t2 = this.do_getTimestamp(parameterIndex);
            return (T)(t2 == null ? null : new java.util.Date(t2.getTime()));
        }
        if (type == LocalDateTime.class) {
            DmdbTimestamp t3 = this.do_getTIMESTAMP(parameterIndex);
            return (T)(t3 == null ? null : LocalDateTime.of(t3.dt[0], t3.dt[1], t3.dt[2], t3.dt[3], t3.dt[4], t3.dt[5], t3.dt[6]));
        }
        if (type == LocalDate.class) {
            DmdbTimestamp t4 = this.do_getTIMESTAMP(parameterIndex);
            return (T)(t4 == null ? null : LocalDate.of(t4.dt[0], t4.dt[1], t4.dt[2]));
        }
        if (type == LocalTime.class) {
            DmdbTimestamp t5 = this.do_getTIMESTAMP(parameterIndex);
            return (T)(t5 == null ? null : LocalTime.of(t5.dt[3], t5.dt[4], t5.dt[5], t5.dt[6]));
        }
        if (type == ZonedDateTime.class) {
            DmdbTimestamp t6 = this.do_getTIMESTAMP(parameterIndex);
            return (T)(t6 == null ? null : ZonedDateTime.of(t6.dt[0], t6.dt[1], t6.dt[2], t6.dt[3], t6.dt[4], t6.dt[5], t6.dt[6], ZoneOffset.ofTotalSeconds(t6.dt[7] != Integer.MIN_VALUE ? t6.dt[7] * 60 : this.connection.localTimezone * 60)));
        }
        if (type == OffsetDateTime.class) {
            DmdbTimestamp t7 = this.do_getTIMESTAMP(parameterIndex);
            return (T)(t7 == null ? null : OffsetDateTime.of(t7.dt[0], t7.dt[1], t7.dt[2], t7.dt[3], t7.dt[4], t7.dt[5], t7.dt[6], ZoneOffset.ofTotalSeconds(t7.dt[7] != Integer.MIN_VALUE ? t7.dt[7] * 60 : this.connection.localTimezone * 60)));
        }
        if (type == OffsetTime.class) {
            DmdbTimestamp t8 = this.do_getTIMESTAMP(parameterIndex);
            return (T)(t8 == null ? null : OffsetTime.of(t8.dt[3], t8.dt[4], t8.dt[5], t8.dt[6], ZoneOffset.ofTotalSeconds(t8.dt[7] != Integer.MIN_VALUE ? t8.dt[7] * 60 : this.connection.localTimezone * 60)));
        }
        if (type == Array.class) {
            return (T)this.do_getArray(parameterIndex);
        }
        if (type == Struct.class) {
            return (T)this.do_getObject(parameterIndex);
        }
        if (type == Ref.class) {
            return (T)this.do_getRef(parameterIndex);
        }
        if (type == SQLXML.class) {
            return (T)this.do_getSQLXML(parameterIndex);
        }
        if (type == URL.class) {
            return (T)this.do_getURL(parameterIndex);
        }
        if (type == RowId.class) {
            return (T)this.do_getRowId(parameterIndex);
        }
        DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
        return null;
    }

    @Override
    @Deprecated
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        if (this.filterChain == null) {
            this.do_registerOutParameter(parameterIndex, sqlType);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, parameterIndex, sqlType);
        }
    }

    @Override
    @Deprecated
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        if (this.filterChain == null) {
            this.do_registerOutParameter(parameterIndex, sqlType, scale);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, parameterIndex, sqlType, scale);
        }
    }

    @Override
    @Deprecated
    public boolean wasNull() throws SQLException {
        if (this.filterChain == null) {
            return this.do_wasNull();
        }
        return this.filterChain.reset().CallableStatement_wasNull(this);
    }

    @Override
    @Deprecated
    public String getString(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getString(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getString(this, parameterIndex);
    }

    @Override
    @Deprecated
    public boolean getBoolean(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getBoolean(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getBoolean(this, parameterIndex);
    }

    @Override
    @Deprecated
    public byte getByte(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getByte(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getByte(this, parameterIndex);
    }

    @Override
    @Deprecated
    public short getShort(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getShort(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getShort(this, parameterIndex);
    }

    @Override
    @Deprecated
    public int getInt(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getInt(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getInt(this, parameterIndex);
    }

    @Override
    @Deprecated
    public long getLong(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getLong(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getLong(this, parameterIndex);
    }

    @Override
    @Deprecated
    public float getFloat(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getFloat(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getFloat(this, parameterIndex);
    }

    @Override
    @Deprecated
    public double getDouble(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getDouble(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getDouble(this, parameterIndex);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getBigDecimal(parameterIndex, scale);
        }
        return this.filterChain.reset().CallableStatement_getBigDecimal(this, parameterIndex, scale);
    }

    @Override
    @Deprecated
    public byte[] getBytes(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getBytes(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getBytes(this, parameterIndex);
    }

    @Override
    @Deprecated
    public Date getDate(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getDate(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getDate(this, parameterIndex);
    }

    @Override
    @Deprecated
    public Time getTime(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getTime(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getTime(this, parameterIndex);
    }

    @Override
    @Deprecated
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getTimestamp(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getTimestamp(this, parameterIndex);
    }

    @Override
    @Deprecated
    public Object getObject(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getObject(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getObject(this, parameterIndex);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getBigDecimal(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getBigDecimal(this, parameterIndex);
    }

    @Override
    @Deprecated
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getObject(parameterIndex, map);
        }
        return this.filterChain.reset().CallableStatement_getObject(this, parameterIndex, map);
    }

    @Override
    @Deprecated
    public Ref getRef(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getRef(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getRef(this, parameterIndex);
    }

    @Override
    @Deprecated
    public Blob getBlob(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getBlob(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getBlob(this, parameterIndex);
    }

    @Override
    @Deprecated
    public Clob getClob(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getClob(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getClob(this, parameterIndex);
    }

    @Override
    @Deprecated
    public Array getArray(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getArray(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getArray(this, parameterIndex);
    }

    @Override
    @Deprecated
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getDate(parameterIndex, cal);
        }
        return this.filterChain.reset().CallableStatement_getDate(this, parameterIndex, cal);
    }

    @Override
    @Deprecated
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getTime(parameterIndex, cal);
        }
        return this.filterChain.reset().CallableStatement_getTime(this, parameterIndex, cal);
    }

    @Override
    @Deprecated
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getTimestamp(parameterIndex, cal);
        }
        return this.filterChain.reset().CallableStatement_getTimestamp(this, parameterIndex, cal);
    }

    @Override
    @Deprecated
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        if (this.filterChain == null) {
            this.do_registerOutParameter(parameterIndex, sqlType, typeName);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, parameterIndex, sqlType, typeName);
        }
    }

    @Override
    @Deprecated
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        if (this.filterChain == null) {
            this.do_registerOutParameter(parameterName, sqlType);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, parameterName, sqlType);
        }
    }

    @Override
    @Deprecated
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        if (this.filterChain == null) {
            this.do_registerOutParameter(parameterName, sqlType, scale);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, parameterName, sqlType, scale);
        }
    }

    @Override
    @Deprecated
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        if (this.filterChain == null) {
            this.do_registerOutParameter(parameterName, sqlType, typeName);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, parameterName, sqlType, typeName);
        }
    }

    @Override
    @Deprecated
    public URL getURL(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getURL(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getURL(this, parameterIndex);
    }

    @Override
    @Deprecated
    public void setURL(String parameterName, URL val) throws SQLException {
        if (this.filterChain == null) {
            this.do_setURL(parameterName, val);
        } else {
            this.filterChain.reset().CallableStatement_setURL(this, parameterName, val);
        }
    }

    @Override
    @Deprecated
    public void setNull(String parameterName, int sqlType) throws SQLException {
        if (this.filterChain == null) {
            this.do_setNull(parameterName, sqlType);
        } else {
            this.filterChain.reset().CallableStatement_setNull(this, parameterName, sqlType);
        }
    }

    @Override
    @Deprecated
    public void setBoolean(String parameterName, boolean x2) throws SQLException {
        if (this.filterChain == null) {
            this.do_setBoolean(parameterName, x2);
        } else {
            this.filterChain.reset().CallableStatement_setBoolean(this, parameterName, x2);
        }
    }

    @Override
    @Deprecated
    public void setByte(String parameterName, byte x2) throws SQLException {
        if (this.filterChain == null) {
            this.do_setByte(parameterName, x2);
        } else {
            this.filterChain.reset().CallableStatement_setByte(this, parameterName, x2);
        }
    }

    @Override
    @Deprecated
    public void setShort(String parameterName, short x2) throws SQLException {
        if (this.filterChain == null) {
            this.do_setShort(parameterName, x2);
        } else {
            this.filterChain.reset().CallableStatement_setShort(this, parameterName, x2);
        }
    }

    @Override
    @Deprecated
    public void setInt(String parameterName, int x2) throws SQLException {
        if (this.filterChain == null) {
            this.do_setInt(parameterName, x2);
        } else {
            this.filterChain.reset().CallableStatement_setInt(this, parameterName, x2);
        }
    }

    @Override
    @Deprecated
    public void setLong(String parameterName, long x2) throws SQLException {
        if (this.filterChain == null) {
            this.do_setLong(parameterName, x2);
        } else {
            this.filterChain.reset().CallableStatement_setLong(this, parameterName, x2);
        }
    }

    @Override
    @Deprecated
    public void setFloat(String parameterName, float x2) throws SQLException {
        if (this.filterChain == null) {
            this.do_setFloat(parameterName, x2);
        } else {
            this.filterChain.reset().CallableStatement_setFloat(this, parameterName, x2);
        }
    }

    @Override
    @Deprecated
    public void setDouble(String parameterName, double x2) throws SQLException {
        if (this.filterChain == null) {
            this.do_setDouble(parameterName, x2);
        } else {
            this.filterChain.reset().CallableStatement_setDouble(this, parameterName, x2);
        }
    }

    @Override
    @Deprecated
    public void setBigDecimal(String parameterName, BigDecimal x2) throws SQLException {
        if (this.filterChain == null) {
            this.do_setBigDecimal(parameterName, x2);
        } else {
            this.filterChain.reset().CallableStatement_setBigDecimal(this, parameterName, x2);
        }
    }

    @Override
    @Deprecated
    public void setString(String parameterName, String x2) throws SQLException {
        if (this.filterChain == null) {
            this.do_setString(parameterName, x2);
        } else {
            this.filterChain.reset().CallableStatement_setString(this, parameterName, x2);
        }
    }

    @Override
    @Deprecated
    public void setBytes(String parameterName, byte[] x2) throws SQLException {
        if (this.filterChain == null) {
            this.do_setBytes(parameterName, x2);
        } else {
            this.filterChain.reset().CallableStatement_setBytes(this, parameterName, x2);
        }
    }

    @Override
    @Deprecated
    public void setDate(String parameterName, Date x2) throws SQLException {
        if (this.filterChain == null) {
            this.do_setDate(parameterName, x2);
        } else {
            this.filterChain.reset().CallableStatement_setDate(this, parameterName, x2);
        }
    }

    @Override
    @Deprecated
    public void setTime(String parameterName, Time x2) throws SQLException {
        if (this.filterChain == null) {
            this.do_setTime(parameterName, x2);
        } else {
            this.filterChain.reset().CallableStatement_setTime(this, parameterName, x2);
        }
    }

    @Override
    @Deprecated
    public void setTimestamp(String parameterName, Timestamp x2) throws SQLException {
        if (this.filterChain == null) {
            this.do_setTimestamp(parameterName, x2);
        } else {
            this.filterChain.reset().CallableStatement_setTimestamp(this, parameterName, x2);
        }
    }

    @Override
    @Deprecated
    public void setAsciiStream(String parameterName, InputStream x2, int length) throws SQLException {
        if (this.filterChain == null) {
            this.do_setAsciiStream(parameterName, x2, length);
        } else {
            this.filterChain.reset().CallableStatement_setAsciiStream(this, parameterName, x2, length);
        }
    }

    @Override
    @Deprecated
    public void setBinaryStream(String parameterName, InputStream x2, int length) throws SQLException {
        if (this.filterChain == null) {
            this.do_setBinaryStream(parameterName, x2, length);
        } else {
            this.filterChain.reset().CallableStatement_setBinaryStream(this, parameterName, x2, length);
        }
    }

    @Override
    @Deprecated
    public void setObject(String parameterName, Object x2, int targetSqlType, int scale) throws SQLException {
        if (this.filterChain == null) {
            this.do_setObject(parameterName, x2, targetSqlType, scale);
        } else {
            this.filterChain.reset().CallableStatement_setObject(this, parameterName, x2, targetSqlType, scale);
        }
    }

    @Override
    @Deprecated
    public void setObject(String parameterName, Object x2, int targetSqlType) throws SQLException {
        if (this.filterChain == null) {
            this.do_setObject(parameterName, x2, targetSqlType);
        } else {
            this.filterChain.reset().CallableStatement_setObject(this, parameterName, x2, targetSqlType);
        }
    }

    @Override
    @Deprecated
    public void setObject(String parameterName, Object x2) throws SQLException {
        if (this.filterChain == null) {
            this.do_setObject(parameterName, x2);
        } else {
            this.filterChain.reset().CallableStatement_setObject(this, parameterName, x2);
        }
    }

    @Override
    @Deprecated
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        if (this.filterChain == null) {
            this.do_setCharacterStream(parameterName, reader, length);
        } else {
            this.filterChain.reset().CallableStatement_setCharacterStream(this, parameterName, reader, length);
        }
    }

    @Override
    @Deprecated
    public void setDate(String parameterName, Date x2, Calendar cal) throws SQLException {
        if (this.filterChain == null) {
            this.do_setDate(parameterName, x2, cal);
        } else {
            this.filterChain.reset().CallableStatement_setDate(this, parameterName, x2, cal);
        }
    }

    @Override
    @Deprecated
    public void setTime(String parameterName, Time x2, Calendar cal) throws SQLException {
        if (this.filterChain == null) {
            this.do_setTime(parameterName, x2, cal);
        } else {
            this.filterChain.reset().CallableStatement_setTime(this, parameterName, x2, cal);
        }
    }

    @Override
    @Deprecated
    public void setTimestamp(String parameterName, Timestamp x2, Calendar cal) throws SQLException {
        if (this.filterChain == null) {
            this.do_setTimestamp(parameterName, x2, cal);
        } else {
            this.filterChain.reset().CallableStatement_setTimestamp(this, parameterName, x2, cal);
        }
    }

    @Override
    @Deprecated
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        if (this.filterChain == null) {
            this.do_setNull(parameterName, sqlType, typeName);
        } else {
            this.filterChain.reset().CallableStatement_setNull(this, parameterName, sqlType, typeName);
        }
    }

    @Override
    @Deprecated
    public String getString(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getString(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getString(this, parameterName);
    }

    @Override
    @Deprecated
    public boolean getBoolean(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getBoolean(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getBoolean(this, parameterName);
    }

    @Override
    @Deprecated
    public byte getByte(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getByte(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getByte(this, parameterName);
    }

    @Override
    @Deprecated
    public short getShort(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getShort(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getShort(this, parameterName);
    }

    @Override
    @Deprecated
    public int getInt(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getInt(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getInt(this, parameterName);
    }

    @Override
    @Deprecated
    public long getLong(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getLong(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getLong(this, parameterName);
    }

    @Override
    @Deprecated
    public float getFloat(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getFloat(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getFloat(this, parameterName);
    }

    @Override
    @Deprecated
    public double getDouble(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getDouble(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getDouble(this, parameterName);
    }

    @Override
    @Deprecated
    public byte[] getBytes(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getBytes(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getBytes(this, parameterName);
    }

    @Override
    @Deprecated
    public Date getDate(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getDate(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getDate(this, parameterName);
    }

    @Override
    @Deprecated
    public Time getTime(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getTime(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getTime(this, parameterName);
    }

    @Override
    @Deprecated
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getTimestamp(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getTimestamp(this, parameterName);
    }

    @Override
    @Deprecated
    public Object getObject(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getObject(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getObject(this, parameterName);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getBigDecimal(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getBigDecimal(this, parameterName);
    }

    @Override
    @Deprecated
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getObject(parameterName, map);
        }
        return this.filterChain.reset().CallableStatement_getObject(this, parameterName, map);
    }

    @Override
    @Deprecated
    public Ref getRef(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getRef(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getRef(this, parameterName);
    }

    @Override
    @Deprecated
    public Blob getBlob(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getBlob(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getBlob(this, parameterName);
    }

    @Override
    @Deprecated
    public Clob getClob(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getClob(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getClob(this, parameterName);
    }

    @Override
    @Deprecated
    public Array getArray(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getArray(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getArray(this, parameterName);
    }

    @Override
    @Deprecated
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getDate(parameterName, cal);
        }
        return this.filterChain.reset().CallableStatement_getDate(this, parameterName, cal);
    }

    @Override
    @Deprecated
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getTime(parameterName, cal);
        }
        return this.filterChain.reset().CallableStatement_getTime(this, parameterName, cal);
    }

    @Override
    @Deprecated
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getTimestamp(parameterName, cal);
        }
        return this.filterChain.reset().CallableStatement_getTimestamp(this, parameterName, cal);
    }

    @Override
    @Deprecated
    public URL getURL(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getURL(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getURL(this, parameterName);
    }

    @Override
    @Deprecated
    public RowId getRowId(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getRowId(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getRowId(this, parameterIndex);
    }

    @Override
    @Deprecated
    public RowId getRowId(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getRowId(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getRowId(this, parameterName);
    }

    @Override
    @Deprecated
    public void setRowId(String parameterName, RowId x2) throws SQLException {
        if (this.filterChain == null) {
            this.do_setRowId(parameterName, x2);
        } else {
            this.filterChain.reset().CallableStatement_setRowId(this, parameterName, x2);
        }
    }

    @Override
    @Deprecated
    public void setNString(String parameterName, String value) throws SQLException {
        if (this.filterChain == null) {
            this.do_setNString(parameterName, value);
        } else {
            this.filterChain.reset().CallableStatement_setNString(this, parameterName, value);
        }
    }

    @Override
    @Deprecated
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        if (this.filterChain == null) {
            this.do_setNCharacterStream(parameterName, value, length);
        } else {
            this.filterChain.reset().CallableStatement_setNCharacterStream(this, parameterName, value, length);
        }
    }

    @Override
    @Deprecated
    public void setNClob(String parameterName, NClob value) throws SQLException {
        if (this.filterChain == null) {
            this.do_setNClob(parameterName, value);
        } else {
            this.filterChain.reset().CallableStatement_setNClob(this, parameterName, value);
        }
    }

    @Override
    @Deprecated
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        if (this.filterChain == null) {
            this.do_setClob(parameterName, reader, length);
        } else {
            this.filterChain.reset().CallableStatement_setClob(this, parameterName, reader, length);
        }
    }

    @Override
    @Deprecated
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        if (this.filterChain == null) {
            this.do_setBlob(parameterName, inputStream, length);
        } else {
            this.filterChain.reset().CallableStatement_setBlob(this, parameterName, inputStream, length);
        }
    }

    @Override
    @Deprecated
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        if (this.filterChain == null) {
            this.do_setNClob(parameterName, reader, length);
        } else {
            this.filterChain.reset().CallableStatement_setNClob(this, parameterName, reader, length);
        }
    }

    @Override
    @Deprecated
    public NClob getNClob(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getNClob(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getNClob(this, parameterIndex);
    }

    @Override
    @Deprecated
    public NClob getNClob(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getNClob(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getNClob(this, parameterName);
    }

    @Override
    @Deprecated
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        if (this.filterChain == null) {
            this.do_setSQLXML(parameterName, xmlObject);
        } else {
            this.filterChain.reset().CallableStatement_setSQLXML(this, parameterName, xmlObject);
        }
    }

    @Override
    @Deprecated
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getSQLXML(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getSQLXML(this, parameterIndex);
    }

    @Override
    @Deprecated
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getSQLXML(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getSQLXML(this, parameterName);
    }

    @Override
    @Deprecated
    public String getNString(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getNString(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getNString(this, parameterIndex);
    }

    @Override
    @Deprecated
    public String getNString(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getNString(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getNString(this, parameterName);
    }

    @Override
    @Deprecated
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getNCharacterStream(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getNCharacterStream(this, parameterIndex);
    }

    @Override
    @Deprecated
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getNCharacterStream(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getNCharacterStream(this, parameterName);
    }

    @Override
    @Deprecated
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getCharacterStream(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getCharacterStream(this, parameterIndex);
    }

    @Override
    @Deprecated
    public Reader getCharacterStream(String parameterName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getCharacterStream(parameterName);
        }
        return this.filterChain.reset().CallableStatement_getCharacterStream(this, parameterName);
    }

    @Override
    @Deprecated
    public void setBlob(String parameterName, Blob x2) throws SQLException {
        if (this.filterChain == null) {
            this.do_setBlob(parameterName, x2);
        } else {
            this.filterChain.reset().CallableStatement_setBlob(this, parameterName, x2);
        }
    }

    @Override
    @Deprecated
    public void setClob(String parameterName, Clob x2) throws SQLException {
        if (this.filterChain == null) {
            this.do_setClob(parameterName, x2);
        } else {
            this.filterChain.reset().CallableStatement_setClob(this, parameterName, x2);
        }
    }

    @Override
    @Deprecated
    public void setAsciiStream(String parameterName, InputStream x2, long length) throws SQLException {
        if (this.filterChain == null) {
            this.do_setAsciiStream(parameterName, x2, length);
        } else {
            this.filterChain.reset().CallableStatement_setAsciiStream(this, parameterName, x2, length);
        }
    }

    @Override
    @Deprecated
    public void setBinaryStream(String parameterName, InputStream x2, long length) throws SQLException {
        if (this.filterChain == null) {
            this.do_setBinaryStream(parameterName, x2, length);
        } else {
            this.filterChain.reset().CallableStatement_setBinaryStream(this, parameterName, x2, length);
        }
    }

    @Override
    @Deprecated
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        if (this.filterChain == null) {
            this.do_setCharacterStream(parameterName, reader, length);
        } else {
            this.filterChain.reset().CallableStatement_setCharacterStream(this, parameterName, reader, length);
        }
    }

    @Override
    @Deprecated
    public void setAsciiStream(String parameterName, InputStream x2) throws SQLException {
        if (this.filterChain == null) {
            this.do_setAsciiStream(parameterName, x2);
        } else {
            this.filterChain.reset().CallableStatement_setAsciiStream(this, parameterName, x2);
        }
    }

    @Override
    @Deprecated
    public void setBinaryStream(String parameterName, InputStream x2) throws SQLException {
        if (this.filterChain == null) {
            this.do_setBinaryStream(parameterName, x2);
        } else {
            this.filterChain.reset().CallableStatement_setBinaryStream(this, parameterName, x2);
        }
    }

    @Override
    @Deprecated
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        if (this.filterChain == null) {
            this.do_setCharacterStream(parameterName, reader);
        } else {
            this.filterChain.reset().CallableStatement_setCharacterStream(this, parameterName, reader);
        }
    }

    @Override
    @Deprecated
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        if (this.filterChain == null) {
            this.do_setNCharacterStream(parameterName, value);
        } else {
            this.filterChain.reset().CallableStatement_setNCharacterStream(this, parameterName, value);
        }
    }

    @Override
    @Deprecated
    public void setClob(String parameterName, Reader reader) throws SQLException {
        if (this.filterChain == null) {
            this.do_setClob(parameterName, reader);
        } else {
            this.filterChain.reset().CallableStatement_setClob(this, parameterName, reader);
        }
    }

    @Override
    @Deprecated
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        if (this.filterChain == null) {
            this.do_setBlob(parameterName, inputStream);
        } else {
            this.filterChain.reset().CallableStatement_setBlob(this, parameterName, inputStream);
        }
    }

    @Override
    @Deprecated
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        if (this.filterChain == null) {
            this.do_setNClob(parameterName, reader);
        } else {
            this.filterChain.reset().CallableStatement_setNClob(this, parameterName, reader);
        }
    }

    @Override
    @Deprecated
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getObject(parameterIndex, type);
        }
        return this.filterChain.reset().CallableStatement_getObject(this, parameterIndex, type);
    }

    @Override
    @Deprecated
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getObject(parameterName, type);
        }
        return this.filterChain.reset().CallableStatement_getObject(this, parameterName, type);
    }

    @Override
    @Deprecated
    public void setObject(String parameterName, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        if (this.filterChain == null) {
            this.do_setObject(parameterName, x2, targetSqlType, scaleOrLength);
        } else {
            this.filterChain.reset().CallableStatement_setObject(this, parameterName, x2, targetSqlType, scaleOrLength);
        }
    }

    @Override
    @Deprecated
    public void setObject(String parameterName, Object x2, SQLType targetSqlType) throws SQLException {
        if (this.filterChain == null) {
            this.do_setObject(parameterName, x2, targetSqlType);
        } else {
            this.filterChain.reset().CallableStatement_setObject(this, parameterName, x2, targetSqlType);
        }
    }

    @Override
    @Deprecated
    public void registerOutParameter(int parameterIndex, SQLType sqlType) throws SQLException {
        if (this.filterChain == null) {
            this.do_registerOutParameter(parameterIndex, sqlType);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, parameterIndex, sqlType);
        }
    }

    @Override
    @Deprecated
    public void registerOutParameter(int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        if (this.filterChain == null) {
            this.do_registerOutParameter(parameterIndex, sqlType, scale);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, parameterIndex, sqlType, scale);
        }
    }

    @Override
    @Deprecated
    public void registerOutParameter(int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        if (this.filterChain == null) {
            this.do_registerOutParameter(parameterIndex, sqlType, typeName);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, parameterIndex, sqlType, typeName);
        }
    }

    @Override
    @Deprecated
    public void registerOutParameter(String parameterName, SQLType sqlType) throws SQLException {
        if (this.filterChain == null) {
            this.do_registerOutParameter(parameterName, sqlType);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, parameterName, sqlType);
        }
    }

    @Override
    @Deprecated
    public void registerOutParameter(String parameterName, SQLType sqlType, int scale) throws SQLException {
        if (this.filterChain == null) {
            this.do_registerOutParameter(parameterName, sqlType, scale);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, parameterName, sqlType, scale);
        }
    }

    @Override
    @Deprecated
    public void registerOutParameter(String parameterName, SQLType sqlType, String typeName) throws SQLException {
        if (this.filterChain == null) {
            this.do_registerOutParameter(parameterName, sqlType, typeName);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, parameterName, sqlType, typeName);
        }
    }

    public DmdbIntervalYM getINTERVALYM(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getINTERVALYM(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getINTERVALYM(this, parameterIndex);
    }

    public DmdbIntervalYM getINTERVALYM(String paramName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getINTERVALYM(paramName);
        }
        return this.filterChain.reset().CallableStatement_getINTERVALYM(this, paramName);
    }

    public DmdbIntervalDT getINTERVALDT(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getINTERVALDT(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getINTERVALDT(this, parameterIndex);
    }

    public DmdbIntervalDT getINTERVALDT(String paramName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getINTERVALDT(paramName);
        }
        return this.filterChain.reset().CallableStatement_getINTERVALDT(this, paramName);
    }

    public DmdbTimestamp getTIMESTAMP(int parameterIndex) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getTIMESTAMP(parameterIndex);
        }
        return this.filterChain.reset().CallableStatement_getTIMESTAMP(this, parameterIndex);
    }

    public DmdbTimestamp getTIMESTAMP(String paramName) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getTIMESTAMP(paramName);
        }
        return this.filterChain.reset().CallableStatement_getTIMESTAMP(this, paramName);
    }

    public void setTIMESTAMP(String paramName, DmdbTimestamp x2) throws SQLException {
        if (this.filterChain == null) {
            this.do_setTIMESTAMP(paramName, x2);
        } else {
            this.filterChain.reset().CallableStatement_setTIMESTAMP(this, paramName, x2);
        }
    }

    public void setINTERVALDT(String paramName, DmdbIntervalDT x2) throws SQLException {
        if (this.filterChain == null) {
            this.do_setINTERVALDT(paramName, x2);
        } else {
            this.filterChain.reset().CallableStatement_setINTERVALDT(this, paramName, x2);
        }
    }

    public void setINTERVALYM(String paramName, DmdbIntervalYM x2) throws SQLException {
        if (this.filterChain == null) {
            this.do_setINTERVALYM(paramName, x2);
        } else {
            this.filterChain.reset().CallableStatement_setINTERVALYM(this, paramName, x2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCursor(int parameterIndex) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getCursor(parameterIndex);
            }
            return this.filterChain.reset().CallableStatement_getCursor(this, parameterIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCursor(String parameterName) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getCursor(parameterName);
            }
            return this.filterChain.reset().CallableStatement_getCursor(this, parameterName);
        }
    }

    @Override
    public void resetParams(DmdbStatement srcStmt) throws SQLException {
        super.resetParams(srcStmt);
        if (srcStmt instanceof DmdbCallableStatement) {
            DmdbCallableStatement srcCstmt = (DmdbCallableStatement)srcStmt;
            this.nameBindCount = srcCstmt.nameBindCount;
            this.nameBindAtLeast = srcCstmt.nameBindAtLeast;
            this.ordinalBindAtLeast = srcCstmt.ordinalBindAtLeast;
        }
    }
}

