/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.dbaccess.Const;
import dm.jdbc.desc.DmServerInfo;
import dm.jdbc.desc.ServerGroup;
import dm.jdbc.util.StringUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class DmSvcConf {
    private short timeZone = Const.TIME_ZONE_DEFAULT;
    private int language = DmSvcConf.getLanguage(Locale.getDefault());
    private String charCode;
    private boolean enRsCache = false;
    private int rsCacheSize = 20;
    private int rsRefreshFreq = 10;
    private int loginMode = 0;
    private long switchTimes = 3L;
    private long switchInterval = 200L;
    private String[] keyWords = null;
    private boolean compressMsg = false;
    private boolean loginEncrypt = true;
    private String loginCertificate;
    private boolean direct = true;
    private boolean dec2Double = false;
    private boolean rwSeparate = false;
    private int rwPercent = 25;
    private static Map<String, String> addressRemap = new HashMap<String, String>();
    private int connectTimeout = 5000;
    private boolean rwAutoDistribute = true;
    private boolean doSwitch = false;
    private String cipherPath = null;
    private int compatibleMode = 0;
    public static int dbAliveCheckFreq = 0;
    public static boolean nullWithType = true;
    private boolean loadBalance = false;
    private int loadBalancePercent = 10;
    public static int loadBalanceFreq = 60000;
    public static String logDir = StringUtil.formatDir(System.getProperty("user.dir"));
    public static int logLevel = 0;
    public static int logFlushFreq = 60;
    public static int logFlusherQueueSize = 100;
    public static int logBufferSize = 1000;
    public static int logBufferPoolSize = 3;
    public static boolean statEnable = false;
    public static String statDir = null;
    public static int statFlushFreq = 10;
    public static int statSlowSqlCount = 100;
    public static int statHighFreqSqlCount = 100;
    public static int statSqlMaxCount = 100000;
    public static int STAT_SQL_REMOVE_LATEST = 1;
    public static int STAT_SQL_REMOVE_OLDEST = 2;
    public static int statSqlRemoveMode = STAT_SQL_REMOVE_LATEST;
    public static ResourceBundle res;
    private static HashMap<String, ServerGroup> serverGroupMap;
    public static DmSvcConf globalDmSvcConf;

    static {
        serverGroupMap = new HashMap();
        globalDmSvcConf = new DmSvcConf();
        DmSvcConf.readDmSvcConf();
        res = ResourceBundle.getBundle("resource.ResJDBC56", DmSvcConf.getLocale(globalDmSvcConf.getLanguage()));
    }

    protected Object clone() {
        DmSvcConf conf = new DmSvcConf();
        conf.setTimeZone(this.timeZone);
        conf.setLanguage(this.language);
        conf.setCharCode(this.charCode);
        conf.setEnRsCache(this.enRsCache);
        conf.setRsCacheSize(this.rsCacheSize);
        conf.setRsRefreshFreq(this.rsRefreshFreq);
        conf.setLoginMode(this.loginMode);
        conf.setSwitchTimes(this.switchTimes);
        conf.setSwitchInterval(this.switchInterval);
        conf.setKeyWords(this.keyWords);
        conf.setCompressMsg(this.compressMsg);
        conf.setLoginEncrypt(this.loginEncrypt);
        conf.setLoginCertificate(this.loginCertificate);
        conf.setDirect(this.direct);
        conf.setDec2Double(this.dec2Double);
        conf.setRwSeparate(this.rwSeparate);
        conf.setRwPercent(this.rwPercent);
        conf.setRwAutoDistribute(this.rwAutoDistribute);
        conf.setCipherPath(this.cipherPath);
        conf.setLoadBalance(this.loadBalance);
        conf.setLoadBalancePercent(this.loadBalancePercent);
        conf.setDoSwitch(this.doSwitch);
        conf.setConnectTimeout(this.connectTimeout);
        return conf;
    }

    public String printProperties() {
        StringBuilder str = new StringBuilder();
        str.append("TIME_ZONE = " + this.getTimeZone()).append(StringUtil.LINE_SEPARATOR);
        str.append("LANGUAGE = " + DmSvcConf.getLanguageName(this.getLanguage())).append(StringUtil.LINE_SEPARATOR);
        str.append("CHAR_CODE = " + this.getCharCode()).append(StringUtil.LINE_SEPARATOR);
        str.append("ENABLE_RS_CACHE = " + this.isEnRsCache()).append(StringUtil.LINE_SEPARATOR);
        str.append("RS_CACHE_SIZE = " + this.getRsCacheSize()).append(StringUtil.LINE_SEPARATOR);
        str.append("RS_REFRESH_FREQ = " + this.getRsRefreshFreq()).append(StringUtil.LINE_SEPARATOR);
        str.append("LOGIN_MODE = " + this.getLoginMode()).append(StringUtil.LINE_SEPARATOR);
        str.append("SWITCH_TIME = " + this.getSwitchTimes()).append(StringUtil.LINE_SEPARATOR);
        str.append("SWITCH_INTERVAL = " + this.getSwitchInterval()).append(StringUtil.LINE_SEPARATOR);
        str.append("PRIMARY_KEY = " + this.getKeyWords()).append(StringUtil.LINE_SEPARATOR);
        str.append("COMPRESS_MSG = " + this.isCompressMsg()).append(StringUtil.LINE_SEPARATOR);
        str.append("LOGIN_ENCRYPT = " + this.isLoginEncrypt()).append(StringUtil.LINE_SEPARATOR);
        str.append("LOGIN_CERTIFICATE = " + this.getLoginCertificate()).append(StringUtil.LINE_SEPARATOR);
        str.append("DIRECT = " + this.isDirect()).append(StringUtil.LINE_SEPARATOR);
        str.append("DEC2DOUB = " + this.isDec2Double()).append(StringUtil.LINE_SEPARATOR);
        str.append("RW_SEPARATE = " + this.isRwSeparate()).append(StringUtil.LINE_SEPARATOR);
        str.append("RW_PERCENT = " + this.getRwPercent()).append(StringUtil.LINE_SEPARATOR);
        str.append("RW_AUTO_DISTRIBUTE = " + this.isRwAutoDistribute()).append(StringUtil.LINE_SEPARATOR);
        str.append("DO_SWITCH = " + this.isDoSwitch()).append(StringUtil.LINE_SEPARATOR);
        str.append("CIPHER_PATH = " + this.getCipherPath()).append(StringUtil.LINE_SEPARATOR);
        str.append("COMPATIBLE_MODE = ").append(this.compatibleMode == 1 ? "oracle" : (this.compatibleMode == 2 ? "mysql" : "")).append(StringUtil.LINE_SEPARATOR);
        str.append("DB_ALIVE_CHECK_FREQ = " + dbAliveCheckFreq).append(StringUtil.LINE_SEPARATOR);
        str.append("NULL_WITH_TYPE = " + nullWithType).append(StringUtil.LINE_SEPARATOR);
        str.append("LOAD_BALANCE = " + this.loadBalance).append(StringUtil.LINE_SEPARATOR);
        str.append("LOAD_BALANCE_PERCENT = " + this.loadBalancePercent).append(StringUtil.LINE_SEPARATOR);
        str.append("LOAD_BALANCE_FREQ = " + loadBalanceFreq).append(StringUtil.LINE_SEPARATOR);
        str.append("LOG_DIR = " + logDir).append(StringUtil.LINE_SEPARATOR);
        str.append("LOG_LEVEL = " + logLevel).append(StringUtil.LINE_SEPARATOR);
        str.append("LOG_BUFFER_POOL_SIZE = " + logBufferPoolSize).append(StringUtil.LINE_SEPARATOR);
        str.append("LOG_BUFFER_SIZE = " + logBufferSize).append(StringUtil.LINE_SEPARATOR);
        str.append("LOG_FLUSHER_QUEUE_SIZE = " + logFlusherQueueSize).append(StringUtil.LINE_SEPARATOR);
        str.append("LOG_FLUSH_FREQ = " + logFlushFreq).append(StringUtil.LINE_SEPARATOR);
        str.append("STAT_ENABLE = " + statEnable).append(StringUtil.LINE_SEPARATOR);
        str.append("STAT_DIR = " + statDir).append(StringUtil.LINE_SEPARATOR);
        str.append("STAT_FLUSH_FREQ = " + statFlushFreq).append(StringUtil.LINE_SEPARATOR);
        str.append("STAT_HIGH_FREQ_SQL_COUNT = " + statHighFreqSqlCount).append(StringUtil.LINE_SEPARATOR);
        str.append("STAT_SLOW_SQL_COUNT = " + statSlowSqlCount).append(StringUtil.LINE_SEPARATOR);
        str.append("STAT_SQL_REMOVE_MODE = " + statSqlRemoveMode).append(StringUtil.LINE_SEPARATOR);
        str.append("STAT_SQL_MAX_COUNT = " + statSqlMaxCount).append(StringUtil.LINE_SEPARATOR);
        str.append("CONNECT_TIMEOUT = " + this.connectTimeout).append(StringUtil.LINE_SEPARATOR);
        return str.toString();
    }

    public static synchronized ServerGroup getServerGroup(String svrGroupName) {
        if (!serverGroupMap.containsKey(svrGroupName.toLowerCase())) {
            return null;
        }
        ServerGroup serverGroup = serverGroupMap.get(svrGroupName.toLowerCase());
        long currTime = System.currentTimeMillis();
        if (currTime - serverGroup.getConnSuccRefreshTs() > 20000L) {
            for (DmServerInfo svrInfo : serverGroup.getSvrList()) {
                svrInfo.setLastConnSucc(true);
            }
            serverGroup.setConnSuccRefreshTs(currTime);
        }
        return serverGroup;
    }

    private static void readDmSvcConf() {
        block75: {
            BufferedReader m_bufdReader = DmSvcConf.openFile();
            if (m_bufdReader == null) {
                return;
            }
            DmSvcConf dmSvcConf = globalDmSvcConf;
            try {
                try {
                    String line = null;
                    while ((line = m_bufdReader.readLine()) != null) {
                        int notesIndex = line.indexOf("#");
                        if (notesIndex != -1) {
                            line = line.substring(0, notesIndex);
                        }
                        if (StringUtil.isEmpty(line = StringUtil.trimToEmpty(line))) continue;
                        if (line.startsWith("[") && line.endsWith("]")) {
                            String groupName = StringUtil.trimToEmpty(line.substring(1, line.length() - 1)).toLowerCase();
                            if (StringUtil.isEmpty(groupName) || !serverGroupMap.containsKey(groupName) || (dmSvcConf = serverGroupMap.get(groupName).getDmSvcConf()) != null) continue;
                            dmSvcConf = (DmSvcConf)globalDmSvcConf.clone();
                            serverGroupMap.get(groupName).setDmSvcConf(dmSvcConf);
                            continue;
                        }
                        try {
                            String[] pkeys;
                            String[] cfgInfo = line.split("=");
                            if (cfgInfo.length < 2) continue;
                            String name = StringUtil.trimToEmpty(cfgInfo[0]);
                            String value = StringUtil.trimToEmpty(cfgInfo[1]);
                            if (!value.startsWith("(") || !value.endsWith(")")) continue;
                            value = StringUtil.trimToEmpty(value.substring(1, value.length() - 1));
                            if (StringUtil.isEmpty(name) || StringUtil.isEmpty(value)) continue;
                            if (name.equalsIgnoreCase("TIME_ZONE")) {
                                BigDecimal tmp = new BigDecimal(value);
                                short tz = tmp.shortValue();
                                if (-780 >= tz || tz > 780) continue;
                                dmSvcConf.setTimeZone(tz);
                                continue;
                            }
                            if (name.equalsIgnoreCase("LANGUAGE")) {
                                if (value.equalsIgnoreCase("cn")) {
                                    dmSvcConf.setLanguage(0);
                                    continue;
                                }
                                if (value.equalsIgnoreCase("tw")) {
                                    dmSvcConf.setLanguage(0);
                                    continue;
                                }
                                if (!value.equalsIgnoreCase("en")) continue;
                                dmSvcConf.setLanguage(1);
                                continue;
                            }
                            if (name.equalsIgnoreCase("CHAR_CODE")) {
                                dmSvcConf.setCharCode(value);
                                continue;
                            }
                            if (name.equalsIgnoreCase("ENABLE_RS_CACHE")) {
                                dmSvcConf.setEnRsCache(DmSvcConf.parseBoolean(value, dmSvcConf.isEnRsCache()));
                                continue;
                            }
                            if (name.equalsIgnoreCase("RS_CACHE_SIZE")) {
                                dmSvcConf.setRsCacheSize(DmSvcConf.parseInt(value, dmSvcConf.getRsCacheSize(), 1, 65535));
                                continue;
                            }
                            if (name.equalsIgnoreCase("RS_REFRESH_FREQ")) {
                                dmSvcConf.setRsRefreshFreq(DmSvcConf.parseInt(value, dmSvcConf.getRsRefreshFreq(), 0, 10000));
                                continue;
                            }
                            if (name.equalsIgnoreCase("LOGIN_PRIMARY")) {
                                if (value.equals("1")) {
                                    dmSvcConf.setLoginMode(1);
                                    continue;
                                }
                                dmSvcConf.setLoginMode(0);
                                continue;
                            }
                            if (name.equalsIgnoreCase("LOGIN_MODE")) {
                                if (value.equals("1")) {
                                    dmSvcConf.setLoginMode(1);
                                    continue;
                                }
                                if (value.equals("2")) {
                                    dmSvcConf.setLoginMode(2);
                                    continue;
                                }
                                if (value.equals("3")) {
                                    dmSvcConf.setLoginMode(3);
                                    continue;
                                }
                                dmSvcConf.setLoginMode(0);
                                continue;
                            }
                            if (name.equalsIgnoreCase("SWITCH_TIME")) {
                                dmSvcConf.setSwitchTimes(DmSvcConf.parseLong(value, dmSvcConf.getSwitchTimes(), 0L, null));
                                continue;
                            }
                            if (name.equalsIgnoreCase("SWITCH_INTERVAL")) {
                                dmSvcConf.setSwitchInterval(DmSvcConf.parseLong(value, dmSvcConf.getSwitchInterval(), 0L, null));
                                continue;
                            }
                            if (name.equalsIgnoreCase("PRIMARY_KEY")) {
                                pkeys = value.split(",");
                                if (pkeys == null || pkeys.length <= 0) continue;
                                dmSvcConf.setKeyWords(pkeys);
                                continue;
                            }
                            if (name.equalsIgnoreCase("KEYWORDS")) {
                                pkeys = value.split(",");
                                if (pkeys == null || pkeys.length <= 0) continue;
                                dmSvcConf.setKeyWords(pkeys);
                                continue;
                            }
                            if (name.equalsIgnoreCase("COMPRESS_MSG")) {
                                dmSvcConf.setCompressMsg(DmSvcConf.parseBoolean(value, dmSvcConf.isCompressMsg()));
                                continue;
                            }
                            if (name.equalsIgnoreCase("LOGIN_ENCRYPT")) {
                                dmSvcConf.setLoginEncrypt(DmSvcConf.parseBoolean(value, dmSvcConf.isLoginEncrypt()));
                                continue;
                            }
                            if (name.equalsIgnoreCase("COMMUNICATION_ENCRYPT")) {
                                dmSvcConf.setLoginEncrypt(DmSvcConf.parseBoolean(value, dmSvcConf.isLoginEncrypt()));
                                continue;
                            }
                            if (name.equalsIgnoreCase("DIRECT")) {
                                dmSvcConf.setDirect(DmSvcConf.parseBoolean(value, dmSvcConf.isDirect()));
                                continue;
                            }
                            if (name.equalsIgnoreCase("DEC2DOUB")) {
                                dmSvcConf.setDec2Double(DmSvcConf.parseBoolean(value, dmSvcConf.isDec2Double()));
                                continue;
                            }
                            if (name.equalsIgnoreCase("RW_SEPARATE")) {
                                dmSvcConf.setRwSeparate(DmSvcConf.parseBoolean(value, dmSvcConf.isRwSeparate()));
                                continue;
                            }
                            if (name.equalsIgnoreCase("RW_PERCENT")) {
                                Integer percent = Integer.valueOf(value);
                                if (percent < 0 || percent > 100) continue;
                                dmSvcConf.setRwPercent(DmSvcConf.parseInt(value, dmSvcConf.getRwPercent(), 0, 100));
                                continue;
                            }
                            if (name.equalsIgnoreCase("RW_AUTO_DISTRIBUTE")) {
                                dmSvcConf.setRwAutoDistribute(DmSvcConf.parseBoolean(value, dmSvcConf.isRwAutoDistribute()));
                                continue;
                            }
                            if (name.equalsIgnoreCase("COMPATIBLE_MODE")) {
                                if (value.equalsIgnoreCase("oracle")) {
                                    dmSvcConf.compatibleMode = 1;
                                    continue;
                                }
                                if (value.equalsIgnoreCase("mysql")) {
                                    dmSvcConf.compatibleMode = 2;
                                    continue;
                                }
                                dmSvcConf.compatibleMode = DmSvcConf.parseInt(value, dmSvcConf.compatibleMode, 1, 2);
                                continue;
                            }
                            if (name.equalsIgnoreCase("CIPHER_PATH")) {
                                dmSvcConf.setCipherPath(StringUtil.formatDir(value));
                                continue;
                            }
                            if (name.equalsIgnoreCase("LOAD_BALANCE")) {
                                dmSvcConf.setLoadBalance(DmSvcConf.parseBoolean(value, dmSvcConf.isLoadBalance()));
                                continue;
                            }
                            if (name.equalsIgnoreCase("LOAD_BALANCE_FREQ")) {
                                loadBalanceFreq = DmSvcConf.parseInt(value, loadBalanceFreq, 0, null);
                                continue;
                            }
                            if (name.equalsIgnoreCase("LOAD_BALANCE_PERCENT")) {
                                dmSvcConf.setLoadBalancePercent(DmSvcConf.parseInt(value, dmSvcConf.getLoadBalancePercent(), 0, 100));
                                continue;
                            }
                            if (name.equalsIgnoreCase("DB_ALIVE_CHECK_FREQ")) {
                                dbAliveCheckFreq = DmSvcConf.parseInt(value, dbAliveCheckFreq, 0, null);
                                continue;
                            }
                            if (name.equalsIgnoreCase("LOG_LEVEL")) {
                                if ("DEBUG".equalsIgnoreCase(value)) {
                                    logLevel = 5;
                                    continue;
                                }
                                if ("INFO".equalsIgnoreCase(value)) {
                                    logLevel = 4;
                                    continue;
                                }
                                if ("warn".equalsIgnoreCase(value)) {
                                    logLevel = 2;
                                    continue;
                                }
                                if ("error".equalsIgnoreCase(value)) {
                                    logLevel = 1;
                                    continue;
                                }
                                if ("off".equalsIgnoreCase(value)) {
                                    logLevel = 0;
                                    continue;
                                }
                                if (!"all".equalsIgnoreCase(value)) continue;
                                logLevel = 9;
                                continue;
                            }
                            if (name.equalsIgnoreCase("LOG_DIR")) {
                                logDir = StringUtil.formatDir(value);
                                continue;
                            }
                            if (name.equalsIgnoreCase("LOG_BUFFER_POOL_SIZE")) {
                                logBufferPoolSize = DmSvcConf.parseInt(value, logBufferPoolSize, 0, null);
                                continue;
                            }
                            if (name.equalsIgnoreCase("LOG_BUF_SIZE")) {
                                logBufferSize = DmSvcConf.parseInt(value, logBufferSize, 0, null);
                                continue;
                            }
                            if (name.equalsIgnoreCase("LOG_FLUSHER_QUEUE_SIZE")) {
                                logFlusherQueueSize = DmSvcConf.parseInt(value, logFlusherQueueSize, 0, null);
                                continue;
                            }
                            if (name.equalsIgnoreCase("LOG_FLUSH_FREQ")) {
                                logFlushFreq = DmSvcConf.parseInt(value, logFlushFreq, 0, null);
                                continue;
                            }
                            if (name.equalsIgnoreCase("STAT_ENABLE")) {
                                statEnable = DmSvcConf.parseBoolean(value, statEnable);
                                continue;
                            }
                            if (name.equalsIgnoreCase("STAT_DIR")) {
                                statDir = StringUtil.formatDir(value);
                                continue;
                            }
                            if (name.equalsIgnoreCase("STAT_FLUSH_FREQ")) {
                                statFlushFreq = DmSvcConf.parseInt(value, statFlushFreq, 0, null);
                                continue;
                            }
                            if (name.equalsIgnoreCase("STAT_HIGH_FREQ_SQL_COUNT")) {
                                statHighFreqSqlCount = DmSvcConf.parseInt(value, statHighFreqSqlCount, 0, 1000);
                                continue;
                            }
                            if (name.equalsIgnoreCase("STAT_SLOW_SQL_COUNT")) {
                                statSlowSqlCount = DmSvcConf.parseInt(value, statSlowSqlCount, 0, 1000);
                                continue;
                            }
                            if (name.equalsIgnoreCase("STAT_MAX_SQL_COUNT")) {
                                statSqlMaxCount = DmSvcConf.parseInt(value, statSqlMaxCount, 0, 100000);
                                continue;
                            }
                            if (name.equalsIgnoreCase("STAT_SQL_REMOVE_LATEST")) {
                                if ("oldest".equalsIgnoreCase(value) || "eldest".equalsIgnoreCase(value)) {
                                    statSqlRemoveMode = STAT_SQL_REMOVE_OLDEST;
                                    continue;
                                }
                                if ("latest".equalsIgnoreCase(value)) {
                                    statSqlRemoveMode = STAT_SQL_REMOVE_LATEST;
                                    continue;
                                }
                                statSqlRemoveMode = DmSvcConf.parseInt(value, statSqlRemoveMode, 1, 2);
                                continue;
                            }
                            if (name.equalsIgnoreCase("DO_SWITCH")) {
                                dmSvcConf.setDoSwitch(DmSvcConf.parseBoolean(value, dmSvcConf.isDoSwitch()));
                                continue;
                            }
                            if (name.equalsIgnoreCase("ADDRESS_REMAP")) {
                                String[] address = value.split(",");
                                if (address == null || address.length != 2) continue;
                                addressRemap.put(address[0], address[1]);
                                continue;
                            }
                            if (name.equalsIgnoreCase("CONNECT_TIMEOUT")) {
                                dmSvcConf.setConnectTimeout(DmSvcConf.parseInt(value, dmSvcConf.getConnectTimeout(), 0, null));
                                continue;
                            }
                            if (name.equalsIgnoreCase("LOGIN_CERTIFICATE")) {
                                dmSvcConf.setLoginCertificate(DmSvcConf.parseString(value, dmSvcConf.getLoginCertificate()));
                                continue;
                            }
                            ServerGroup serverGroup = DmSvcConf.readServerGroup(name, value);
                            if (serverGroup == null) continue;
                            serverGroupMap.put(name.toLowerCase(), serverGroup);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (IOException iOException) {
                    try {
                        m_bufdReader.close();
                    }
                    catch (IOException iOException2) {}
                    break block75;
                }
            }
            catch (Throwable throwable) {
                try {
                    m_bufdReader.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                m_bufdReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static ServerGroup readServerGroup(String name, String value) {
        String[] values = value.split(",");
        if (values == null) {
            return null;
        }
        String[] tmpVals = null;
        String tmpName = null;
        int tmpPort = 5236;
        ArrayList<DmServerInfo> svrList = new ArrayList<DmServerInfo>();
        int i = 0;
        while (i < values.length) {
            DmServerInfo tmp = null;
            int begin = values[i].indexOf("[");
            int end = -1;
            if (begin != -1) {
                end = values[i].indexOf("]", begin);
            }
            if (end != -1) {
                tmpName = values[i].substring(begin + 1, end);
                int portIndex = values[i].indexOf(":", end);
                if (portIndex != -1) {
                    tmpPort = Integer.parseInt(values[i].substring(portIndex + 1).trim());
                    tmp = new DmServerInfo(tmpName, tmpPort);
                } else {
                    tmp = new DmServerInfo(tmpName);
                }
                svrList.add(tmp);
            } else {
                tmpVals = values[i].split(":");
                if (tmpVals != null) {
                    tmpName = tmpVals[0].trim();
                    if (tmpVals.length >= 2) {
                        tmpPort = Integer.parseInt(tmpVals[1]);
                        tmp = new DmServerInfo(tmpName, tmpPort);
                    } else {
                        tmp = new DmServerInfo(tmpName);
                    }
                    svrList.add(tmp);
                }
            }
            ++i;
        }
        if (svrList.size() > 0) {
            ServerGroup sg = new ServerGroup(name, svrList);
            return sg;
        }
        return null;
    }

    private static boolean isJavaVersion14() {
        String strVersion = System.getProperty("java.version");
        return strVersion.indexOf("1.4") != -1;
    }

    private static String getFilePath() {
        String filePath = null;
        if (System.getProperty("os.name").startsWith("Win")) {
            filePath = !DmSvcConf.isJavaVersion14() ? System.getenv("SystemRoot") : "C:\\WINDOWS";
            filePath = String.valueOf(filePath) + "\\system32\\dm_svc.conf";
        } else {
            filePath = "/etc/dm_svc.conf";
        }
        return filePath;
    }

    private static BufferedReader openFile() {
        String filePath = DmSvcConf.getFilePath();
        try {
            if (filePath != null) {
                return new BufferedReader(new FileReader(filePath));
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public short getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(short timeZone) {
        this.timeZone = timeZone;
    }

    public int getLanguage() {
        return this.language;
    }

    public void setLanguage(int language) {
        this.language = language;
    }

    public String getCharCode() {
        return this.charCode;
    }

    public void setCharCode(String charCode) {
        this.charCode = charCode;
    }

    public boolean isEnRsCache() {
        return this.enRsCache;
    }

    public void setEnRsCache(boolean enRsCache) {
        this.enRsCache = enRsCache;
    }

    public int getRsCacheSize() {
        return this.rsCacheSize;
    }

    public void setRsCacheSize(int rsCacheSize) {
        this.rsCacheSize = rsCacheSize;
    }

    public int getRsRefreshFreq() {
        return this.rsRefreshFreq;
    }

    public void setRsRefreshFreq(int rsRefreshFreq) {
        this.rsRefreshFreq = rsRefreshFreq;
    }

    public int getLoginMode() {
        return this.loginMode;
    }

    public void setLoginMode(int loginMode) {
        this.loginMode = loginMode;
    }

    public long getSwitchTimes() {
        return this.switchTimes;
    }

    public void setSwitchTimes(long switchTimes) {
        this.switchTimes = switchTimes;
    }

    public long getSwitchInterval() {
        return this.switchInterval;
    }

    public void setSwitchInterval(long switchInterval) {
        this.switchInterval = switchInterval;
    }

    public String[] getKeyWords() {
        return this.keyWords;
    }

    public void setKeyWords(String[] keyWords) {
        this.keyWords = keyWords;
    }

    public boolean isCompressMsg() {
        return this.compressMsg;
    }

    public void setCompressMsg(boolean compressMsg) {
        this.compressMsg = compressMsg;
    }

    public boolean isLoginEncrypt() {
        return this.loginEncrypt;
    }

    public void setLoginEncrypt(boolean loginEncrypt) {
        this.loginEncrypt = loginEncrypt;
    }

    public String getLoginCertificate() {
        return this.loginCertificate;
    }

    public void setLoginCertificate(String loginCertificate) {
        this.loginCertificate = loginCertificate;
    }

    public boolean isDirect() {
        return this.direct;
    }

    public void setDirect(boolean direct) {
        this.direct = direct;
    }

    public boolean isDec2Double() {
        return this.dec2Double;
    }

    public void setDec2Double(boolean dec2Double) {
        this.dec2Double = dec2Double;
    }

    public boolean isRwSeparate() {
        return this.rwSeparate;
    }

    public void setRwSeparate(boolean rwSeparate) {
        this.rwSeparate = rwSeparate;
    }

    public int getRwPercent() {
        return this.rwPercent;
    }

    public void setRwPercent(int rwPercent) {
        this.rwPercent = rwPercent;
    }

    public String getCipherPath() {
        return this.cipherPath;
    }

    public void setCipherPath(String cipherPath) {
        this.cipherPath = cipherPath;
    }

    public boolean getKeywordOpen() {
        return this.keyWords != null && this.keyWords.length > 0;
    }

    public static int getLanguage(Locale local) {
        if (local.getLanguage().equalsIgnoreCase("zh")) {
            return 0;
        }
        return 1;
    }

    public static String getLanguageName(int language) {
        switch (language) {
            case 0: {
                return "CN";
            }
            case 2: {
                return "TW";
            }
        }
        return "EN";
    }

    public static Locale getLocale(int language) {
        switch (language) {
            case 0: {
                return Locale.CHINA;
            }
            case 2: {
                return Locale.TAIWAN;
            }
        }
        return Locale.US;
    }

    public void setRwAutoDistribute(boolean rwAutoDistribute) {
        this.rwAutoDistribute = rwAutoDistribute;
    }

    public boolean isRwAutoDistribute() {
        return this.rwAutoDistribute;
    }

    public boolean isCompatibleMysql() {
        return this.compatibleMode == 2;
    }

    public boolean isCompatibleOracle() {
        return this.compatibleMode == 1;
    }

    public void setCompatibleMode(int compatibleMode) {
        this.compatibleMode = compatibleMode;
    }

    public boolean isLoadBalance() {
        return this.loadBalance;
    }

    public void setLoadBalance(boolean loadBalance) {
        this.loadBalance = loadBalance;
    }

    public int getLoadBalancePercent() {
        return this.loadBalancePercent;
    }

    public void setLoadBalancePercent(int percent) {
        this.loadBalancePercent = percent;
    }

    public static boolean parseBoolean(String value, boolean def) {
        if (StringUtil.isEmpty(value)) {
            return def;
        }
        if (value.equals("0")) {
            return false;
        }
        if (value.equals("1")) {
            return true;
        }
        return Boolean.valueOf(value);
    }

    public static int parseInt(String value, int def, Integer min, Integer max) {
        if (StringUtil.isEmpty(value)) {
            return def;
        }
        try {
            int intValue = Integer.parseInt(value);
            if (max != null && intValue > max) {
                return def;
            }
            if (min != null && intValue < min) {
                return def;
            }
            return intValue;
        }
        catch (Exception exception) {
            return def;
        }
    }

    private static long parseLong(String value, long def, Long min, Long max) {
        if (StringUtil.isEmpty(value)) {
            return def;
        }
        try {
            long longValue = Long.parseLong(value);
            if (max != null && longValue > max) {
                return def;
            }
            if (min != null && longValue < min) {
                return def;
            }
            return longValue;
        }
        catch (Exception exception) {
            return def;
        }
    }

    public static String parseString(String value, String def) {
        if (StringUtil.isEmpty(value)) {
            return def;
        }
        return StringUtil.trimToEmpty(value);
    }

    public void setDoSwitch(boolean doSwitch) {
        this.doSwitch = doSwitch;
    }

    public boolean isDoSwitch() {
        return this.rwSeparate ? true : this.doSwitch;
    }

    public static String addressRemap(String address) {
        return addressRemap.get(address);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }
}

