/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.template;

import org.frameworkset.elasticsearch.client.ConfigHolder;
import org.frameworkset.elasticsearch.template.ConfigDSLUtil;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.assemble.LinkConfigFile;
import org.frameworkset.spi.assemble.Pro;
import org.frameworkset.spi.assemble.ProviderParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESSOAProviderParser
extends ProviderParser {
    private static Logger logger = LoggerFactory.getLogger(ESSOAProviderParser.class);
    private ConfigHolder configHolder;

    public ESSOAProviderParser(ConfigHolder configHolder, BaseApplicationContext applicationContext, String file, LinkConfigFile linkfile) {
        super(applicationContext, file, linkfile);
        this.configHolder = configHolder;
    }

    public ESSOAProviderParser(ConfigHolder configHolder, BaseApplicationContext applicationContext) {
        super(applicationContext);
        this.configHolder = configHolder;
    }

    public Object getRealPropertyValue(Pro pro) {
        String templateFile = (String)pro.getExtendAttribute("templateFile");
        if (templateFile == null) {
            return pro.getValue();
        }
        String templateName = (String)pro.getExtendAttribute("templateName");
        if (templateName == null) {
            logger.warn("The DSL template " + pro.getName() + " in the DSl file " + this.applicationContext.getConfigfile() + " is defined as a reference to the DSL template in another configuration file " + templateFile + ", but the name of the DSL template statement to be referenced is not specified by the templateName attribute, for example:\r\n" + "<property name= \"querySqlTraces\"\r\n" + "templateFile= \"esmapper/estrace/ESTracesMapper.xml\"\r\n" + "templateName= \"queryTracesByCriteria\"/>");
            return null;
        }
        ConfigDSLUtil.ESRef ref = new ConfigDSLUtil.ESRef(this.configHolder, templateName, templateFile, pro.getName(), this.applicationContext.getBaseDir());
        return ref.getTemplate();
    }
}

