/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.serial;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import java.io.Writer;
import org.frameworkset.elasticsearch.ElasticsearchConstant;
import org.frameworkset.elasticsearch.entity.ESBaseData;
import org.frameworkset.elasticsearch.entity.ESId;
import org.frameworkset.elasticsearch.serial.DefaultEntityCustomSerializationFactory;
import org.frameworkset.elasticsearch.serial.ESBaseDataEntityCustomSerializationFactory;
import org.frameworkset.elasticsearch.serial.ESIdEntityCustomSerializationFactory;
import org.frameworkset.json.Jackson2ObjectMapper;
import org.frameworkset.util.annotations.DateFormateMeta;

public class SerialUtil {
    protected static ObjectMapper normaMapper = null;
    protected static ObjectMapper esBaseDataFilterMapper = null;
    protected static ObjectMapper esIdFilterMapper = null;
    protected static DateFormateMeta dateFormateMeta;
    private static ClassLoader moduleClassLoader;

    public static DateFormateMeta getDateFormateMeta() {
        return dateFormateMeta;
    }

    public static void init(DateFormateMeta dateFormateMeta) {
        normaMapper = new ObjectMapper();
        normaMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, ElasticsearchConstant.FAIL_ON_UNKNOWN_PROPERTIES);
        normaMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        normaMapper.setDateFormat(dateFormateMeta.toDateFormat());
        normaMapper.setSerializerFactory((SerializerFactory)new DefaultEntityCustomSerializationFactory());
        Jackson2ObjectMapper.registerWellKnownModulesIfAvailable((ObjectMapper)normaMapper);
        esBaseDataFilterMapper = new ObjectMapper();
        esBaseDataFilterMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, ElasticsearchConstant.FAIL_ON_UNKNOWN_PROPERTIES);
        esBaseDataFilterMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        esBaseDataFilterMapper.setDateFormat(dateFormateMeta.toDateFormat());
        esBaseDataFilterMapper.setSerializerFactory((SerializerFactory)new ESBaseDataEntityCustomSerializationFactory());
        Jackson2ObjectMapper.registerWellKnownModulesIfAvailable((ObjectMapper)esBaseDataFilterMapper);
        esIdFilterMapper = new ObjectMapper();
        esIdFilterMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, ElasticsearchConstant.FAIL_ON_UNKNOWN_PROPERTIES);
        esIdFilterMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        esIdFilterMapper.setDateFormat(dateFormateMeta.toDateFormat());
        esIdFilterMapper.setSerializerFactory((SerializerFactory)new ESIdEntityCustomSerializationFactory());
        Jackson2ObjectMapper.registerWellKnownModulesIfAvailable((ObjectMapper)esIdFilterMapper);
    }

    public static String object2json(Object bean) {
        try {
            Class<?> beanClass = bean.getClass();
            if (ESBaseData.class.isAssignableFrom(beanClass)) {
                String value = esBaseDataFilterMapper.writeValueAsString(bean);
                return value;
            }
            if (ESId.class.isAssignableFrom(beanClass)) {
                String value = esIdFilterMapper.writeValueAsString(bean);
                return value;
            }
            String value = normaMapper.writeValueAsString(bean);
            return value;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error JSON serialization operation", e);
        }
    }

    public static void object2json(Object bean, Writer writer) {
        try {
            Class<?> beanClass = bean.getClass();
            if (ESBaseData.class.isAssignableFrom(beanClass)) {
                esBaseDataFilterMapper.writeValue(writer, bean);
            } else if (ESId.class.isAssignableFrom(beanClass)) {
                esIdFilterMapper.writeValue(writer, bean);
            } else {
                normaMapper.writeValue(writer, bean);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error JSON serialization operation", e);
        }
    }

    public static void normalObject2json(Object bean, Writer writer) {
        try {
            normaMapper.writeValue(writer, bean);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error JSON serialization operation", e);
        }
    }

    static {
        moduleClassLoader = SerialUtil.class.getClassLoader();
        dateFormateMeta = DateFormateMeta.buildDateFormateMeta((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", null, (String)"Etc/UTC");
        SerialUtil.init(dateFormateMeta);
    }
}

