/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.frameworkset.elasticsearch.ElasticSearch;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.client.ESAddress;
import org.frameworkset.elasticsearch.client.ElasticSearchRestClient;
import org.frameworkset.spi.remote.http.ResponseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostDiscover
extends Thread {
    private final JsonFactory jsonFactory;
    private static Logger logger = LoggerFactory.getLogger(HostDiscover.class);
    private Scheme scheme = Scheme.HTTP;
    private long discoverInterval = 10000L;
    private ClientInterface clientInterface;
    private ElasticSearch elasticSearch;
    private ElasticSearchRestClient elasticSearchRestClient;
    boolean stop = false;

    public HostDiscover(String elasticsearchName, ElasticSearchRestClient elasticSearchRestClient) {
        super("ElasticSearch[" + elasticsearchName + "] HostDiscover Thread");
        this.jsonFactory = new JsonFactory();
        this.elasticSearchRestClient = elasticSearchRestClient;
        this.elasticSearch = elasticSearchRestClient.getElasticSearch();
        this.clientInterface = this.elasticSearch.getRestClientUtil();
        this.scheme = !elasticSearchRestClient.isUseHttps() ? Scheme.HTTP : Scheme.HTTPS;
        this.setDaemon(true);
    }

    public synchronized void stopCheck() {
        if (this.stop) {
            return;
        }
        this.stop = true;
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void handleDiscoverHosts(List<HttpHost> httpHosts) {
        ArrayList<ESAddress> hosts = new ArrayList<ESAddress>();
        for (HttpHost host : httpHosts) {
            ESAddress esAddress = new ESAddress(host.toString(), this.elasticSearch.getHealthPath());
            hosts.add(esAddress);
        }
        ArrayList<ESAddress> newAddress = new ArrayList<ESAddress>();
        this.elasticSearchRestClient.recoverRemovedNodes(hosts);
        for (int i = 0; i < hosts.size(); ++i) {
            ESAddress address = new ESAddress(((ESAddress)hosts.get(i)).toString(), this.elasticSearch.getHealthPath());
            if (this.elasticSearchRestClient.containAddress(address)) continue;
            newAddress.add(address);
        }
        if (newAddress.size() > 0) {
            if (logger.isInfoEnabled()) {
                logger.info("Discovery new elasticsearch[" + this.elasticSearch.getElasticSearchName() + "] node [" + newAddress + "].");
            }
            this.elasticSearchRestClient.addAddresses(newAddress);
        }
        this.elasticSearchRestClient.handleRemoved(hosts);
    }

    @Override
    public void run() {
        while (!this.stop) {
            block5: {
                try {
                    this.clientInterface.discover("_nodes/http", "get", new ResponseHandler<Void>(){

                        public Void handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                            int status = response.getStatusLine().getStatusCode();
                            if (status >= 200 && status < 300) {
                                List hosts = HostDiscover.this.readHosts(response.getEntity());
                                HostDiscover.this.handleDiscoverHosts(hosts);
                            }
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    if (!logger.isInfoEnabled()) break block5;
                    logger.info("Discovery elasticsearch[" + this.elasticSearch.getElasticSearchName() + "] node failed:", (Throwable)e);
                }
            }
            try {
                HostDiscover.sleep(this.discoverInterval);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    /*
     * Loose catch block
     */
    private List<HttpHost> readHosts(HttpEntity entity) throws IOException {
        InputStream inputStream = null;
        IOException var3 = null;
        try {
            inputStream = entity.getContent();
            if (ResponseUtil.entityEmpty((HttpEntity)entity, (InputStream)inputStream)) {
                throw new IOException("Read Hosts from http entity for elasticsearch[" + this.elasticSearch.getElasticSearchName() + "] failed: entity contentLength = 0 ");
            }
            JsonParser parser = this.jsonFactory.createParser(inputStream);
            if (parser.nextToken() != JsonToken.START_OBJECT) {
                throw new IOException("expected data to start with an object for elasticsearch[" + this.elasticSearch.getElasticSearchName() + "]");
            }
            ArrayList<HttpHost> hosts = new ArrayList<HttpHost>();
            block10: while (true) {
                if (parser.nextToken() == JsonToken.END_OBJECT) {
                    ArrayList<HttpHost> var18;
                    ArrayList<HttpHost> arrayList = var18 = hosts;
                    return arrayList;
                }
                if (parser.getCurrentToken() != JsonToken.START_OBJECT) continue;
                if ("nodes".equals(parser.getCurrentName())) {
                    while (true) {
                        if (parser.nextToken() == JsonToken.END_OBJECT) continue block10;
                        JsonToken token = parser.nextToken();
                        assert (token == JsonToken.START_OBJECT);
                        String nodeId = parser.getCurrentName();
                        HttpHost sniffedHost = this.readHost(nodeId, parser, this.scheme);
                        if (sniffedHost == null) continue;
                        if (logger.isTraceEnabled()) {
                            logger.trace("Adding node [" + nodeId + "] for elasticsearch[" + this.elasticSearch.getElasticSearchName() + "]");
                        }
                        hosts.add(sniffedHost);
                    }
                }
                parser.skipChildren();
                continue;
                break;
            }
            catch (IOException var16) {
                var3 = var16;
                throw var16;
            }
        }
        finally {
            if (inputStream != null) {
                if (var3 != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {}
                } else {
                    inputStream.close();
                }
            }
        }
    }

    private HttpHost readHost(String nodeId, JsonParser parser, Scheme scheme) throws IOException {
        HttpHost httpHost = null;
        String fieldName = null;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            if (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                fieldName = parser.getCurrentName();
                continue;
            }
            if (parser.getCurrentToken() != JsonToken.START_OBJECT) continue;
            if (!"http".equals(fieldName)) {
                parser.skipChildren();
                continue;
            }
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                if (parser.getCurrentToken() == JsonToken.VALUE_STRING && "publish_address".equals(parser.getCurrentName())) {
                    URI boundAddressAsURI = URI.create((Object)((Object)scheme) + "://" + HostDiscover.publishAddressHandle(parser.getValueAsString()));
                    httpHost = new HttpHost(boundAddressAsURI.getHost(), boundAddressAsURI.getPort(), boundAddressAsURI.getScheme());
                    continue;
                }
                if (parser.getCurrentToken() != JsonToken.START_OBJECT) continue;
                parser.skipChildren();
            }
        }
        if (httpHost == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("skipping node [" + nodeId + "] with http disabled  for elasticsearch[" + this.elasticSearch.getElasticSearchName() + "]");
            }
            return null;
        }
        return httpHost;
    }

    public static String publishAddressHandle(String publishAddress) {
        int i = publishAddress.indexOf("/");
        if (i >= 0) {
            return publishAddress.substring(i + 1);
        }
        return publishAddress;
    }

    public static enum Scheme {
        HTTP("http"),
        HTTPS("https");

        private final String name;

        private Scheme(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

