/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import java.util.List;
import java.util.Map;
import org.apache.http.client.ResponseHandler;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.IndexNameBuilder;
import org.frameworkset.elasticsearch.client.BuildTool;
import org.frameworkset.elasticsearch.client.ElasticSearchClient;
import org.frameworkset.elasticsearch.client.ElasticSearchRestClient;
import org.frameworkset.elasticsearch.client.ExecuteRequestUtil;
import org.frameworkset.elasticsearch.client.RestClientUtil;
import org.frameworkset.elasticsearch.client.ResultUtil;
import org.frameworkset.elasticsearch.entity.AggHit;
import org.frameworkset.elasticsearch.entity.ESAggDatas;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.entity.MapRestResponse;
import org.frameworkset.elasticsearch.entity.RestResponse;
import org.frameworkset.elasticsearch.entity.sql.SQLRestResponse;
import org.frameworkset.elasticsearch.entity.sql.SQLRestResponseHandler;
import org.frameworkset.elasticsearch.entity.sql.SQLResult;
import org.frameworkset.elasticsearch.entity.suggest.CompleteRestResponse;
import org.frameworkset.elasticsearch.entity.suggest.PhraseRestResponse;
import org.frameworkset.elasticsearch.entity.suggest.TermRestResponse;
import org.frameworkset.elasticsearch.handler.ESAggBucketHandle;
import org.frameworkset.elasticsearch.handler.ESMapResponseHandler;
import org.frameworkset.elasticsearch.handler.ElasticSearchResponseHandler;
import org.frameworkset.elasticsearch.scroll.ScrollHandler;
import org.frameworkset.elasticsearch.serial.ESTypeReferences;
import org.frameworkset.elasticsearch.template.BaseTemplateContainerImpl;
import org.frameworkset.elasticsearch.template.ConfigDSLUtil;
import org.frameworkset.elasticsearch.template.ESInfo;
import org.frameworkset.elasticsearch.template.ESTemplateHelper;
import org.frameworkset.elasticsearch.template.TemplateContainer;
import org.frameworkset.util.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigRestClientUtil
extends RestClientUtil {
    private static Logger logger = LoggerFactory.getLogger(AbstractConfigRestClientUtil.class);
    protected static String java_date_format = "yyyy-MM-dd HH:mm:ss";
    protected String configFile;
    protected ConfigDSLUtil configDSLUtil = null;

    public AbstractConfigRestClientUtil(ElasticSearchClient client, IndexNameBuilder indexNameBuilder, String configFile) {
        super(client, indexNameBuilder);
        this.configFile = configFile;
        this.configDSLUtil = ElasticSearchHelper.configHolder.getConfigDSLUtil(client.getElasticSearch().getDslMappingDir(), configFile);
    }

    @Override
    public TemplateContainer getTemplatecontext() {
        if (this.configDSLUtil != null) {
            return this.configDSLUtil.getTemplatecontext();
        }
        return null;
    }

    protected String evalTemplate(String templateName, Object params) {
        return ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params);
    }

    public AbstractConfigRestClientUtil(BaseTemplateContainerImpl templateContainer, ElasticSearchClient client, IndexNameBuilder indexNameBuilder) {
        super(client, indexNameBuilder);
        templateContainer.setConfigHolder(ElasticSearchHelper.configHolder);
        this.configDSLUtil = ElasticSearchHelper.configHolder.getConfigDSLUtil(templateContainer);
    }

    @Override
    public String reindexByDsl(String actionUrl, String dslName, Object params) {
        return this.client.executeHttp(actionUrl, ESTemplateHelper.evalTemplate(this.configDSLUtil, dslName, params), "post");
    }

    @Override
    public String evalConfigDsl(String dslName, Object params) {
        return ESTemplateHelper.evalTemplate(this.configDSLUtil, dslName, params);
    }

    @Override
    public String reindexByDsl(String actionUrl, String dslName) {
        return this.client.executeHttp(actionUrl, ESTemplateHelper.evalTemplate(this.configDSLUtil, dslName, null), "post");
    }

    public Object execute(String options) throws ElasticSearchException {
        return this.client.execute(this.bulkBuilder.toString(), options);
    }

    @Override
    public String addDocuments(String indexName, String indexType, String addTemplate, List<?> beans) throws ElasticSearchException {
        return this.addDocuments(indexName, indexType, addTemplate, beans, null);
    }

    @Override
    public String addDocuments(String indexName, String indexType, String addTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        return ExecuteRequestUtil._addDocuments(this.client, this.configDSLUtil, indexName, indexType, addTemplate, beans, refreshOption);
    }

    @Override
    public String updateDocuments(String indexName, String indexType, String updateTemplate, List<?> beans) throws ElasticSearchException {
        return this.updateDocuments(indexName, indexType, updateTemplate, beans, (String)null);
    }

    @Override
    public String updateDocuments(String indexName, String indexType, String updateTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        return ExecuteRequestUtil._updateDocuments(this.client, this.configDSLUtil, indexName, indexType, updateTemplate, beans, refreshOption);
    }

    @Override
    public String addDateDocuments(String indexName, String indexType, String addTemplate, List<?> beans) throws ElasticSearchException {
        return this.addDocuments(this.indexNameBuilder.getIndexName(indexName), indexType, addTemplate, beans);
    }

    @Override
    public String addDateDocuments(String indexName, String indexType, String addTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        return this.addDocuments(this.indexNameBuilder.getIndexName(indexName), indexType, addTemplate, beans, refreshOption);
    }

    @Override
    public String addDocument(String indexName, String indexType, String addTemplate, Object bean) throws ElasticSearchException {
        return this.addDocument(indexName, indexType, addTemplate, bean, null);
    }

    @Override
    public String addDocument(String indexName, String indexType, String addTemplate, Object bean, String refreshOption) throws ElasticSearchException {
        return this._addDocument(this.client, indexName, indexType, addTemplate, bean, refreshOption);
    }

    protected String _addDocument(ElasticSearchRestClient client, String indexName, String indexType, String addTemplate, Object bean, String refreshOption) throws ElasticSearchException {
        StringBuilder builder = new StringBuilder();
        ClassUtil.ClassInfo classInfo = ClassUtil.getClassInfo(bean.getClass());
        Object id = BuildTool.getId(bean, classInfo);
        Object routing = BuildTool.getRouting(bean, classInfo);
        builder.append(indexName).append("/").append(indexType);
        if (id != null) {
            builder.append("/").append(id);
        }
        Object parentId = BuildTool.getParentId(bean, classInfo);
        if (refreshOption != null) {
            builder.append("?").append(refreshOption);
            if (parentId != null) {
                builder.append("&parent=").append(parentId);
            }
            if (routing != null) {
                builder.append("&routing=").append(routing);
            }
        } else if (parentId != null) {
            builder.append("?parent=").append(parentId);
            if (routing != null) {
                builder.append("&routing=").append(routing);
            }
        } else if (routing != null) {
            builder.append("?routing=").append(routing);
        }
        String path = builder.toString();
        builder.setLength(0);
        path = client.executeHttp(path, ESTemplateHelper.evalDocumentTemplate(this.configDSLUtil, builder, indexType, indexName, addTemplate, bean, "create"), "post");
        builder = null;
        return path;
    }

    @Override
    public String addDateDocument(String indexName, String indexType, String addTemplate, Object bean) throws ElasticSearchException {
        return this.addDocument(this.indexNameBuilder.getIndexName(indexName), indexType, addTemplate, bean);
    }

    @Override
    public String addDateDocument(String indexName, String indexType, String addTemplate, Object bean, String refreshOption) throws ElasticSearchException {
        return this.addDocument(this.indexNameBuilder.getIndexName(indexName), indexType, addTemplate, bean, refreshOption);
    }

    @Override
    public String executeRequest(String path, String templateName) throws ElasticSearchException {
        return super.executeRequest(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null));
    }

    @Override
    public String executeRequest(String path, String templateName, Map params) throws ElasticSearchException {
        return super.executeRequest(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params));
    }

    @Override
    public String executeRequest(String path, String templateName, Object params) throws ElasticSearchException {
        return super.executeRequest(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params));
    }

    @Override
    public <T> T executeRequest(String path, String templateName, Map params, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return super.executeRequest(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), responseHandler);
    }

    @Override
    public <T> T executeRequest(String path, String templateName, Object params, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return super.executeRequest(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), responseHandler);
    }

    @Override
    public String deleteByQuery(String path, String templateName) throws ElasticSearchException {
        return this.client.executeHttp(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null), "post");
    }

    @Override
    public String deleteByQuery(String path, String templateName, Map params) throws ElasticSearchException {
        return this.client.executeHttp(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), "post");
    }

    @Override
    public String deleteByQuery(String path, String templateName, Object params) throws ElasticSearchException {
        return this.client.executeHttp(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), "post");
    }

    @Override
    public String executeHttp(String path, String templateName, String action) throws ElasticSearchException {
        return super.executeHttp(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null), action);
    }

    @Override
    public <T> T executeHttp(String path, String templateName, String action, Map params, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return super.executeHttp(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), action, responseHandler);
    }

    @Override
    public String executeHttp(String path, String templateName, Map params, String action) throws ElasticSearchException {
        return super.executeHttp(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), action);
    }

    @Override
    public <T> T executeHttp(String path, String templateName, String action, Object bean, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return super.executeHttp(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, bean), action, responseHandler);
    }

    @Override
    public <T> T executeHttp(String path, String templateName, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return super.executeHttp(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null), action, responseHandler);
    }

    @Override
    public String executeHttp(String path, String templateName, Object bean, String action) throws ElasticSearchException {
        return super.executeHttp(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, bean), action);
    }

    @Override
    public <T> T executeRequest(String path, String templateName, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return super.executeRequest(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null), responseHandler);
    }

    @Override
    public <T> List<T> sql(Class<T> beanType, String templateName, Map params) throws ElasticSearchException {
        SQLRestResponse result = (SQLRestResponse)this.client.executeRequest("/_xpack/sql", ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), new SQLRestResponseHandler());
        return ResultUtil.buildSQLResult(result, beanType);
    }

    @Override
    public <T> List<T> sql(Class<T> beanType, String templateName, Object bean) throws ElasticSearchException {
        SQLRestResponse result = (SQLRestResponse)this.client.executeRequest("/_xpack/sql", ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, bean), new SQLRestResponseHandler());
        return ResultUtil.buildSQLResult(result, beanType);
    }

    @Override
    public <T> List<T> sql(Class<T> beanType, String templateName) throws ElasticSearchException {
        SQLRestResponse result = (SQLRestResponse)this.client.executeRequest("/_xpack/sql", ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null), new SQLRestResponseHandler());
        return ResultUtil.buildSQLResult(result, beanType);
    }

    @Override
    public <T> SQLResult<T> fetchQuery(Class<T> beanType, String templateName, Map params) throws ElasticSearchException {
        SQLRestResponse result = (SQLRestResponse)this.client.executeRequest("/_xpack/sql", ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), new SQLRestResponseHandler());
        SQLResult<T> datas = ResultUtil.buildFetchSQLResult(result, beanType, (SQLResult)null);
        datas.setClientInterface(this);
        return datas;
    }

    @Override
    public <T> SQLResult<T> fetchQuery(Class<T> beanType, String templateName, Object bean) throws ElasticSearchException {
        SQLRestResponse result = (SQLRestResponse)this.client.executeRequest("/_xpack/sql", ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, bean), new SQLRestResponseHandler());
        SQLResult<T> datas = ResultUtil.buildFetchSQLResult(result, beanType, (SQLResult)null);
        datas.setClientInterface(this);
        return datas;
    }

    @Override
    public <T> SQLResult<T> fetchQuery(Class<T> beanType, String templateName) throws ElasticSearchException {
        SQLRestResponse result = (SQLRestResponse)this.client.executeRequest("/_xpack/sql", ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null), new SQLRestResponseHandler());
        SQLResult<T> datas = ResultUtil.buildFetchSQLResult(result, beanType, (SQLResult)null);
        datas.setClientInterface(this);
        return datas;
    }

    @Override
    public <T> T sqlObject(Class<T> beanType, String templateName, Map params) throws ElasticSearchException {
        SQLRestResponse result = (SQLRestResponse)this.client.executeRequest("/_xpack/sql", ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), new SQLRestResponseHandler());
        return ResultUtil.buildSQLObject(result, beanType);
    }

    @Override
    public <T> T sqlObject(Class<T> beanType, String templateName, Object bean) throws ElasticSearchException {
        if (bean instanceof Map) {
            return this.sqlObject(beanType, templateName, (Map)bean);
        }
        SQLRestResponse result = (SQLRestResponse)this.client.executeRequest("/_xpack/sql", ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, bean), new SQLRestResponseHandler());
        return ResultUtil.buildSQLObject(result, beanType);
    }

    @Override
    public <T> T sqlObject(Class<T> beanType, String templateName) throws ElasticSearchException {
        SQLRestResponse result = (SQLRestResponse)this.client.executeRequest("/_xpack/sql", ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null), new SQLRestResponseHandler());
        return ResultUtil.buildSQLObject(result, beanType);
    }

    @Override
    public MapRestResponse search(String path, String templateName, Map params) throws ElasticSearchException {
        return super.search(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params));
    }

    @Override
    public MapRestResponse search(String path, String templateName, Object params) throws ElasticSearchException {
        return super.search(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params));
    }

    @Override
    public MapRestResponse search(String path, String templateName) throws ElasticSearchException {
        return super.search(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null));
    }

    @Override
    public long count(String index, String templateName) throws ElasticSearchException {
        return super.count(index, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null));
    }

    @Override
    public long count(String index, String templateName, Map params) throws ElasticSearchException {
        return super.count(index, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params));
    }

    @Override
    public long count(String index, String templateName, Object params) throws ElasticSearchException {
        return super.count(index, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params));
    }

    @Override
    public RestResponse search(String path, String templateName, Map params, Class<?> type) throws ElasticSearchException {
        return super.search(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), type);
    }

    @Override
    public RestResponse search(String path, String templateName, Object params, Class<?> type) throws ElasticSearchException {
        return super.search(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), type);
    }

    @Override
    public RestResponse search(String path, String templateName, Class<?> type) throws ElasticSearchException {
        return super.search(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null), type);
    }

    @Override
    public <T> ESDatas<T> searchList(String path, String templateName, Map params, Class<T> type) throws ElasticSearchException {
        return super.searchList(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), type);
    }

    @Override
    public <T> List<ESDatas<T>> msearchList(String path, String dslName, Class<T> type) throws ElasticSearchException {
        return super.msearchList(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, dslName, null), type);
    }

    @Override
    public <T> List<ESDatas<T>> msearchList(String path, String dslName, Map params, Class<T> type) throws ElasticSearchException {
        return super.msearchList(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, dslName, params), type);
    }

    @Override
    public List<RestResponse> msearch(String path, String entity, Class<?> type) throws ElasticSearchException {
        return super.msearch(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, entity, null), type);
    }

    @Override
    public List<RestResponse> msearch(String path, String dslName, Map params, Class<?> type) throws ElasticSearchException {
        return super.msearch(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, dslName, params), type);
    }

    @Override
    public <T> ESDatas<T> searchList(String path, String templateName, Object params, Class<T> type) throws ElasticSearchException {
        return super.searchList(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), type);
    }

    @Override
    public <T> ESDatas<T> searchList(String path, String templateName, Class<T> type) throws ElasticSearchException {
        return super.searchList(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null), type);
    }

    @Override
    public <T> T searchObject(String path, String templateName, Map params, Class<T> type) throws ElasticSearchException {
        return super.searchObject(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), type);
    }

    @Override
    public <T> T searchObject(String path, String templateName, Object params, Class<T> type) throws ElasticSearchException {
        return super.searchObject(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), type);
    }

    @Override
    public <T> T searchObject(String path, String templateName, Class<T> type) throws ElasticSearchException {
        return super.searchObject(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null), type);
    }

    @Override
    public RestResponse search(String path, String templateName, Map params, ESTypeReferences type) throws ElasticSearchException {
        return super.search(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), type);
    }

    @Override
    public RestResponse search(String path, String templateName, Object params, ESTypeReferences type) throws ElasticSearchException {
        return super.search(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), type);
    }

    @Override
    public RestResponse search(String path, String templateName, ESTypeReferences type) throws ElasticSearchException {
        return (RestResponse)this.client.executeRequest(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null), new ElasticSearchResponseHandler((ESTypeReferences<?, ?>)type));
    }

    @Override
    public String updateIndiceMapping(String action, String templateName) throws ElasticSearchException {
        return super.updateIndiceMapping(action, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null));
    }

    @Override
    public String createIndiceMapping(String indexName, String templateName) throws ElasticSearchException {
        return super.createIndiceMapping(indexName, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null));
    }

    @Override
    public String updateIndiceMapping(String action, String templateName, Object parameter) throws ElasticSearchException {
        return super.updateIndiceMapping(action, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, parameter));
    }

    @Override
    public String createIndiceMapping(String indexName, String templateName, Object parameter) throws ElasticSearchException {
        return super.createIndiceMapping(indexName, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, parameter));
    }

    @Override
    public String updateIndiceMapping(String action, String templateName, Map parameter) throws ElasticSearchException {
        return super.updateIndiceMapping(action, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, parameter));
    }

    @Override
    public String createIndiceMapping(String indexName, String templateName, Map parameter) throws ElasticSearchException {
        return super.createIndiceMapping(indexName, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, parameter));
    }

    @Override
    public Map<String, Object> searchMap(String path, String templateName, Map params) throws ElasticSearchException {
        return super.searchMap(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params));
    }

    @Override
    public Map<String, Object> searchMap(String path, String templateName, Object params) throws ElasticSearchException {
        return super.searchMap(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params));
    }

    @Override
    public Map<String, Object> searchMap(String path, String templateName) throws ElasticSearchException {
        return (Map)super.executeRequest(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null), new ESMapResponseHandler());
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Map params, Class<T> type, String aggs, String stats) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), type, aggs, stats);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Object params, Class<T> type, String aggs, String stats) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), type, aggs, stats);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Class<T> type, String aggs, String stats) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null), type, aggs, stats);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Map params, Class<T> type, String aggs, String stats, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), type, aggs, stats, aggBucketHandle);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Object params, Class<T> type, String aggs, String stats, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), type, aggs, stats, aggBucketHandle);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Class<T> type, String aggs, String stats, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null), type, aggs, stats, aggBucketHandle);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Map params, Class<T> type, String aggs) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), type, aggs);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Object params, Class<T> type, String aggs) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), type, aggs);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Class<T> type, String aggs) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null), type, aggs);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Map params, Class<T> type, String aggs, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), type, aggs, aggBucketHandle);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Object params, Class<T> type, String aggs, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), type, aggs, aggBucketHandle);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String templateName, Class<T> type, String aggs, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        return super.searchAgg(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null), type, aggs, aggBucketHandle);
    }

    @Override
    public String createTempate(String template, String templateName) throws ElasticSearchException {
        return super.createTempate(template, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null));
    }

    @Override
    public String createTempate(String template, String templateName, Object params) throws ElasticSearchException {
        return super.createTempate(template, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params));
    }

    @Override
    public String createTempate(String template, String templateName, Map params) throws ElasticSearchException {
        return super.createTempate(template, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, (Object)params));
    }

    @Override
    public TermRestResponse termSuggest(String path, String templateName, Object params) throws ElasticSearchException {
        return super.termSuggest(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params));
    }

    @Override
    public PhraseRestResponse phraseSuggest(String path, String templateName, Object params) throws ElasticSearchException {
        return super.phraseSuggest(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params));
    }

    @Override
    public TermRestResponse termSuggest(String path, String templateName, Map params) throws ElasticSearchException {
        return super.termSuggest(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params));
    }

    @Override
    public TermRestResponse termSuggest(String path, String templateName) throws ElasticSearchException {
        return super.termSuggest(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null));
    }

    @Override
    public PhraseRestResponse phraseSuggest(String path, String templateName, Map params) throws ElasticSearchException {
        return super.phraseSuggest(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params));
    }

    @Override
    public PhraseRestResponse phraseSuggest(String path, String templateName) throws ElasticSearchException {
        return super.phraseSuggest(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null));
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String templateName, Object params, Class<?> type) throws ElasticSearchException {
        return super.complateSuggest(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), type);
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String templateName, Class<?> type) throws ElasticSearchException {
        return super.complateSuggest(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null), type);
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String templateName, Map params, Class<?> type) throws ElasticSearchException {
        return super.complateSuggest(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), type);
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String templateName) throws ElasticSearchException {
        return super.complateSuggest(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null));
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String templateName, Map params) throws ElasticSearchException {
        return super.complateSuggest(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params));
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String templateName, Object params) throws ElasticSearchException {
        return super.complateSuggest(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params));
    }

    @Override
    public String updateByPath(String path, String templateName) throws ElasticSearchException {
        try {
            return this.client.executeHttp(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null), "post");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 1);
        }
    }

    @Override
    public String updateByPath(String path, String templateName, Map params) throws ElasticSearchException {
        try {
            return this.client.executeHttp(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), "post");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 1);
        }
    }

    @Override
    public String updateByPath(String path, String templateName, Object params) throws ElasticSearchException {
        try {
            return this.client.executeHttp(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), "post");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 1);
        }
    }

    @Override
    public String updateByQuery(String path, String templateName) throws ElasticSearchException {
        return this.client.executeHttp(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null), "post");
    }

    @Override
    public String updateByQuery(String path, String templateName, Map params) throws ElasticSearchException {
        return this.client.executeHttp(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), "post");
    }

    @Override
    public String updateByQuery(String path, String templateName, Object params) throws ElasticSearchException {
        return this.client.executeHttp(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), "post");
    }

    @Override
    public <T> List<T> mgetDocuments(String path, String templateName, Class<T> type) throws ElasticSearchException {
        return super.mgetDocuments(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, null), type);
    }

    @Override
    public <T> List<T> mgetDocuments(String path, String templateName, Object params, Class<T> type) throws ElasticSearchException {
        return super.mgetDocuments(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), type);
    }

    @Override
    public <T> List<T> mgetDocuments(String path, String templateName, Map params, Class<T> type) throws ElasticSearchException {
        return super.mgetDocuments(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, templateName, params), type);
    }

    @Override
    public ESInfo getESInfo(String templateName) {
        return this.configDSLUtil.getESInfo(templateName);
    }

    @Override
    public <T> ESDatas<T> scrollSliceParallel(String path, String dslTemplate, Map params, String scroll, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        return ExecuteRequestUtil.scrollSliceParallel(this, this.configDSLUtil, path, dslTemplate, params, scroll, type, scrollHandler);
    }

    @Override
    public <T> ESDatas<T> scroll(String path, String dslTemplate, String scroll, Map params, Class<T> type) throws ElasticSearchException {
        return super.scroll(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, dslTemplate, params), scroll, type);
    }

    @Override
    public <T> ESDatas<T> scroll(String path, String dslTemplate, String scroll, Map params, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        return super.scroll(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, dslTemplate, params), scroll, type, scrollHandler);
    }

    @Override
    public <T> ESDatas<T> scrollParallel(String path, String dslTemplate, String scroll, Map params, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        return super.scrollParallel(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, dslTemplate, params), scroll, type, scrollHandler);
    }

    @Override
    public <T> ESDatas<T> scroll(String path, String dslTemplate, String scroll, Object params, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        return super.scroll(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, dslTemplate, params), scroll, type, scrollHandler);
    }

    @Override
    public <T> ESDatas<T> scrollParallel(String path, String dslTemplate, String scroll, Object params, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        return super.scrollParallel(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, dslTemplate, params), scroll, type, scrollHandler);
    }

    @Override
    public <T> ESDatas<T> scroll(String path, String dslTemplate, String scroll, Object params, Class<T> type) throws ElasticSearchException {
        return super.scroll(path, ESTemplateHelper.evalTemplate(this.configDSLUtil, dslTemplate, params), scroll, type);
    }

    @Override
    public <T> ESDatas<T> scrollSlice(String path, String dslTemplate, Map params, String scroll, Class<T> type) throws ElasticSearchException {
        return this.scrollSlice(path, dslTemplate, params, scroll, type, null);
    }

    @Override
    public <T> ESDatas<T> scrollSliceParallel(String path, String dslTemplate, Map params, String scroll, Class<T> type) throws ElasticSearchException {
        return this.scrollSliceParallel(path, dslTemplate, params, scroll, type, null);
    }

    @Override
    public <T> ESDatas<T> scrollSlice(String path, String dslTemplate, Map params, String scroll, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        return ExecuteRequestUtil._scrollSlice(this.client, this.configDSLUtil, path, dslTemplate, params, scroll, type, scrollHandler);
    }

    @Override
    public String addDocumentsNew(String indexName, String addTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        return this.addDocuments(indexName, "_doc", addTemplate, beans, refreshOption);
    }

    @Override
    public String addDocumentsNew(String indexName, String addTemplate, List<?> beans) throws ElasticSearchException {
        return this.addDocuments(indexName, "_doc", addTemplate, beans);
    }

    @Override
    public String addDocumentNew(String indexName, String addTemplate, Object bean) throws ElasticSearchException {
        return this.addDocument(indexName, "_doc", addTemplate, bean);
    }

    @Override
    public String addDocumentNew(String indexName, String addTemplate, Object bean, String refreshOption) throws ElasticSearchException {
        return this.addDocument(indexName, "_doc", addTemplate, bean, refreshOption);
    }

    @Override
    public String updateDocumentsNew(String indexName, String updateTemplate, List<?> beans) throws ElasticSearchException {
        return this.updateDocuments(indexName, "_doc", updateTemplate, beans);
    }

    @Override
    public String updateDocumentsNew(String indexName, String updateTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        return this.updateDocuments(indexName, "_doc", updateTemplate, beans, refreshOption);
    }

    @Override
    public String addDateDocumentNew(String indexName, String addTemplate, Object bean) throws ElasticSearchException {
        return this.addDateDocument(indexName, "_doc", addTemplate, bean);
    }

    @Override
    public String addDateDocumentNew(String indexName, String addTemplate, Object bean, String refreshOption) throws ElasticSearchException {
        return this.addDateDocument(indexName, "_doc", addTemplate, bean, refreshOption);
    }

    @Override
    public String addDateDocumentsNew(String indexName, String addTemplate, List<?> beans) throws ElasticSearchException {
        return this.addDateDocuments(indexName, "_doc", addTemplate, beans);
    }

    @Override
    public String addDateDocumentsNew(String indexName, String addTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        return this.addDateDocuments(indexName, "_doc", addTemplate, beans, refreshOption);
    }

    @Override
    public String createScript(String scriptName, String scriptDslTemplate) {
        return this.client.executeHttp("_scripts/" + scriptName, ESTemplateHelper.evalTemplate(this.configDSLUtil, scriptDslTemplate, null), "post");
    }

    @Override
    public String createScript(String scriptName, String scriptDslTemplate, Map params) {
        return this.client.executeHttp("_scripts/" + scriptName, ESTemplateHelper.evalTemplate(this.configDSLUtil, scriptDslTemplate, params), "post");
    }

    @Override
    public String createScript(String scriptName, String scriptDslTemplate, Object params) {
        return this.client.executeHttp("_scripts/" + scriptName, ESTemplateHelper.evalTemplate(this.configDSLUtil, scriptDslTemplate, params), "post");
    }
}

