/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.ip2region;

import com.frameworkset.util.DaemonThread;
import com.frameworkset.util.ResourceInitial;
import java.io.File;
import java.io.IOException;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.geoip.IpInfo;
import org.frameworkset.spi.ip2region.DataBlock;
import org.frameworkset.spi.ip2region.DbConfig;
import org.frameworkset.spi.ip2region.DbSearcher;
import org.frameworkset.spi.ip2region.IP2RegionException;
import org.frameworkset.spi.ip2region.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IP2Region {
    private static final Logger logger = LoggerFactory.getLogger(IP2Region.class);
    private DbSearcher searcher;
    private DaemonThread daemonThread;
    private String ip2regionDatabase;
    private boolean enableBtree;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String ip2regionDatabase, boolean enableBtree) {
        if (this.searcher != null) {
            return;
        }
        this.enableBtree = enableBtree;
        IP2Region iP2Region = this;
        synchronized (iP2Region) {
            if (this.searcher == null) {
                try {
                    DbSearcher searcher;
                    this.ip2regionDatabase = ip2regionDatabase;
                    DbConfig config = new DbConfig();
                    this.searcher = searcher = new DbSearcher(config, ip2regionDatabase, enableBtree);
                }
                catch (Exception e) {
                    if (logger.isErrorEnabled()) {
                        logger.error(ip2regionDatabase, (Throwable)e);
                    }
                    throw new IP2RegionException("Init ip2regionDatabase failed:" + ip2regionDatabase, e);
                }
            }
            this.daemonThread = new DaemonThread(5000L, "ip2regionDatabase-Reload");
            this.daemonThread.addFile(new File(ip2regionDatabase), new ResourceInitial(){

                public void reinit() {
                    IP2Region.this._reinit();
                }
            });
            this.daemonThread.start();
            BaseApplicationContext.addShutdownHook((Runnable)new Runnable(){

                @Override
                public void run() {
                    IP2Region.this.daemonThread.stopped();
                    IP2Region.this.closeDb();
                }
            });
        }
    }

    private void closeDb() {
        if (this.searcher != null) {
            try {
                this.searcher.close();
            }
            catch (IOException e) {
                logger.debug("closeDb failed:", (Throwable)e);
            }
            this.searcher = null;
        }
    }

    private synchronized void _reinit() {
        block2: {
            final DbSearcher oldSearcher = this.searcher;
            try {
                DbSearcher searcher;
                DbConfig config = new DbConfig();
                this.searcher = searcher = new DbSearcher(config, this.ip2regionDatabase, this.enableBtree);
                Thread t = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block8: {
                            3 var1_1 = this;
                            synchronized (var1_1) {
                                try {
                                    3.sleep(60000L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                            if (oldSearcher != null) {
                                try {
                                    logger.info("Delay 60s and close old ip2region searcher database.");
                                    oldSearcher.close();
                                }
                                catch (Exception e) {
                                    if (!logger.isErrorEnabled()) break block8;
                                    logger.error("Reinit ip2region searcher database " + IP2Region.this.ip2regionDatabase + " failed:", (Throwable)e);
                                }
                            }
                        }
                    }
                };
                t.start();
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error("Reinit ip2region searcher database " + this.ip2regionDatabase + " failed:", (Throwable)e);
            }
        }
    }

    public void assertInit() {
        if (this.searcher == null) {
            throw new IP2RegionException("ip2region searcher database " + this.ip2regionDatabase + " not inited.");
        }
    }

    public IpInfo getIpInfo(String ip) {
        this.assertInit();
        if (!Util.isIpAddress(ip)) {
            return null;
        }
        try {
            DataBlock dataBlock = this.searcher.memorySearch(ip);
            if (dataBlock == null) {
                return null;
            }
            String region = dataBlock.getRegion();
            String[] infos = region.split("\\|");
            if (infos.length != 5) {
                return null;
            }
            IpInfo ipInfo = new IpInfo();
            ipInfo.setCountry(infos[0]);
            ipInfo.setArea(infos[1]);
            ipInfo.setRegion(infos[2]);
            ipInfo.setCity(infos[3]);
            ipInfo.setIsp(infos[4]);
            ipInfo.setCityId(dataBlock.getCityId() + "");
            ipInfo.setIp(ip);
            return ipInfo;
        }
        catch (IOException e) {
            logger.error(ip, (Throwable)e);
            return null;
        }
    }

    public IpInfo getAddressMapResult(String ip) {
        this.assertInit();
        if (!Util.isIpAddress(ip)) {
            return null;
        }
        try {
            DataBlock dataBlock = this.searcher.memorySearch(ip);
            if (dataBlock == null) {
                return null;
            }
            String region = dataBlock.getRegion();
            String[] infos = region.split("\\|");
            if (infos.length != 5) {
                return null;
            }
            IpInfo ipInfo = new IpInfo();
            ipInfo.setCountry(infos[0]);
            ipInfo.setArea(infos[1]);
            ipInfo.setRegion(infos[2]);
            ipInfo.setCity(infos[3]);
            ipInfo.setIsp(infos[4]);
            ipInfo.setCityId(dataBlock.getCityId() + "");
            ipInfo.setIp(ip);
            return ipInfo;
        }
        catch (IOException e) {
            logger.error(ip, (Throwable)e);
            return null;
        }
    }
}

