/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util.concurrent;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.frameworkset.util.concurrent.BlockedRejectedExecutionHandler;
import org.frameworkset.util.concurrent.WorkThread;

public class ThreadPoolFactory {
    public static ExecutorService buildThreadPool(String threadName, String rejectMessage, int threadCount, int threadQueue, long blockedWaitTimeout, int warnMultsRejects) {
        return ThreadPoolFactory.buildThreadPool(threadName, rejectMessage, threadCount, threadQueue, blockedWaitTimeout, warnMultsRejects, false, null);
    }

    public static ExecutorService buildThreadPool(String threadName, String rejectMessage, int threadCount, int threadQueue, long blockedWaitTimeout, int warnMultsRejects, boolean preStartAllCoreThreads, Boolean daemon) {
        return ThreadPoolFactory.buildThreadPool(threadName, rejectMessage, threadCount, threadQueue, 0L, blockedWaitTimeout, warnMultsRejects, preStartAllCoreThreads, daemon);
    }

    public static ExecutorService buildThreadPool(final String threadName, String rejectMessage, int threadCount, int threadQueue, long keepAliveTime, long blockedWaitTimeout, int warnMultsRejects, boolean preStartAllCoreThreads, final Boolean daemon) {
        ThreadPoolExecutor blockedExecutor = new ThreadPoolExecutor(threadCount, threadCount, keepAliveTime, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(threadQueue), new ThreadFactory(){
            private AtomicInteger threadCount = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                int num = this.threadCount.incrementAndGet();
                return new WorkThread(r, threadName, num, daemon);
            }
        }, new BlockedRejectedExecutionHandler(rejectMessage, blockedWaitTimeout, warnMultsRejects));
        if (preStartAllCoreThreads) {
            blockedExecutor.prestartAllCoreThreads();
        }
        return blockedExecutor;
    }

    public static ExecutorService buildThreadPool(String threadName, String rejectMessage, int threadCount, int threadQueue, long blockedWaitTimeout, int warnMultsRejects, boolean preStartAllCoreThreads) {
        return ThreadPoolFactory.buildThreadPool(threadName, rejectMessage, threadCount, threadQueue, blockedWaitTimeout, warnMultsRejects, preStartAllCoreThreads, null);
    }

    public static ExecutorService buildThreadPool(String threadName, String rejectMessage, int threadCount, int threadQueue, long blockedWaitTimeout) {
        return ThreadPoolFactory.buildThreadPool(threadName, rejectMessage, threadCount, threadQueue, blockedWaitTimeout, 1000);
    }

    public static void shutdownExecutor(ExecutorService executor) {
        executor.shutdown();
        do {
            try {
                executor.awaitTermination(10000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                break;
            }
        } while (!executor.isTerminated());
    }
}

