/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins.parser;

import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.plugins.parser.ISqlParser;
import com.baomidou.mybatisplus.plugins.parser.SqlInfo;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.reflection.MetaObject;

public abstract class AbstractJsqlParser
implements ISqlParser {
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public SqlInfo optimizeSql(MetaObject metaObject, String sql) {
        if (this.allowProcess(metaObject)) {
            try {
                Statement statement = CCJSqlParserUtil.parse((String)sql);
                this.logger.debug("Original SQL: " + sql);
                if (null != statement) {
                    return this.processParser(statement);
                }
            }
            catch (JSQLParserException e) {
                throw new MybatisPlusException("Failed to process, please exclude the tableName or statementId.\n Error SQL: " + sql, e);
            }
        }
        return null;
    }

    public abstract SqlInfo processParser(Statement var1);

    public boolean allowProcess(MetaObject metaObject) {
        return true;
    }
}

