/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.mapper;

import com.baomidou.mybatisplus.entity.TableInfo;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.mapper.Condition;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.toolkit.MapUtils;
import com.baomidou.mybatisplus.toolkit.TableInfoHelper;
import java.util.List;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionUtils;

public class SqlHelper {
    private static final Log logger = LogFactory.getLog(SqlHelper.class);

    public static SqlSession sqlSessionBatch(Class<?> clazz) {
        return SqlSessionUtils.getSqlSession((SqlSessionFactory)GlobalConfigUtils.currentSessionFactory(clazz), (ExecutorType)ExecutorType.BATCH, null);
    }

    private static SqlSession getSqlSession(Class<?> clazz) {
        SqlSessionFactory sqlSessionFactory = GlobalConfigUtils.currentSessionFactory(clazz);
        return SqlSessionUtils.getSqlSession((SqlSessionFactory)sqlSessionFactory);
    }

    public static SqlSession sqlSession(Class<?> clazz) {
        return SqlHelper.getSqlSession(clazz);
    }

    public static TableInfo table(Class<?> clazz) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(clazz);
        if (null == tableInfo) {
            throw new MybatisPlusException("Error: Cannot execute table Method, ClassGenricType not found .");
        }
        return tableInfo;
    }

    public static boolean retBool(Integer result) {
        return null != result && result >= 1;
    }

    public static boolean delBool(Integer result) {
        return null != result && result >= 0;
    }

    public static int retCount(Integer result) {
        return null == result ? 0 : result;
    }

    public static <E> E getObject(List<E> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            int size = list.size();
            if (size > 1) {
                logger.warn(String.format("Warn: execute Method There are  %s results.", size));
            }
            return list.get(0);
        }
        return null;
    }

    public static Wrapper<?> fillWrapper(Page<?> page, Wrapper<?> wrapper) {
        if (null == page) {
            return wrapper;
        }
        if (SqlHelper.isEmptyOfWrapper(wrapper)) {
            wrapper = Condition.create();
        }
        if (page.isOpenSort() && page.isSearchCount()) {
            wrapper.orderAsc(page.getAscs());
            wrapper.orderDesc(page.getDescs());
        }
        if (MapUtils.isNotEmpty(page.getCondition())) {
            wrapper.allEq(page.getCondition());
        }
        return wrapper;
    }

    public static boolean isEmptyOfWrapper(Wrapper<?> wrapper) {
        return null == wrapper || Condition.EMPTY == wrapper;
    }

    public static boolean isNotEmptyOfWrapper(Wrapper<?> wrapper) {
        return !SqlHelper.isEmptyOfWrapper(wrapper);
    }
}

