/*
 * Decompiled with CFR 0.152.
 */
package mybatis.mate.autoconfigure;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import mybatis.mate.O000000o.O000000o;
import mybatis.mate.O00000oO.O0000o0o;
import mybatis.mate.config.CertProperties;
import mybatis.mate.config.DataSourceProperty;
import mybatis.mate.config.ShardingProperties;
import mybatis.mate.sharding.O00000Oo;
import mybatis.mate.sharding.ShardingDatasource;
import mybatis.mate.strategy.IShardingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Lazy
@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@ConditionalOnProperty(prefix="mybatis-mate.sharding", name={"primary"})
public class O00000o0 {
    private static final Logger log = LoggerFactory.getLogger(O00000o0.class);
    @Resource
    private ShardingProperties shardingProperties;
    @Resource
    private CertProperties certProperties;
    private IShardingStrategy shardingStrategy;

    @Autowired(required=false)
    public void setShardingStrategy(IShardingStrategy iShardingStrategy) {
        this.shardingStrategy = iShardingStrategy;
        O0000o0o.O0000ooo(this.certProperties.getGrant());
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean
    public ShardingDatasource shardingDatasource() {
        Map<String, List<DataSourceProperty>> map = this.shardingProperties.getDatasource();
        O000000o.O000000o(O0000o0o.O000000o(map), "datasource can't be empty!");
        O000000o.O000000o(O0000o0o.O00000o(this.shardingProperties.getPrimary()), "primary datasource can't be empty!");
        HashMap hashMap = new HashMap();
        map.forEach((string, list) -> list.forEach(dataSourceProperty -> {
            O000000o.O000000o(O0000o0o.O00000o(dataSourceProperty.getKey()), "datasource key can't be empty!");
            String string2 = string + dataSourceProperty.getKey();
            O000000o.O000000o(null != hashMap.get(string2), "datasource key repetition is not allowed!");
            hashMap.put(string2, this.shardingProperties.toDataSource((DataSourceProperty)dataSourceProperty));
        }));
        if (null != this.shardingStrategy) {
            this.shardingProperties.setDbShardingStrategy(this.shardingStrategy);
        }
        mybatis.mate.sharding.O00000o0.O000000o(this.shardingProperties);
        ShardingDatasource shardingDatasource = new ShardingDatasource();
        shardingDatasource.setTargetDataSources(hashMap);
        return shardingDatasource;
    }

    @Bean
    @ConditionalOnMissingBean
    public PlatformTransactionManager transactionManager(@Autowired ShardingDatasource shardingDatasource) {
        return new DataSourceTransactionManager((DataSource)((Object)shardingDatasource));
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="mybatis-mate.sharding", name={"health"}, havingValue="true")
    public O00000Oo shardingHealthIndicator(@Autowired ShardingDatasource shardingDatasource) {
        log.debug("Datasource Health check started.");
        return new O00000Oo(shardingDatasource);
    }
}

