/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.creator;

import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.hikari.HikariCpConfig;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.springframework.util.StringUtils;

public class HikariDataSourceCreator
implements DataSourceCreator {
    private static Boolean hikariExists = false;
    private static Method configCopyMethod = null;
    private HikariCpConfig hikariCpConfig;

    private static void fetchMethod() {
        try {
            configCopyMethod = HikariConfig.class.getMethod("copyState", HikariConfig.class);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                configCopyMethod = HikariConfig.class.getMethod("copyStateTo", HikariConfig.class);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new RuntimeException("HikariConfig does not has 'copyState' or 'copyStateTo' method!");
            }
        }
    }

    @Override
    public DataSource createDataSource(DataSourceProperty dataSourceProperty) {
        HikariConfig config = dataSourceProperty.getHikari().toHikariConfig(this.hikariCpConfig);
        config.setUsername(dataSourceProperty.getUsername());
        config.setPassword(dataSourceProperty.getPassword());
        config.setJdbcUrl(dataSourceProperty.getUrl());
        config.setPoolName(dataSourceProperty.getPoolName());
        String driverClassName = dataSourceProperty.getDriverClassName();
        if (!StringUtils.isEmpty((Object)driverClassName)) {
            config.setDriverClassName(driverClassName);
        }
        if (!dataSourceProperty.getLazy().booleanValue()) {
            return new HikariDataSource(config);
        }
        config.validate();
        HikariDataSource dataSource = new HikariDataSource();
        try {
            configCopyMethod.invoke((Object)config, dataSource);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("HikariConfig failed to copy to HikariDataSource", e);
        }
        return dataSource;
    }

    @Override
    public boolean support(DataSourceProperty dataSourceProperty) {
        Class<? extends DataSource> type = dataSourceProperty.getType();
        return type == null && hikariExists != false || type != null && "com.zaxxer.hikari.HikariDataSource".equals(type.getName());
    }

    public HikariCpConfig getHikariCpConfig() {
        return this.hikariCpConfig;
    }

    public void setHikariCpConfig(HikariCpConfig hikariCpConfig) {
        this.hikariCpConfig = hikariCpConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HikariDataSourceCreator)) {
            return false;
        }
        HikariDataSourceCreator other = (HikariDataSourceCreator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HikariCpConfig this$hikariCpConfig = this.getHikariCpConfig();
        HikariCpConfig other$hikariCpConfig = other.getHikariCpConfig();
        return !(this$hikariCpConfig == null ? other$hikariCpConfig != null : !((Object)this$hikariCpConfig).equals(other$hikariCpConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HikariDataSourceCreator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HikariCpConfig $hikariCpConfig = this.getHikariCpConfig();
        result = result * 59 + ($hikariCpConfig == null ? 43 : ((Object)$hikariCpConfig).hashCode());
        return result;
    }

    public String toString() {
        return "HikariDataSourceCreator(hikariCpConfig=" + this.getHikariCpConfig() + ")";
    }

    public HikariDataSourceCreator(HikariCpConfig hikariCpConfig) {
        this.hikariCpConfig = hikariCpConfig;
    }

    static {
        try {
            Class.forName("com.zaxxer.hikari.HikariDataSource");
            hikariExists = true;
            HikariDataSourceCreator.fetchMethod();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

