/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.qianfan.util.http;

import com.baidubce.qianfan.util.Json;
import com.baidubce.qianfan.util.TypeRef;
import com.baidubce.qianfan.util.http.HttpClient;
import com.baidubce.qianfan.util.http.HttpResponse;
import com.baidubce.qianfan.util.http.SSEIterator;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class HttpRequest {
    private String url;
    private String method;
    private HttpEntity body;
    private Map<String, String> headers = new LinkedHashMap<String, String>();

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public HttpEntity getBody() {
        return this.body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public HttpRequest url(String url) {
        this.url = url;
        return this;
    }

    public HttpRequest method(String method) {
        this.method = method;
        return this;
    }

    public HttpRequest headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public HttpRequest get(String url) {
        this.method = "GET";
        this.url = url;
        return this;
    }

    public HttpRequest post(String url) {
        this.method = "POST";
        this.url = url;
        return this;
    }

    public HttpRequest put(String url) {
        this.method = "PUT";
        this.url = url;
        return this;
    }

    public HttpRequest delete(String url) {
        this.method = "DELETE";
        this.url = url;
        return this;
    }

    public <T> HttpRequest body(T body) {
        this.body = new StringEntity(Json.serialize(body), ContentType.APPLICATION_JSON);
        return this;
    }

    public HttpRequest body(byte[] body) {
        this.body = new ByteArrayEntity(body, ContentType.DEFAULT_BINARY);
        return this;
    }

    public HttpRequest addHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public <T> HttpResponse<T> executeJson(TypeRef<T> typeRef) throws IOException {
        return HttpClient.executeJson(this.toClassicHttpRequest(), typeRef);
    }

    public <T> HttpResponse<T> executeJson(Type type) throws IOException {
        return HttpClient.executeJson(this.toClassicHttpRequest(), type);
    }

    public HttpResponse<String> executeString() throws IOException {
        return HttpClient.executeString(this.toClassicHttpRequest());
    }

    public HttpResponse<SSEIterator> executeSSE() throws IOException {
        return HttpClient.executeSSE(this.toClassicHttpRequest());
    }

    public HttpResponse<byte[]> execute() throws IOException {
        return HttpClient.execute(this.toClassicHttpRequest());
    }

    private ClassicHttpRequest toClassicHttpRequest() {
        HttpUriRequestBase request = new HttpUriRequestBase(this.method, URI.create(this.url));
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            request.setHeader(entry.getKey(), (Object)entry.getValue());
        }
        if (this.body != null) {
            request.setEntity(this.body);
        }
        return request;
    }
}

