/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.qianfan.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TokenBucketLimiter {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final ScheduledExecutorService scheduler;
    private int maxTokens;
    private int availableTokens;

    public TokenBucketLimiter(int maxTokens, int refillPeriod) {
        if (maxTokens <= 0) {
            throw new IllegalArgumentException("maxTokens should be positive");
        }
        if (refillPeriod <= 0) {
            throw new IllegalArgumentException("refillPeriod should be positive");
        }
        this.maxTokens = maxTokens;
        this.availableTokens = maxTokens;
        this.scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        });
        this.scheduler.scheduleAtFixedRate(this::refill, refillPeriod, refillPeriod, TimeUnit.SECONDS);
    }

    public void acquire() throws InterruptedException {
        this.acquire(1);
    }

    public void acquire(int tokens) throws InterruptedException {
        if (tokens <= 0) {
            throw new IllegalArgumentException("tokens should be positive");
        }
        if (tokens > this.maxTokens) {
            throw new IllegalArgumentException("tokens should be less than or equal to maxTokens");
        }
        this.lock.lock();
        try {
            while (tokens > this.availableTokens) {
                this.condition.await();
            }
            this.availableTokens -= tokens;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void updateMaxTokens(int maxTokens, boolean resetAvailableTokens) {
        if (maxTokens <= 0) {
            throw new IllegalArgumentException("maxTokens should be positive");
        }
        this.lock.lock();
        try {
            this.maxTokens = maxTokens;
            if (resetAvailableTokens) {
                this.refill();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void refill() {
        this.lock.lock();
        try {
            this.availableTokens = this.maxTokens;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

