/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.qianfan.core.builder;

import com.baidubce.qianfan.Qianfan;
import com.baidubce.qianfan.core.StreamIterator;
import com.baidubce.qianfan.core.builder.BaseBuilder;
import com.baidubce.qianfan.model.plugin.PluginHistory;
import com.baidubce.qianfan.model.plugin.PluginLLM;
import com.baidubce.qianfan.model.plugin.PluginRequest;
import com.baidubce.qianfan.model.plugin.PluginResponse;
import java.util.List;
import java.util.Map;

public class PluginBuilder
extends BaseBuilder<PluginBuilder> {
    private String query;
    private List<String> plugins;
    private String fileurl;
    private PluginLLM llm;
    private Map<String, String> inputVariables;
    private List<PluginHistory> history;
    private Boolean verbose;

    public PluginBuilder() {
    }

    public PluginBuilder(Qianfan qianfan) {
        super(qianfan);
    }

    public PluginBuilder query(String query) {
        this.query = query;
        return this;
    }

    public PluginBuilder plugins(List<String> plugins) {
        this.plugins = plugins;
        return this;
    }

    public PluginBuilder fileurl(String fileurl) {
        this.fileurl = fileurl;
        return this;
    }

    public PluginBuilder llm(PluginLLM llm) {
        this.llm = llm;
        return this;
    }

    public PluginBuilder inputVariables(Map<String, String> inputVariables) {
        this.inputVariables = inputVariables;
        return this;
    }

    public PluginBuilder history(List<PluginHistory> history) {
        this.history = history;
        return this;
    }

    public PluginBuilder verbose(Boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public PluginRequest build() {
        return (PluginRequest)((PluginRequest)((PluginRequest)new PluginRequest().setQuery(this.query).setPlugins(this.plugins).setFileurl(this.fileurl).setLlm(this.llm).setInputVariables(this.inputVariables).setHistory(this.history).setVerbose(this.verbose).setEndpoint(super.getEndpoint())).setUserId(super.getUserId())).setExtraParameters(super.getExtraParameters());
    }

    public PluginResponse execute() {
        return super.getQianfan().plugin(this.build());
    }

    public StreamIterator<PluginResponse> executeStream() {
        return super.getQianfan().pluginStream(this.build());
    }
}

