/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.qianfan.core.builder;

import com.baidubce.qianfan.Qianfan;
import com.baidubce.qianfan.model.console.ConsoleRequest;
import com.baidubce.qianfan.model.console.ConsoleResponse;
import com.baidubce.qianfan.model.exception.ValidationException;
import com.baidubce.qianfan.util.TypeRef;
import java.lang.reflect.Type;
import java.util.Map;

public class ConsoleBuilder {
    private Qianfan qianfan;
    private String route;
    private String action;
    private Object body;

    public ConsoleBuilder() {
    }

    public ConsoleBuilder(Qianfan qianfan) {
        this.qianfan = qianfan;
    }

    public ConsoleBuilder route(String route) {
        this.route = route;
        return this;
    }

    public ConsoleBuilder action(String action) {
        this.action = action;
        return this;
    }

    public ConsoleBuilder body(Object body) {
        this.body = body;
        return this;
    }

    public ConsoleRequest build() {
        return new ConsoleRequest().setRoute(this.route).setAction(this.action).setBody(this.body);
    }

    public ConsoleResponse<Map<String, Object>> execute() {
        return this.executeWithCheck(new TypeRef<Map<String, Object>>(){}.getType());
    }

    public <T> ConsoleResponse<T> execute(TypeRef<T> typeRef) {
        return this.executeWithCheck(typeRef.getType());
    }

    public <T> ConsoleResponse<T> execute(Class<T> clazz) {
        return this.executeWithCheck(clazz);
    }

    public <T> ConsoleResponse<T> execute(Type type) {
        return this.executeWithCheck(type);
    }

    private <T> ConsoleResponse<T> executeWithCheck(Type type) {
        if (this.qianfan == null) {
            throw new ValidationException("Qianfan client is not set. please create builder from Qianfan client, or use build() instead of execute() to get Request and send it by yourself.");
        }
        return this.qianfan.consoleRequest(this.build(), type);
    }
}

