/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.qianfan.core;

import com.baidubce.qianfan.model.BaseResponse;
import com.baidubce.qianfan.model.plugin.PluginMetaInfo;
import com.baidubce.qianfan.model.plugin.PluginResponse;
import com.baidubce.qianfan.util.Json;
import com.baidubce.qianfan.util.http.SSEIterator;
import java.io.Closeable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class StreamIterator<T extends BaseResponse<T>>
implements Iterator<T>,
Closeable {
    private final Map<String, String> headers;
    private final SSEIterator sseIterator;
    private final Class<T> responseClass;
    private PluginMetaInfo metaInfo;

    public StreamIterator(Map<String, String> headers, SSEIterator sseIterator, Class<T> responseClass) {
        this.headers = headers;
        this.sseIterator = sseIterator;
        this.responseClass = responseClass;
    }

    @Override
    public boolean hasNext() {
        return this.sseIterator.hasNext();
    }

    @Override
    public T next() {
        String event = this.sseIterator.next().replaceFirst("data: ", "");
        this.sseIterator.next();
        BaseResponse response = (BaseResponse)Json.deserialize(event, this.responseClass);
        if (this.responseClass.equals(PluginResponse.class)) {
            if (this.metaInfo == null) {
                this.metaInfo = Json.deserialize(event, PluginMetaInfo.class);
            }
            ((PluginResponse)response).setMetaInfo(this.metaInfo);
        }
        return (T)response.setHeaders(this.headers);
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        try {
            while (this.hasNext()) {
                action.accept(this.next());
            }
        }
        finally {
            this.sseIterator.silentlyClose();
        }
    }

    @Override
    public void close() {
        this.sseIterator.silentlyClose();
    }
}

