package com.baidubce.services.vpn.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.util.List;

/**
 * The request for creating a newly vpnConn.
 */
@Data
public class CreateVpnConnRequest extends AbstractBceRequest {

    /*********************** Required **************************/
    /**vpn id*/
    @JsonIgnore
    private String vpnId;
    /** Shared key, 8~17 characters, English, numbers and symbols must exist at the same time, and the symbols are limited to! @#$%^*() */
    private String secretKey;
    /** Local network cidr List */
    private List<String> localSubnets;
    /** Peer VPN Gateway public network IP*/
    private String remoteIp;
    /** Peer network cidr List */
    private List<String> remoteSubnets;
    /**VPN Tunnel name, uppercase and lowercase letters, numbers and -_/. special characters, must start with a letter, length 1-65 */
    private String vpnConnName;
    /**IKE config*/
    private IkeConfig ikeConfig;
    /**IPSec config*/
    private IpsecConfig ipsecConfig;

    /************************ Not required **********************/
    /** description */
    private String description;
    /**
     * An ASCII string whose length is less than 64.
     *
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     *     BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;

    @Override
    public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
