/*
 * Copyright (C) 2023 Baidu, Inc. All Rights Reserved.
 */
package com.baidubce.services.route.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;

import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
public class UpdateRouteRuleRequest extends AbstractBceRequest {
    /**
     * the API version number
     */
    private String version;

    /**
     * An ASCII string whose length is less than 64.
     * <p>
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     */
    private String clientToken;

    private String routeRuleId;
    private String sourceAddress;
    private String destinationAddress;
    private String nexthopId;
    private String description;

    @Override
    public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
