/*
 * Copyright 2017 Baidu, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.iotdm.model.v3.rules;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;

import java.util.List;

public class DeviceRuleRequest extends AbstractBceRequest {
    /**
     * Name of Rule .
     */
    private String name;
    /**
     * List of Device Rule Source .
     */
    private List<DeviceRuleSource> sources;
    /**
     * List of Device Rule Desctination .
     */
    private List<DeviceRuleDestination> destinations;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DeviceRuleRequest withName(String name) {
        setName(name);
        return this;
    }

    public List<DeviceRuleSource> getSources() {
        return sources;
    }

    public void setSources(List<DeviceRuleSource> sources) {
        this.sources = sources;
    }

    public DeviceRuleRequest withSources(List<DeviceRuleSource> sources) {
        setSources(sources);
        return this;
    }

    public List<DeviceRuleDestination> getDestinations() {
        return destinations;
    }

    public void setDestinations(List<DeviceRuleDestination> destinations) {
        this.destinations = destinations;
    }

    public DeviceRuleRequest withDestinations(List<DeviceRuleDestination> destinations) {
        setDestinations(destinations);
        return this;
    }

    /**
     * Configure request credential for the request.
     *
     * @param credentials a valid instance of BceCredentials.
     * @return DeviceRuleRequest with credentials.
     */
    @Override
    public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
