package com.baidubce.services.etgateway.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

@Getter
@Setter
@Accessors(chain = true)
public class CreateEtGatewayHealthCheckRequest extends AbstractBceRequest {

    /**
     * An ASCII string whose length is less than 64.
     * <p>
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     * BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;
    private String etGatewayId;

    /**
     * The source IP for health check.
     */
    private String healthCheckSourceIp;

    /**
     * The method of health check.
     */
    private String healthCheckType;

    /**
     * The port for health check.
     */
    private Integer healthCheckPort;

    /**
     * The interval for health check
     */
    private Integer healthCheckInterval;

    /**
     * The threshold for health check
     */
    private Integer healthThreshold;

    /**
     * The threshold for unhealthy status in health check
     */
    private Integer unhealthThreshold;

    /**
     * Whether to automatically generate probing routes. Enabled by default. If you want to disable, choose false.
     */
    private Boolean autoGenerateRouteRule;


    @Override
    public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
