package com.baidubce.services.et.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;

import lombok.ToString;

/**
 * The request for applying for a newly ET.
 */
@ToString
public class ApplyForEtRequest extends AbstractBceRequest {
    /**
     * An ASCII string whose length is less than 64.
     * <p>
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     * BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;

    /**
     * The name of ET that will be created.
     */
    private String name;

    /**
     * The option param to describe the ET
     */
    private String description;

    /**
     * Operator. Its value range is ISP_CMCC/ISP_CUCC/ISP_CYC/ISP_OTHER, which respectively correspond to China
     * Mobile/China Unicom/China Telecom/Others in China
     */
    private String isp;

    /**
     * The physical port specification, of which the value range is 1G/10G/100G
     */
    private String intfType;

    /**
     * The line type for the Baidu AI Cloud internal users is BAIDU, and the line type for the Baidu AI Cloud
     * external users is SINGLE
     */
    private String apType;

    /**
     * Access point. Its value range is BB/BJYZ/M3A/M3B/M2A/M2B/HKG03/WHGG/SHWGQ/BDBL, which respectively correspond
     * to Beijing Haidian access point/Beijing Yizhuang access point/Guangzhou Nansha access point/Shenzhen access
     * point/Nanjing access point/Suzhou access point/Hong Kong access point/Wuhan Optics Valley access
     * point/Shanghai access point/Baoding access point
     */
    private String apAddr;

    /**
     * End-to-end address.
     */
    private String userIdc;

    public String getClientToken() {
        return clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIsp() {
        return isp;
    }

    public void setIsp(String isp) {
        this.isp = isp;
    }

    public String getIntfType() {
        return intfType;
    }

    public void setIntfType(String intfType) {
        this.intfType = intfType;
    }

    public String getApType() {
        return apType;
    }

    public void setApType(String apType) {
        this.apType = apType;
    }

    public String getApAddr() {
        return apAddr;
    }

    public void setApAddr(String apAddr) {
        this.apAddr = apAddr;
    }

    public String getUserIdc() {
        return userIdc;
    }

    public void setUserIdc(String userIdc) {
        this.userIdc = userIdc;
    }

    @Override
    public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
