/*
 * Copyright (c) 2020 Baidu.com, Inc. All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.bec.model.vm.service;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.bec.model.purchase.DeploymentInstance;
import com.baidubce.services.bec.model.vm.KeyConfig;
import com.baidubce.services.bec.model.vm.NetworkConfig.Networks;
import com.baidubce.services.bec.model.vm.SystemVolumeConfig;
import com.baidubce.services.bec.model.vm.VolumeConfig;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Builder;
import lombok.Data;

import java.util.List;

/**
 * The request for creating a newly vm service.
 */
@Data
@Builder
public class CreateBecVmServiceRequest extends AbstractBceRequest {


    /**
     * The name of the service.
     */
    private String serviceName;

    /**
     * The id of the service.
     */
    private String serviceId;

    /**
     * The name of the vm.
     */
    private String vmName;

    /**
     * TemplateId.
     */
    private String templateId;

    /**
     * The payment method of the service.
     */
    private String paymentMethod;

    /**
     * The need for public IP.
     */
    private boolean needPublicIp;

    /**
     * Disable Intra net.
     */
    private boolean disableIntranet;

    /**
     * Disable Cloud Init.
     */
    private boolean disableCloudInit;

    /**
     * The bandwidth of the service.
     */
    private int bandwidth;

    /**
     * List of deployment instances.
     */
    private List<DeploymentInstance> deployInstances;

    /**
     * The cpu of the service.
     */
    private int cpu;

    /**
     * The memory of the service.
     */
    private int memory;

    /**
     * The imageId of the service.
     */
    private String imageId;

    /**
     * The imageType of the service.
     */
    private String imageType;

    /**
     * Data disk configuration list.
     */
    private List<VolumeConfig> dataVolumeList;

    /**
     * System disk configuration information.
     */
    private SystemVolumeConfig systemVolume;

    /**
     * The password of the vm service.
     */
    private String adminPass;

    /**
     * The keyConfig of the vm service.
     */
    private KeyConfig keyConfig;

    /**
     * The spec of the vm service.
     */
    private String spec;

    /**
     * The needIpv6PublicIp of the vm service.
     */
    private boolean needIpv6PublicIp;

    /**
     * The hostname of the vm service.
     */
    private String hostname;

    /**
     * The deploysetIdList of the vm service.
     */
    private List<String> deploysetIdList;

    /**
     * The networksList of the vm.
     */
    private List<Networks> networksList;

    /**
     * The securityGroupIds of the vm.
     */
    private List<String> securityGroupIds;

    /**
     * An ASCII string whose length is less than 64.
     * <p>
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BEC/API.html">
     * BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;

    /**
     * Configure request credential for the request.
     *
     * @param credentials a valid instance of BceCredentials.
     * @return GetInstanceRequest with credentials.
     */
    @Override
    public CreateBecVmServiceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
