package com.baidubce.services.bcm.model.dashboard;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;


@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class DashboardDimensionsRequest extends AbstractBceRequest {
    private String userId;
    private String service;
    private String region;
    private String showId;
    private String dimensions;
    private String metricName;

    @Override
    public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
