/*
 * Copyright 2020 Baidu, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.bcc.model.asp;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;

import java.util.List;

/**
 * The request for updating autoSnapshotPolicy.
 */
public class UpdateAspRequest extends AbstractBceRequest {
    /**
     * An ASCII string whose length is less than 64.
     * The request will be idempotent if client token is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     *     BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;

    /**
     * name of the asp
     */
    private String name;

    /**
     * Specifies the time point of creating an automatic snapshot .
     * The smallest unit is the hour.
     * There are 24 time points from 00:00 to 23:00.
     * The number of parameters is 0 to 23.
     * For example, "1" represents the time point at 01:00.
     * Multiple time points can be selected.
     * The parameter is a Json Array:["0", "1",... "23"], at most 24 time points.
     */
    private List<String> timePoints;

    /**
     * Specify a duplicate date for the automatic snapshot.
     * Choose the date from Monday to Sunday when you need to create snapshots,
     * with a number of parameters ranging from 1 to 7,
     * such as: "1" for Monday. Multiple dates are allowed.
     * The parameter is a Json Array:["1", "2"... "7"].
     */
    private List<String> repeatWeekdays;

    /**
     * Specify the retention time of the automatic snapshot in days.
     * -1: Permanent preservation .
     * 1-65536: specified number of days.
     */
    private String retentionDays;

    /**
     * The id of asp.
     */
    private String aspId;

    public String getClientToken() {
        return clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getTimePoints() {
        return timePoints;
    }

    public void setTimePoints(List<String> timePoints) {
        this.timePoints = timePoints;
    }

    public List<String> getRepeatWeekdays() {
        return repeatWeekdays;
    }

    public void setRepeatWeekdays(List<String> repeatWeekdays) {
        this.repeatWeekdays = repeatWeekdays;
    }

    public String getRetentionDays() {
        return retentionDays;
    }

    public void setRetentionDays(String retentionDays) {
        this.retentionDays = retentionDays;
    }

    public String getAspId() {
        return aspId;
    }

    public void setAspId(String aspId) {
        this.aspId = aspId;
    }

    @Override
    public String toString() {
        return "UpdateAspRequest{" +
                "clientToken='" + clientToken + '\'' +
                ", name='" + name + '\'' +
                ", timePoints=" + timePoints +
                ", repeatWeekdays=" + repeatWeekdays +
                ", retentionDays='" + retentionDays + '\'' +
                '}';
    }

    @Override
    public UpdateAspRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
