/*
 * Copyright (C) 2023 Baidu, Inc. All Rights Reserved.
 */
package com.baidubce.examples.blb.blb;

import com.baidubce.BceClientException;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.blb.BlbClient;
import com.baidubce.services.blb.BlbClientConfiguration;
import com.baidubce.services.blb.model.UpdateLoadBalancerAclRequest;

public class ExampleUpdateLoadBalancerAcl {
    public static void main(String[] args) {
        String ak = "Your Ak";
        String sk = "Your Sk";
        String endpoint = "blb.bj.baidubce.com"; // 请求的服务region对应的域名

        BlbClientConfiguration config = new BlbClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ak, sk));
        config.setEndpoint(endpoint);
        BlbClient blbClient = new BlbClient(config); // 初始化BlbClient

        UpdateLoadBalancerAclRequest updateLoadBalancerAclRequest = new UpdateLoadBalancerAclRequest();
        updateLoadBalancerAclRequest.setBlbId("lb-d20d573f"); // 待更新的LoadBalancer的ID
        updateLoadBalancerAclRequest.setSupportAcl(true); // 是否支持ACL

        try {
            blbClient.updateLoadBalancerAcl(updateLoadBalancerAclRequest);
        } catch (BceClientException e) {
            System.out.println(e.getMessage());
        }
    }
}
