/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf.utils;

import com.baidu.bjf.remoting.protobuf.FieldType;
import com.baidu.bjf.remoting.protobuf.ProtobufProxy;
import com.baidu.bjf.remoting.protobuf.annotation.EnableZigZap;
import com.baidu.bjf.remoting.protobuf.annotation.Ignore;
import com.baidu.bjf.remoting.protobuf.annotation.Packed;
import com.baidu.bjf.remoting.protobuf.annotation.Protobuf;
import com.baidu.bjf.remoting.protobuf.annotation.ProtobufClass;
import com.baidu.bjf.remoting.protobuf.utils.FieldInfo;
import com.baidu.bjf.remoting.protobuf.utils.FieldUtils;
import com.baidu.bjf.remoting.protobuf.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufProxyUtils {
    public static final Map<Class<?>, FieldType> TYPE_MAPPING;
    private static final Logger LOGGER;
    public static final List<String> FIELD_FILTER_STARTS;

    public static boolean isScalarType(Class<?> cls) {
        return TYPE_MAPPING.containsKey(cls);
    }

    public static List<FieldInfo> fetchFieldInfos(Class cls, boolean ignoreNoAnnotation) {
        ProtobufClass annotation = cls.getAnnotation(ProtobufClass.class);
        EnableZigZap zipZap = cls.getAnnotation(EnableZigZap.class);
        boolean isZipZap = false;
        if (zipZap != null) {
            isZipZap = true;
        }
        boolean typeDefined = false;
        List<Field> fields = null;
        if (annotation == null) {
            fields = FieldUtils.findMatchedFields(cls, Protobuf.class);
            if (fields.isEmpty() && ignoreNoAnnotation) {
                throw new IllegalArgumentException("Invalid class [" + cls.getName() + "] no field use annotation @" + Protobuf.class.getName() + " at class " + cls.getName());
            }
        } else {
            typeDefined = true;
            fields = FieldUtils.findMatchedFields(cls, null);
        }
        List<FieldInfo> fieldInfos = ProtobufProxyUtils.processDefaultValue(fields, typeDefined, isZipZap);
        return fieldInfos;
    }

    public static List<FieldInfo> processDefaultValue(List<Field> fields, boolean ignoreNoAnnotation, boolean isZipZap) {
        if (fields == null) {
            return null;
        }
        ArrayList<FieldInfo> ret = new ArrayList<FieldInfo>(fields.size());
        String[] filterFields = null;
        if (FIELD_FILTER_STARTS != null) {
            filterFields = FIELD_FILTER_STARTS.toArray(new String[FIELD_FILTER_STARTS.size()]);
        }
        int maxOrder = 0;
        ArrayList<FieldInfo> unorderFields = new ArrayList<FieldInfo>(fields.size());
        HashSet<Integer> orders = new HashSet<Integer>();
        for (Field field : fields) {
            boolean filtered;
            Ignore ignore = field.getAnnotation(Ignore.class);
            if (ignore != null) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Field name '{}' marked @Ignore annotation will be ignored.", (Object)field.getName());
                continue;
            }
            String fName = field.getName();
            if (filterFields != null && (filtered = StringUtils.startsWithAny(fName, filterFields))) {
                LOGGER.warn("Field '" + fName + "' is filtered due to matched filter list. " + filterFields);
                continue;
            }
            Protobuf protobuf = field.getAnnotation(Protobuf.class);
            if (protobuf == null && !ignoreNoAnnotation) {
                throw new RuntimeException("Field '" + fName + "' has no @Protobuf annotation");
            }
            String simpleName = field.getType().getName();
            if (simpleName.startsWith("[") && !simpleName.equals(byte[].class.getName()) && !simpleName.equals(Byte[].class.getName())) {
                throw new RuntimeException("Array type of field '" + fName + "' on class '" + field.getDeclaringClass().getName() + "' is not support,  please use List instead.");
            }
            FieldInfo fieldInfo = new FieldInfo(field);
            FieldType annFieldType = FieldType.DEFAULT;
            int order = -1;
            if (protobuf != null) {
                fieldInfo.setRequired(protobuf.required());
                fieldInfo.setDescription(protobuf.description());
                annFieldType = protobuf.fieldType();
                order = protobuf.order();
            } else {
                fieldInfo.setRequired(false);
            }
            if (annFieldType == FieldType.DEFAULT) {
                FieldType fieldType;
                Class<?> fieldTypeClass = field.getType();
                boolean isList = fieldInfo.isList();
                if (isList) {
                    fieldTypeClass = fieldInfo.getGenericKeyType();
                }
                if ((fieldType = TYPE_MAPPING.get(fieldTypeClass)) == null) {
                    fieldType = Enum.class.isAssignableFrom(fieldTypeClass) ? FieldType.ENUM : (fieldInfo.isMap() ? FieldType.MAP : FieldType.OBJECT);
                }
                if (isZipZap) {
                    if (fieldType == FieldType.INT32) {
                        fieldType = FieldType.SINT32;
                    } else if (fieldType == FieldType.INT64) {
                        fieldType = FieldType.SINT64;
                    }
                }
                fieldInfo.setFieldType(fieldType);
            } else {
                fieldInfo.setFieldType(annFieldType);
            }
            if (order > 0) {
                if (orders.contains(order)) {
                    throw new RuntimeException("order id '" + order + "' from field name '" + fName + "'  is duplicate");
                }
                orders.add(order);
                fieldInfo.setOrder(order);
                if (order > maxOrder) {
                    maxOrder = order;
                }
            } else {
                unorderFields.add(fieldInfo);
            }
            if (fieldInfo.isList() && (fieldInfo.getFieldType().isPrimitive() || fieldInfo.getFieldType().isEnum())) {
                Packed packed = field.getAnnotation(Packed.class);
                if (packed == null) {
                    fieldInfo.setPacked(true);
                } else {
                    fieldInfo.setPacked(packed.value());
                }
            }
            ret.add(fieldInfo);
        }
        if (unorderFields.isEmpty()) {
            return ret;
        }
        for (FieldInfo fieldInfo : unorderFields) {
            fieldInfo.setOrder(++maxOrder);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Field '{}' from {} with @Protobuf annotation but not set order or order is 0, It will set order value to {}", new Object[]{fieldInfo.getField().getName(), fieldInfo.getField().getDeclaringClass().getName(), maxOrder});
        }
        return ret;
    }

    public static boolean isObjectType(Class<?> cls) {
        FieldType fieldType = TYPE_MAPPING.get(cls);
        return fieldType == null;
    }

    public static String processProtobufType(Class<?> cls) {
        FieldType fieldType = TYPE_MAPPING.get(cls);
        if (fieldType != null) {
            return fieldType.getType();
        }
        return cls.getSimpleName();
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)ProtobufProxy.class.getName());
        FIELD_FILTER_STARTS = new ArrayList<String>();
        TYPE_MAPPING = new HashMap();
        TYPE_MAPPING.put(Integer.TYPE, FieldType.INT32);
        TYPE_MAPPING.put(Integer.class, FieldType.INT32);
        TYPE_MAPPING.put(Short.TYPE, FieldType.INT32);
        TYPE_MAPPING.put(Short.class, FieldType.INT32);
        TYPE_MAPPING.put(Byte.class, FieldType.INT32);
        TYPE_MAPPING.put(Byte.TYPE, FieldType.INT32);
        TYPE_MAPPING.put(Long.TYPE, FieldType.INT64);
        TYPE_MAPPING.put(Long.class, FieldType.INT64);
        TYPE_MAPPING.put(String.class, FieldType.STRING);
        TYPE_MAPPING.put(byte[].class, FieldType.BYTES);
        TYPE_MAPPING.put(Byte[].class, FieldType.BYTES);
        TYPE_MAPPING.put(Float.class, FieldType.FLOAT);
        TYPE_MAPPING.put(Float.TYPE, FieldType.FLOAT);
        TYPE_MAPPING.put(Double.TYPE, FieldType.DOUBLE);
        TYPE_MAPPING.put(Double.class, FieldType.DOUBLE);
        TYPE_MAPPING.put(Boolean.class, FieldType.BOOL);
        TYPE_MAPPING.put(Boolean.TYPE, FieldType.BOOL);
        TYPE_MAPPING.put(Date.class, FieldType.DATE);
        FIELD_FILTER_STARTS.add("$jacoco");
    }
}

