/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf.utils;

import com.baidu.bjf.remoting.protobuf.FieldType;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FieldInfo {
    private Field field;
    boolean required;
    private String description;
    private boolean wildcardType = false;
    int order;
    private Class<?> genericKeyType;
    private Class<?> genericeValueType;
    FieldType fieldType;
    private boolean isList;
    private boolean isMap;
    private boolean packed;
    private boolean useType;
    private Class useAsType;

    public void setUseAsType(Class useAsType) {
        this.useAsType = useAsType;
    }

    public Class getUseAsType() {
        return this.useAsType;
    }

    public void setUseType(boolean useType) {
        this.useType = useType;
    }

    public boolean isUseType() {
        return this.useType;
    }

    public boolean isWildcardType() {
        return this.wildcardType;
    }

    private void checkListMapType(Field field) {
        ParameterizedType ptype;
        Type[] actualTypeArguments;
        Class<?> cls = field.getType();
        boolean needCheckGenericType = false;
        if (List.class.isAssignableFrom(cls) || Set.class.isAssignableFrom(cls)) {
            this.isList = true;
            needCheckGenericType = true;
        }
        if (Map.class.isAssignableFrom(cls)) {
            this.isMap = true;
            needCheckGenericType = true;
        }
        if (!needCheckGenericType) {
            return;
        }
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType && (actualTypeArguments = (ptype = (ParameterizedType)type).getActualTypeArguments()) != null) {
            Type[] upperBounds;
            WildcardType wildcardType;
            Type targetType;
            int length = actualTypeArguments.length;
            if (this.isList) {
                if (length != 1) {
                    throw new RuntimeException("List must use generic definiation like List<String>, please check  field name '" + field.getName() + " at class " + field.getDeclaringClass().getName());
                }
            } else if (this.isMap && length != 2) {
                throw new RuntimeException("Map must use generic definiation like Map<String, String>, please check  field name '" + field.getName() + " at class " + field.getDeclaringClass().getName());
            }
            if ((targetType = actualTypeArguments[0]) instanceof Class) {
                this.genericKeyType = (Class)targetType;
            } else {
                if (targetType instanceof ParameterizedType) {
                    boolean mapKey = false;
                    if (this.isMap) {
                        mapKey = true;
                    }
                    throw new RuntimeException(this.noSubParameterizedType(field, mapKey));
                }
                if (WildcardType.class.isAssignableFrom(targetType.getClass())) {
                    this.wildcardType = true;
                    wildcardType = (WildcardType)targetType;
                    upperBounds = wildcardType.getUpperBounds();
                    if (upperBounds != null && upperBounds.length == 1 && upperBounds[0] instanceof Class) {
                        this.genericKeyType = (Class)upperBounds[0];
                    }
                }
            }
            if (actualTypeArguments.length > 1) {
                targetType = actualTypeArguments[1];
                if (targetType instanceof Class) {
                    this.genericeValueType = (Class)targetType;
                } else {
                    if (targetType instanceof ParameterizedType) {
                        boolean mapKey = false;
                        if (this.isMap) {
                            mapKey = true;
                        }
                        throw new RuntimeException(this.noSubParameterizedType(field, mapKey));
                    }
                    if (WildcardType.class.isAssignableFrom(targetType.getClass())) {
                        this.wildcardType = true;
                        wildcardType = (WildcardType)targetType;
                        upperBounds = wildcardType.getUpperBounds();
                        if (upperBounds != null && upperBounds.length == 1 && upperBounds[0] instanceof Class) {
                            this.genericeValueType = (Class)upperBounds[0];
                        }
                    }
                }
            }
        }
    }

    private String noSubParameterizedType(Field field, boolean listOrMap) {
        String key = "List";
        if (listOrMap) {
            key = "Map";
        }
        return key + " can not has sub parameterized type  please check  field name '" + field.getName() + " at class " + field.getDeclaringClass().getName();
    }

    public FieldInfo(Field field) {
        this.field = field;
        this.checkListMapType(field);
    }

    public boolean isList() {
        return this.isList;
    }

    public void setList(boolean isList) {
        this.isList = isList;
    }

    public boolean isMap() {
        return this.isMap;
    }

    public void setMap(boolean isMap) {
        this.isMap = isMap;
    }

    public Field getField() {
        return this.field;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean hasDescription() {
        return this.description != null && this.description.trim().length() != 0;
    }

    public Class<?> getGenericKeyType() {
        return this.genericKeyType;
    }

    public void setGenericKeyType(Class<?> genericKeyType) {
        this.genericKeyType = genericKeyType;
    }

    public Class<?> getGenericeValueType() {
        return this.genericeValueType;
    }

    public void setGenericeValueType(Class<?> genericeValueType) {
        this.genericeValueType = genericeValueType;
    }

    public boolean isPacked() {
        return this.packed;
    }

    public void setPacked(boolean packed) {
        this.packed = packed;
    }

    public boolean isObjectType() {
        return this.fieldType == FieldType.OBJECT;
    }

    public boolean isEnumValueType() {
        if (this.genericeValueType != null) {
            return Enum.class.isAssignableFrom(this.genericeValueType);
        }
        return false;
    }

    public static boolean isPrimitiveType(Class c) {
        if (c.isPrimitive()) {
            return true;
        }
        return c.getName().equals(String.class.getName());
    }

    public static boolean isListType(Field field) {
        return List.class.isAssignableFrom(field.getType());
    }

    public static boolean isSetType(Field field) {
        return Set.class.isAssignableFrom(field.getType());
    }
}

