/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.configuration;

import com.android.ide.common.resources.configuration.EnumBasedResourceQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.resources.ResourceEnum;
import com.android.resources.ScreenSize;

public class ScreenSizeQualifier
extends EnumBasedResourceQualifier {
    public static final String NAME = "Screen Size";
    private static final ScreenSizeQualifier NULL_QUALIFIER = new ScreenSizeQualifier();
    private final ScreenSize mValue;

    public ScreenSizeQualifier() {
        this(null);
    }

    public ScreenSizeQualifier(ScreenSize value) {
        this.mValue = value;
    }

    public ScreenSize getValue() {
        return this.mValue;
    }

    @Override
    public ResourceEnum getEnumValue() {
        return this.mValue;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return "Size";
    }

    @Override
    public int since() {
        return 4;
    }

    @Override
    public boolean checkAndSet(String value, FolderConfiguration config) {
        ScreenSize size = ScreenSize.getEnum((String)value);
        if (size != null) {
            ScreenSizeQualifier qualifier = new ScreenSizeQualifier(size);
            config.setScreenSizeQualifier(qualifier);
            return true;
        }
        return false;
    }

    @Override
    public ScreenSizeQualifier getNullQualifier() {
        return NULL_QUALIFIER;
    }

    @Override
    public boolean isMatchFor(ResourceQualifier qualifier) {
        if (qualifier instanceof ScreenSizeQualifier) {
            int qualifierIndex = ScreenSize.getIndex((ScreenSize)((ScreenSizeQualifier)qualifier).mValue);
            int index = ScreenSize.getIndex((ScreenSize)this.mValue);
            if (index <= qualifierIndex) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this != NULL_QUALIFIER;
    }

    @Override
    public boolean isBetterMatchThan(ResourceQualifier compareTo2, ResourceQualifier reference) {
        if (compareTo2 == null) {
            return true;
        }
        ScreenSizeQualifier compareQ = (ScreenSizeQualifier)compareTo2;
        int mySL = ScreenSize.getIndex((ScreenSize)this.mValue);
        int oSL = ScreenSize.getIndex((ScreenSize)compareQ.mValue);
        int fixedMySL = mySL;
        int fixedOSL = oSL;
        int requestedSL = ScreenSize.getIndex((ScreenSize)((ScreenSizeQualifier)reference).mValue);
        if (requestedSL >= ScreenSize.NORMAL.ordinal()) {
            if (fixedMySL == -1) {
                fixedMySL = ScreenSize.NORMAL.ordinal();
            }
            if (fixedOSL == -1) {
                fixedOSL = ScreenSize.NORMAL.ordinal();
            }
        }
        if (fixedMySL == fixedOSL) {
            return mySL != -1;
        }
        return fixedMySL > fixedOSL;
    }
}

