/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004J\u0006\u0010\u0018\u001a\u00020\u000fR\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/lint/detector/api/ApplicableVariants;", "", "applicableVariants", "", "", "(Ljava/util/Set;)V", "_variants", "", "excludedVariantNames", "", "getExcludedVariantNames", "()Ljava/util/List;", "includedVariantNames", "getIncludedVariantNames", "variantSpecific", "", "getVariantSpecific", "()Z", "variants", "getVariants", "()Ljava/util/Set;", "addVariant", "", "variantName", "includesMoreThanExcludes", "lint-api"})
@SourceDebugExtension(value={"SMAP\nIncident.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Incident.kt\ncom/android/tools/lint/detector/api/ApplicableVariants\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,435:1\n1#2:436\n*E\n"})
public final class ApplicableVariants {
    @NotNull
    private final Set<String> applicableVariants;
    @Nullable
    private Set<String> _variants;

    public ApplicableVariants(@NotNull Set<String> applicableVariants) {
        Intrinsics.checkNotNullParameter(applicableVariants, (String)"applicableVariants");
        this.applicableVariants = applicableVariants;
    }

    public final boolean getVariantSpecific() {
        return this.getVariants().size() < this.applicableVariants.size();
    }

    @NotNull
    public final Set<String> getVariants() {
        Set set = this._variants;
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    public final void addVariant(@NotNull String variantName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Set set = this._variants;
        if (set == null) {
            Set set2;
            Set it = set2 = (Set)new LinkedHashSet();
            boolean bl = false;
            this._variants = it;
            set = set2;
        }
        Set names = set;
        names.add((String)variantName);
    }

    public final boolean includesMoreThanExcludes() {
        int allVariantCount;
        boolean bl = this.getVariantSpecific();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int variantCount = this.getVariants().size();
        return variantCount <= (allVariantCount = this.applicableVariants.size()) - variantCount;
    }

    @NotNull
    public final List<String> getIncludedVariantNames() {
        return SequencesKt.toList((Sequence)SequencesKt.sorted((Sequence)CollectionsKt.asSequence((Iterable)this.getVariants())));
    }

    @NotNull
    public final List<String> getExcludedVariantNames() {
        Set included = new HashSet(this.getIncludedVariantNames());
        Sets.SetView setView = Sets.difference(this.applicableVariants, (Set)included);
        Intrinsics.checkNotNullExpressionValue((Object)setView, (String)"difference(applicableVariants, included)");
        Set excluded = (Set)setView;
        return SequencesKt.toList((Sequence)SequencesKt.sorted((Sequence)CollectionsKt.asSequence((Iterable)excluded)));
    }
}

