/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.dsl.Installation;
import com.android.build.api.variant.ApkInstallGroup;
import com.android.build.api.variant.impl.VariantApiExtensionsKt;
import com.android.build.gradle.internal.BuildToolsExecutableInput;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkComponentsKt;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.testing.ConnectedDeviceProvider;
import com.android.build.gradle.internal.utils.ApkSources;
import com.android.build.gradle.internal.utils.DefaultDeviceApkOutput;
import com.android.build.gradle.internal.utils.DeviceApkOutput;
import com.android.build.gradle.internal.utils.InstallApkUtilsKt;
import com.android.build.gradle.internal.utils.SdkApkInstallGroup;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.builder.testing.api.DeviceProvider;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.DEPLOYMENT)
public abstract class InstallVariantTask
extends NonIncrementalTask {
    private int timeOutInMs = 0;
    private Collection<String> installOptions;
    private String variantName;
    private Set<String> supportedAbis;
    private AndroidVersion minSdkVersion;

    @Inject
    public InstallVariantTask() {
        this.getOutputs().upToDateWhen(task -> {
            this.getLogger().debug("Install task is always run.");
            return false;
        });
    }

    @Override
    protected void doTaskAction() throws DeviceException, ExecutionException {
        LoggerWrapper iLogger = new LoggerWrapper(this.getLogger());
        ConnectedDeviceProvider deviceProvider = new ConnectedDeviceProvider(this.getBuildTools().adbExecutable(), this.getTimeOutInMs(), (ILogger)iLogger, System.getenv("ANDROID_SERIAL"));
        deviceProvider.use(() -> {
            DefaultDeviceApkOutput deviceApkOutput = new DefaultDeviceApkOutput(new ApkSources((Provider<Directory>)this.getApkDirectory(), (FileCollection)this.getPrivacySandboxSdksApksFiles(), (Provider<Directory>)this.getPrivacySandboxSupportedSdkAdditionalSplitApks(), (Provider<Directory>)this.getPrivacySandboxCompatApks(), (Provider<Directory>)this.getDexMetadataDirectory()), this.supportedAbis, this.minSdkVersion, this.variantName, (String)this.getProjectPath().get(), iLogger);
            InstallVariantTask.install(deviceApkOutput, (String)this.getProjectPath().get(), this.variantName, deviceProvider, this.getInstallOptions(), this.getTimeOutInMs(), this.getLogger());
            return null;
        });
    }

    static void install(DeviceApkOutput deviceApkOutput, String projectPath, String variantName, DeviceProvider deviceProvider, Collection<String> installOptions, int timeOutInMs, Logger logger) throws DeviceException {
        LoggerWrapper iLogger = new LoggerWrapper(logger);
        int successfulInstallCount = 0;
        List devices = deviceProvider.getDevices();
        for (DeviceConnector device : devices) {
            List<ApkInstallGroup> installGroups = deviceApkOutput.getApks(InstallApkUtilsKt.getDeviceSpec(device));
            Collection extraArgs = (Collection)MoreObjects.firstNonNull(installOptions, (Object)ImmutableList.of());
            for (ApkInstallGroup apkInstallGroup : installGroups) {
                List<File> apkFiles2 = apkInstallGroup.getApks().stream().map(RegularFile::getAsFile).collect(Collectors.toList());
                if (apkInstallGroup instanceof SdkApkInstallGroup) {
                    SdkApkInstallGroup sdkApkInstallGroup = (SdkApkInstallGroup)apkInstallGroup;
                    InstallVariantTask.installPrivacySandboxSdkApks(logger, device, projectPath, sdkApkInstallGroup.getSourceSdk(), apkFiles2, extraArgs, iLogger, variantName, timeOutInMs);
                    continue;
                }
                if (apkFiles2.isEmpty()) {
                    logger.lifecycle("Skipping device '{}' for '{}:{}': Could not find build of variant which supports density {} and an ABI in {}", new Object[]{device.getName(), projectPath, variantName, device.getDensity(), Joiner.on((String)", ").join((Iterable)device.getAbis())});
                    continue;
                }
                logger.lifecycle("Installing APK '{}' on '{}' for {}:{}", new Object[]{FileUtils.getNamesAsCommaSeparatedList(apkFiles2), device.getName(), projectPath, variantName});
                InstallVariantTask.installPackages(device, apkFiles2, extraArgs, timeOutInMs, iLogger);
                ++successfulInstallCount;
            }
        }
        if (successfulInstallCount == 0) {
            throw new GradleException("Failed to install on any devices.");
        }
        logger.quiet("Installed on {} {}.", new Object[]{successfulInstallCount, successfulInstallCount == 1 ? "device" : "devices"});
    }

    private static void installPackages(DeviceConnector device, List<File> apkFiles2, Collection<String> extraArgs, int timeOutInMs, ILogger iLogger) throws DeviceException {
        if (apkFiles2.size() > 1) {
            device.installPackages(apkFiles2, extraArgs, timeOutInMs, iLogger);
        } else {
            device.installPackage(apkFiles2.get(0), extraArgs, timeOutInMs, iLogger);
        }
    }

    private static void installPrivacySandboxSdkApks(Logger logger, DeviceConnector device, String projectPath, String sourceSdkPakageName, List<File> sdkApkFiles, Collection<String> extraArgs, ILogger iLogger, String variantName, int timeOutInMs) {
        try {
            logger.lifecycle("Installing Privacy Sandbox APK '{}' on '{}' for {}:{}", new Object[]{FileUtils.getNamesAsCommaSeparatedList(sdkApkFiles), device.getName(), projectPath, variantName});
            InstallVariantTask.installPackages(device, sdkApkFiles, extraArgs, timeOutInMs, iLogger);
        }
        catch (DeviceException e) {
            logger.error(String.format("Failed to install privacy sandbox SDK APKs from %s", sourceSdkPakageName), (Throwable)e);
        }
    }

    @Input
    public int getTimeOutInMs() {
        return this.timeOutInMs;
    }

    public void setTimeOutInMs(int timeOutInMs) {
        this.timeOutInMs = timeOutInMs;
    }

    @Input
    @Optional
    public Collection<String> getInstallOptions() {
        return this.installOptions;
    }

    public void setInstallOptions(Collection<String> installOptions) {
        this.installOptions = installOptions;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract DirectoryProperty getApkDirectory();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public abstract ConfigurableFileCollection getPrivacySandboxSdksApksFiles();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public abstract DirectoryProperty getPrivacySandboxSupportedSdkAdditionalSplitApks();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public abstract DirectoryProperty getPrivacySandboxCompatApks();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public abstract DirectoryProperty getDexMetadataDirectory();

    @Nested
    public abstract BuildToolsExecutableInput getBuildTools();

    public static class CreationAction
    extends VariantTaskCreationAction<InstallVariantTask, ApkCreationConfig> {
        public CreationAction(ApkCreationConfig creationConfig) {
            super(creationConfig);
        }

        @Override
        public String getName() {
            return this.computeTaskName("install");
        }

        @Override
        public Class<InstallVariantTask> getType() {
            return InstallVariantTask.class;
        }

        @Override
        public void configure(InstallVariantTask task) {
            super.configure(task);
            task.variantName = ((ApkCreationConfig)this.creationConfig).getBaseName();
            task.supportedAbis = ((ApkCreationConfig)this.creationConfig).getNativeBuildCreationConfig() == null ? Collections.emptySet() : ((ApkCreationConfig)this.creationConfig).getNativeBuildCreationConfig().getSupportedAbis();
            task.minSdkVersion = VariantApiExtensionsKt.toSharedAndroidVersion(((ApkCreationConfig)this.creationConfig).getMinSdk());
            task.setDescription("Installs the " + ((ApkCreationConfig)this.creationConfig).getDescription() + ".");
            task.setGroup("Install");
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(SingleArtifact.APK.INSTANCE, task.getApkDirectory());
            if (((ApkCreationConfig)this.creationConfig).getPrivacySandboxCreationConfig() != null) {
                task.getPrivacySandboxSdksApksFiles().setFrom((Iterable)((ApkCreationConfig)this.creationConfig).getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.ANDROID_PRIVACY_SANDBOX_EXTRACTED_SDK_APKS));
                task.getPrivacySandboxSupportedSdkAdditionalSplitApks().set(((ApkCreationConfig)this.creationConfig).getArtifacts().get(InternalArtifactType.USES_SDK_LIBRARY_SPLIT_FOR_LOCAL_DEPLOYMENT.INSTANCE));
                task.getPrivacySandboxCompatApks().set(((ApkCreationConfig)this.creationConfig).getArtifacts().get(InternalArtifactType.EXTRACTED_SDK_APKS.INSTANCE));
            }
            task.getPrivacySandboxSdksApksFiles().disallowChanges();
            task.getPrivacySandboxSupportedSdkAdditionalSplitApks().disallowChanges();
            task.getPrivacySandboxCompatApks().disallowChanges();
            Installation installationOptions = ((ApkCreationConfig)this.creationConfig).getGlobal().getInstallationOptions();
            task.setTimeOutInMs(installationOptions.getTimeOutInMs());
            task.setInstallOptions(installationOptions.getInstallOptions());
            SdkComponentsKt.initialize(task.getBuildTools(), (Task)task, this.creationConfig);
            task.getDexMetadataDirectory().set(((ApkCreationConfig)this.creationConfig).getArtifacts().get(InternalArtifactType.DEX_METADATA_DIRECTORY.INSTANCE));
            task.getDexMetadataDirectory().disallowChanges();
            ((ApkCreationConfig)this.creationConfig).getLifecycleTasks().invokeApkInstallationActions$gradle_core((Task)task);
        }

        @Override
        public void handleProvider(TaskProvider<InstallVariantTask> taskProvider) {
            super.handleProvider(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getTaskContainer().setInstallTask(taskProvider);
        }
    }
}

