/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.cxx.json.PlainFileGsonTypeAdaptor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/android/build/gradle/internal/tasks/SigningConfigMetadata;", "", "()V", "Companion", "gradle"})
public final class SigningConfigMetadata {
    private static final String PERSISTED_FILE_NAME = "signing-config.json";
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\u0006J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/tasks/SigningConfigMetadata$Companion;", "", "()V", "PERSISTED_FILE_NAME", "", "getOutputFile", "Ljava/io/File;", "directory", "input", "Lorg/gradle/api/file/FileCollection;", "load", "Lcom/android/build/gradle/internal/dsl/SigningConfig;", "save", "", "outputDirectory", "signingConfig", "gradle"})
    public static final class Companion {
        @Nullable
        public final SigningConfig load(@Nullable FileCollection input) throws IOException {
            File persistedFile = input != null ? this.getOutputFile(input) : null;
            return persistedFile != null ? this.load(persistedFile) : null;
        }

        public final void save(@NotNull File outputDirectory, @Nullable SigningConfig signingConfig) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
            File outputFile = new File(outputDirectory, SigningConfigMetadata.PERSISTED_FILE_NAME);
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter((Type)((Object)File.class), (Object)new PlainFileGsonTypeAdaptor());
            Gson gson = gsonBuilder.create();
            FileUtils.write((File)outputFile, (CharSequence)gson.toJson((Object)signingConfig));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final SigningConfig load(@NotNull File input) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter((Type)((Object)File.class), (Object)new PlainFileGsonTypeAdaptor());
            Gson gson = gsonBuilder.create();
            Closeable closeable = new FileReader(input);
            Throwable throwable = null;
            try {
                FileReader fileReader = (FileReader)closeable;
                SigningConfig signingConfig = (SigningConfig)gson.fromJson((Reader)fileReader, SigningConfig.class);
                return signingConfig;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final File getOutputFile(FileCollection input) {
            File file;
            FileTree fileTree = input.getAsFileTree();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileTree, (String)"input.asFileTree");
            if (fileTree.isEmpty()) {
                return null;
            }
            FileTree fileTree2 = input.getAsFileTree();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileTree2, (String)"input.asFileTree");
            File file2 = file = fileTree2.getSingleFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
            if (Intrinsics.areEqual((Object)file2.getName(), (Object)SigningConfigMetadata.PERSISTED_FILE_NAME) ^ true) {
                return null;
            }
            return file;
        }

        @NotNull
        public final File getOutputFile(@NotNull File directory) {
            Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
            return new File(directory, SigningConfigMetadata.PERSISTED_FILE_NAME);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

