/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.DexRelocator;
import com.android.build.gradle.internal.tasks.PerModuleBundleTask;
import com.android.build.gradle.internal.tasks.Relocator;
import com.android.build.gradle.internal.tasks.ResRelocator;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSetMetadata;
import com.android.builder.files.NativeLibraryAbiPredicate;
import com.android.builder.packaging.JarMerger;
import com.android.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001;B\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u00020%032\n\b\u0002\u00104\u001a\u0004\u0018\u0001052\u0010\b\u0002\u00106\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u000107H\u0002J\b\u00108\u001a\u000209H\u0002J\b\u0010:\u001a\u00020/H\u0007R6\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00048G@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR&\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u000b8G@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R&\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00118G@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R&\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00118G@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u0011\u0010\u001a\u001a\u00020\u00058G\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R&\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00118G@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0014\"\u0004\b!\u0010\u0016R&\u0010\"\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00118G@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0014\"\u0004\b$\u0010\u0016R&\u0010&\u001a\u00020%2\u0006\u0010\u0003\u001a\u00020%8G@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R&\u0010+\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u000b8G@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u000e\"\u0004\b-\u0010\u0010\u00a8\u0006<"}, d2={"Lcom/android/build/gradle/internal/tasks/PerModuleBundleTask;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "()V", "<set-?>", "", "", "abiFilters", "getAbiFilters", "()Ljava/util/Set;", "setAbiFilters", "(Ljava/util/Set;)V", "Lcom/android/build/api/artifact/BuildableArtifact;", "assetsFiles", "getAssetsFiles", "()Lcom/android/build/api/artifact/BuildableArtifact;", "setAssetsFiles", "(Lcom/android/build/api/artifact/BuildableArtifact;)V", "Lorg/gradle/api/file/FileCollection;", "dexFiles", "getDexFiles", "()Lorg/gradle/api/file/FileCollection;", "setDexFiles", "(Lorg/gradle/api/file/FileCollection;)V", "featureDexFiles", "getFeatureDexFiles", "setFeatureDexFiles", "fileName", "getFileName", "()Ljava/lang/String;", "fileNameSupplier", "Ljava/util/function/Supplier;", "javaResFiles", "getJavaResFiles", "setJavaResFiles", "nativeLibsFiles", "getNativeLibsFiles", "setNativeLibsFiles", "Ljava/io/File;", "outputDir", "getOutputDir", "()Ljava/io/File;", "setOutputDir", "(Ljava/io/File;)V", "resFiles", "getResFiles", "setResFiles", "addHybridFolder", "", "jarMerger", "Lcom/android/builder/packaging/JarMerger;", "files", "", "relocator", "Lcom/android/builder/packaging/JarMerger$Relocator;", "fileFilter", "Ljava/util/function/Predicate;", "hasFeatureDexFiles", "", "zip", "CreationAction", "gradle"})
public class PerModuleBundleTask
extends AndroidVariantTask {
    @NotNull
    private File outputDir;
    @NotNull
    private FileCollection dexFiles;
    @NotNull
    private FileCollection featureDexFiles;
    @NotNull
    private BuildableArtifact resFiles;
    @NotNull
    private FileCollection javaResFiles;
    @NotNull
    private BuildableArtifact assetsFiles;
    @NotNull
    private FileCollection nativeLibsFiles;
    @Nullable
    private Set<String> abiFilters;
    private Supplier<String> fileNameSupplier;

    @OutputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final File getOutputDir() {
        File file = this.outputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        return file;
    }

    private final void setOutputDir(File file) {
        this.outputDir = file;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getDexFiles() {
        FileCollection fileCollection = this.dexFiles;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dexFiles");
        }
        return fileCollection;
    }

    private final void setDexFiles(FileCollection fileCollection) {
        this.dexFiles = fileCollection;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getFeatureDexFiles() {
        FileCollection fileCollection = this.featureDexFiles;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureDexFiles");
        }
        return fileCollection;
    }

    private final void setFeatureDexFiles(FileCollection fileCollection) {
        this.featureDexFiles = fileCollection;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final BuildableArtifact getResFiles() {
        BuildableArtifact buildableArtifact = this.resFiles;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resFiles");
        }
        return buildableArtifact;
    }

    private final void setResFiles(BuildableArtifact buildableArtifact) {
        this.resFiles = buildableArtifact;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getJavaResFiles() {
        FileCollection fileCollection = this.javaResFiles;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaResFiles");
        }
        return fileCollection;
    }

    private final void setJavaResFiles(FileCollection fileCollection) {
        this.javaResFiles = fileCollection;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final BuildableArtifact getAssetsFiles() {
        BuildableArtifact buildableArtifact = this.assetsFiles;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"assetsFiles");
        }
        return buildableArtifact;
    }

    private final void setAssetsFiles(BuildableArtifact buildableArtifact) {
        this.assetsFiles = buildableArtifact;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getNativeLibsFiles() {
        FileCollection fileCollection = this.nativeLibsFiles;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nativeLibsFiles");
        }
        return fileCollection;
    }

    private final void setNativeLibsFiles(FileCollection fileCollection) {
        this.nativeLibsFiles = fileCollection;
    }

    @Input
    @Optional
    @Nullable
    public final Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    private final void setAbiFilters(Set<String> set) {
        this.abiFilters = set;
    }

    @Input
    @NotNull
    public final String getFileName() {
        Supplier<String> supplier = this.fileNameSupplier;
        if (supplier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fileNameSupplier");
        }
        String string = supplier.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileNameSupplier.get()");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void zip() {
        File file = this.outputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        FileUtils.cleanOutputDir((File)file);
        File file2 = this.outputDir;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        JarMerger jarMerger = new JarMerger(new File(file2, this.getFileName()).toPath());
        Set<String> filters = this.abiFilters;
        Predicate abiFilter = filters != null ? (Predicate)new NativeLibraryAbiPredicate(filters, false) : null;
        Closeable closeable = (Closeable)jarMerger;
        Throwable throwable = null;
        try {
            Set javaResFilesSet;
            Set set;
            Iterable $receiver$iv;
            Set dexFilesSet;
            Set set2;
            JarMerger it = (JarMerger)closeable;
            BuildableArtifact buildableArtifact = this.assetsFiles;
            if (buildableArtifact == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"assetsFiles");
            }
            it.addDirectory(((File)CollectionsKt.single((Iterable)((Iterable)buildableArtifact))).toPath(), null, null, (JarMerger.Relocator)new Relocator("assets"));
            BuildableArtifact buildableArtifact2 = this.resFiles;
            if (buildableArtifact2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"resFiles");
            }
            it.addJar(((File)CollectionsKt.single((Iterable)((Iterable)buildableArtifact2))).toPath(), null, (JarMerger.Relocator)new ResRelocator());
            if (this.hasFeatureDexFiles()) {
                FileCollection fileCollection = this.featureDexFiles;
                if (fileCollection == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"featureDexFiles");
                }
                set2 = fileCollection.getFiles();
            } else {
                FileCollection fileCollection = this.dexFiles;
                if (fileCollection == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"dexFiles");
                }
                set2 = dexFilesSet = fileCollection.getFiles();
            }
            if (dexFilesSet.size() == 1) {
                Set set3 = dexFilesSet;
                Intrinsics.checkExpressionValueIsNotNull((Object)set3, (String)"dexFilesSet");
                Iterable iterable = set3;
                JarMerger jarMerger2 = it;
                PerModuleBundleTask perModuleBundleTask = this;
                Iterable iterable2 = $receiver$iv;
                Comparator comparator = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        File it;
                        File file = it = (File)a;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                        it = (File)b;
                        Comparable comparable = (Comparable)((Object)file.getName());
                        File file2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                        String string = file2.getName();
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                    }
                };
                List list = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator);
                perModuleBundleTask.addHybridFolder(jarMerger2, list, new Relocator("dex"), null);
            } else {
                Set set4 = dexFilesSet;
                Intrinsics.checkExpressionValueIsNotNull((Object)set4, (String)"dexFilesSet");
                $receiver$iv = set4;
                JarMerger jarMerger3 = it;
                PerModuleBundleTask perModuleBundleTask = this;
                Iterable iterable = $receiver$iv;
                Comparator comparator = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        File it;
                        File file = it = (File)a;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                        it = (File)b;
                        Comparable comparable = (Comparable)((Object)file.getName());
                        File file2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                        String string = file2.getName();
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                    }
                };
                List list = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
                perModuleBundleTask.addHybridFolder(jarMerger3, list, new DexRelocator("dex"), null);
            }
            if (this.hasFeatureDexFiles()) {
                set = SetsKt.emptySet();
            } else {
                FileCollection fileCollection = this.javaResFiles;
                if (fileCollection == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"javaResFiles");
                }
                set = fileCollection.getFiles();
            }
            Set set5 = javaResFilesSet = set;
            Intrinsics.checkExpressionValueIsNotNull((Object)set5, (String)"javaResFilesSet");
            this.addHybridFolder(it, set5, new Relocator("root"), JarMerger.EXCLUDE_CLASSES);
            FileCollection fileCollection = this.nativeLibsFiles;
            if (fileCollection == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"nativeLibsFiles");
            }
            Set set6 = fileCollection.getFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)set6, (String)"nativeLibsFiles.files");
            PerModuleBundleTask.addHybridFolder$default(this, it, set6, null, abiFilter, 4, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void addHybridFolder(JarMerger jarMerger, Iterable<? extends File> files2, JarMerger.Relocator relocator, Predicate<String> fileFilter) {
        for (File file : files2) {
            if (file.isFile()) {
                String string = file.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
                if (StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) {
                    jarMerger.addJar(file.toPath(), fileFilter, relocator);
                    continue;
                }
                if (fileFilter != null && !fileFilter.test(file.getName())) continue;
                if (relocator != null) {
                    jarMerger.addFile(relocator.relocate(file.getName()), file.toPath());
                    continue;
                }
                jarMerger.addFile(file.getName(), file.toPath());
                continue;
            }
            jarMerger.addDirectory(file.toPath(), fileFilter, null, relocator);
        }
    }

    static /* synthetic */ void addHybridFolder$default(PerModuleBundleTask perModuleBundleTask, JarMerger jarMerger, Iterable iterable, JarMerger.Relocator relocator, Predicate predicate, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addHybridFolder");
        }
        if ((n & 4) != 0) {
            relocator = null;
        }
        if ((n & 8) != 0) {
            predicate = null;
        }
        perModuleBundleTask.addHybridFolder(jarMerger, iterable, relocator, predicate);
    }

    private final boolean hasFeatureDexFiles() {
        FileCollection fileCollection = this.featureDexFiles;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureDexFiles");
        }
        Set set = fileCollection.getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"featureDexFiles.files");
        Collection collection = set;
        return !collection.isEmpty();
    }

    @NotNull
    public static final /* synthetic */ Supplier access$getFileNameSupplier$p(PerModuleBundleTask $this) {
        Supplier<String> supplier = $this.fileNameSupplier;
        if (supplier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fileNameSupplier");
        }
        return supplier;
    }

    @NotNull
    public static final /* synthetic */ File access$getOutputDir$p(PerModuleBundleTask $this) {
        File file = $this.outputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        return file;
    }

    @NotNull
    public static final /* synthetic */ BuildableArtifact access$getAssetsFiles$p(PerModuleBundleTask $this) {
        BuildableArtifact buildableArtifact = $this.assetsFiles;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"assetsFiles");
        }
        return buildableArtifact;
    }

    @NotNull
    public static final /* synthetic */ BuildableArtifact access$getResFiles$p(PerModuleBundleTask $this) {
        BuildableArtifact buildableArtifact = $this.resFiles;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resFiles");
        }
        return buildableArtifact;
    }

    @NotNull
    public static final /* synthetic */ FileCollection access$getDexFiles$p(PerModuleBundleTask $this) {
        FileCollection fileCollection = $this.dexFiles;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dexFiles");
        }
        return fileCollection;
    }

    @NotNull
    public static final /* synthetic */ FileCollection access$getFeatureDexFiles$p(PerModuleBundleTask $this) {
        FileCollection fileCollection = $this.featureDexFiles;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureDexFiles");
        }
        return fileCollection;
    }

    @NotNull
    public static final /* synthetic */ FileCollection access$getJavaResFiles$p(PerModuleBundleTask $this) {
        FileCollection fileCollection = $this.javaResFiles;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaResFiles");
        }
        return fileCollection;
    }

    @NotNull
    public static final /* synthetic */ FileCollection access$getNativeLibsFiles$p(PerModuleBundleTask $this) {
        FileCollection fileCollection = $this.nativeLibsFiles;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nativeLibsFiles");
        }
        return fileCollection;
    }

    @Nullable
    public static final /* synthetic */ Set access$getAbiFilters$p(PerModuleBundleTask $this) {
        return $this.abiFilters;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0007H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/PerModuleBundleTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/PerModuleBundleTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "name", "", "getName", "()Ljava/lang/String;", "outputDir", "Ljava/io/File;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "preConfigure", "taskName", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<PerModuleBundleTask> {
        private File outputDir;

        @Override
        @NotNull
        public String getName() {
            String string = this.getVariantScope().getTaskName("build", "PreBundle");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName(\"build\", \"PreBundle\")");
            return string;
        }

        @Override
        @NotNull
        public Class<PerModuleBundleTask> getType() {
            return PerModuleBundleTask.class;
        }

        @Override
        public void preConfigure(@NotNull String taskName) {
            Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
            super.preConfigure(taskName);
            this.outputDir = BuildArtifactsHolder.appendArtifact$default(this.getVariantScope().getArtifacts(), (ArtifactType)InternalArtifactType.MODULE_BUNDLE, taskName, null, 4, null);
        }

        @Override
        public void configure(@NotNull PerModuleBundleTask task) {
            Supplier supplier;
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            BuildArtifactsHolder buildArtifactsHolder = this.getVariantScope().getArtifacts();
            Intrinsics.checkExpressionValueIsNotNull((Object)buildArtifactsHolder, (String)"variantScope.artifacts");
            BuildArtifactsHolder artifacts = buildArtifactsHolder;
            if (this.getVariantScope().getType().isBaseModule()) {
                supplier = configure.1.INSTANCE;
            } else {
                Supplier<String> supplier2 = FeatureSetMetadata.getInstance().getFeatureNameSupplierForTask(this.getVariantScope(), (Task)task);
                Intrinsics.checkExpressionValueIsNotNull(supplier2, (String)"FeatureSetMetadata.getIn\u2026rTask(variantScope, task)");
                Supplier<String> featureName = supplier2;
                supplier = new Supplier<String>(featureName){
                    final /* synthetic */ Supplier $featureName;

                    @NotNull
                    public final String get() {
                        return (String)this.$featureName.get() + ".zip";
                    }
                    {
                        this.$featureName = supplier;
                    }
                };
            }
            task.fileNameSupplier = supplier;
            File file = this.outputDir;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
            }
            task.outputDir = file;
            task.assetsFiles = artifacts.getFinalArtifactFiles(InternalArtifactType.MERGED_ASSETS);
            task.resFiles = artifacts.getFinalArtifactFiles(this.getVariantScope().useResourceShrinker() ? InternalArtifactType.SHRUNK_LINKED_RES_FOR_BUNDLE : InternalArtifactType.LINKED_RES_FOR_BUNDLE);
            FileCollection fileCollection = this.getVariantScope().getTransformManager().getPipelineOutputAsFileCollection(StreamFilter.DEX);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"variantScope.transformMa\u2026        StreamFilter.DEX)");
            task.dexFiles = fileCollection;
            VariantScope variantScope = this.getVariantScope();
            GlobalScope globalScope = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            Project project = globalScope.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"variantScope.globalScope.project");
            FileCollection fileCollection2 = variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_DEX, MapsKt.mapOf((Pair)TuplesKt.to(AndroidArtifacts.MODULE_PATH, (Object)project.getPath())));
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"variantScope.getArtifact\u2026t.path)\n                )");
            task.featureDexFiles = fileCollection2;
            FileCollection fileCollection3 = this.getVariantScope().getTransformManager().getPipelineOutputAsFileCollection(StreamFilter.RESOURCES);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection3, (String)"variantScope.transformMa\u2026  StreamFilter.RESOURCES)");
            task.javaResFiles = fileCollection3;
            FileCollection fileCollection4 = this.getVariantScope().getTransformManager().getPipelineOutputAsFileCollection(StreamFilter.NATIVE_LIBS);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection4, (String)"variantScope.transformMa\u2026StreamFilter.NATIVE_LIBS)");
            task.nativeLibsFiles = fileCollection4;
            GradleVariantConfiguration gradleVariantConfiguration = this.getVariantScope().getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
            task.abiFilters = gradleVariantConfiguration.getSupportedAbis();
        }

        public CreationAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            super(variantScope);
        }
    }
}

