/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMultimap;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.MethodNode;

public class InstantRunMethodVerifier {
    private static final ImmutableMultimap<Type, Method> blackListedMethods = ImmutableMultimap.builder().put((Object)Type.getObjectType((String)"java/lang/reflect/Field"), (Object)Method.getMethod((String)"Object get(Object)")).put((Object)Type.getObjectType((String)"java/lang/reflect/Field"), (Object)Method.getMethod((String)"boolean getBoolean(Object)")).put((Object)Type.getObjectType((String)"java/lang/reflect/Field"), (Object)Method.getMethod((String)"byte getByte(Object)")).put((Object)Type.getObjectType((String)"java/lang/reflect/Field"), (Object)Method.getMethod((String)"char getChar(Object)")).put((Object)Type.getObjectType((String)"java/lang/reflect/Field"), (Object)Method.getMethod((String)"double getDouble(Object)")).put((Object)Type.getObjectType((String)"java/lang/reflect/Field"), (Object)Method.getMethod((String)"float getFloat(Object)")).put((Object)Type.getObjectType((String)"java/lang/reflect/Field"), (Object)Method.getMethod((String)"int getInt(Object)")).put((Object)Type.getObjectType((String)"java/lang/reflect/Field"), (Object)Method.getMethod((String)"long getLong(Object)")).put((Object)Type.getObjectType((String)"java/lang/reflect/Field"), (Object)Method.getMethod((String)"short getShort(Object)")).put((Object)Type.getObjectType((String)"java/lang/reflect/Field"), (Object)Method.getMethod((String)"void set(Object, Object)")).put((Object)Type.getObjectType((String)"java/lang/reflect/Field"), (Object)Method.getMethod((String)"void setBoolean(Object, boolean)")).put((Object)Type.getObjectType((String)"java/lang/reflect/Field"), (Object)Method.getMethod((String)"void setByte(Object, byte)")).put((Object)Type.getObjectType((String)"java/lang/reflect/Field"), (Object)Method.getMethod((String)"void setChar(Object, char)")).put((Object)Type.getObjectType((String)"java/lang/reflect/Field"), (Object)Method.getMethod((String)"void setDouble(Object, double)")).put((Object)Type.getObjectType((String)"java/lang/reflect/Field"), (Object)Method.getMethod((String)"void setFloat(Object, float)")).put((Object)Type.getObjectType((String)"java/lang/reflect/Field"), (Object)Method.getMethod((String)"void setInt(Object, int)")).put((Object)Type.getObjectType((String)"java/lang/reflect/Field"), (Object)Method.getMethod((String)"void setLong(Object, long)")).put((Object)Type.getObjectType((String)"java/lang/reflect/Field"), (Object)Method.getMethod((String)"void setShort(Object, short)")).put((Object)Type.getObjectType((String)"java/lang/reflect/Constructor"), (Object)Method.getMethod((String)"Object newInstance(Object[])")).put((Object)Type.getObjectType((String)"java/lang/Class"), (Object)Method.getMethod((String)"Object newInstance()")).put((Object)Type.getObjectType((String)"java/lang/reflect/Method"), (Object)Method.getMethod((String)"Object invoke(Object, Object[])")).build();

    public static InstantRunVerifierStatus verifyMethod(MethodNode method) {
        VerifierMethodVisitor mv = new VerifierMethodVisitor(method);
        method.accept((MethodVisitor)mv);
        return (InstantRunVerifierStatus)((Object)mv.incompatibleChange.or((Object)InstantRunVerifierStatus.COMPATIBLE));
    }

    public static class VerifierMethodVisitor
    extends MethodNode {
        Optional<InstantRunVerifierStatus> incompatibleChange = Optional.absent();

        public VerifierMethodVisitor(MethodNode method) {
            super(327680, method.access, method.name, method.desc, method.signature, method.exceptions.toArray(new String[0]));
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            Type receiver = Type.getObjectType((String)owner);
            if (!this.incompatibleChange.isPresent() && opcode == 182 && blackListedMethods.containsKey((Object)receiver)) {
                for (Method method : blackListedMethods.get((Object)receiver)) {
                    if (!method.getName().equals(name) || !method.getDescriptor().equals(desc)) continue;
                    this.incompatibleChange = Optional.of((Object)((Object)InstantRunVerifierStatus.REFLECTION_USED));
                }
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }
}

