/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.com.google.common.collect.HashBasedTable;
import com.android.tools.r8.jetbrains.kotlinx.metadata.Flag;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmConstructorExtensionVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmConstructorVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmExtensionType;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmFunctionExtensionVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmFunctionVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmPropertyExtensionVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmPropertyVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmTypeVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmValueParameterVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmConstructorExtensionVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmFieldSignature;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmFunctionExtensionVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmMethodSignature;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmPropertyExtensionVisitor;
import java.util.BitSet;

class NonNullParameterHintCollector {
    NonNullParameterHintCollector() {
    }

    static class PropertyVisitor
    extends KmPropertyVisitor {
        private final HashBasedTable<String, String, BitSet> paramHints;
        private BitSet paramHint = new BitSet();
        private int paramIndex = 0;
        private String name = "";
        private String descriptor = "";

        PropertyVisitor(HashBasedTable<String, String, BitSet> paramHints) {
            this.paramHints = paramHints;
        }

        @Override
        public KmTypeVisitor visitReturnType(int typeFlags) {
            if (!Flag.Type.IS_NULLABLE.invoke(typeFlags)) {
                this.paramHint.set(this.paramIndex);
            }
            ++this.paramIndex;
            return null;
        }

        @Override
        public KmPropertyExtensionVisitor visitExtensions(KmExtensionType type) {
            if (type != JvmPropertyExtensionVisitor.TYPE) {
                return null;
            }
            return new JvmPropertyExtensionVisitor(){

                @Override
                public void visit(JvmFieldSignature fieldDesc, JvmMethodSignature getterDesc, JvmMethodSignature setterDesc) {
                    if (setterDesc != null) {
                        name = setterDesc.getName();
                        descriptor = setterDesc.getDesc();
                    }
                }
            };
        }

        @Override
        public void visitEnd() {
            if (this.name.isEmpty() || this.descriptor.isEmpty()) {
                return;
            }
            this.paramHints.put((Object)this.name, (Object)this.descriptor, (Object)this.paramHint);
        }
    }

    static class ConstructorVisitor
    extends KmConstructorVisitor {
        private final HashBasedTable<String, String, BitSet> paramHints;
        private BitSet paramHint = new BitSet();
        private int paramIndex = 0;
        private final String name = "<init>";
        private String descriptor = "";

        ConstructorVisitor(HashBasedTable<String, String, BitSet> paramHints) {
            this.paramHints = paramHints;
        }

        @Override
        public KmValueParameterVisitor visitValueParameter(int paramFlags, String paramName) {
            return new KmValueParameterVisitor(){

                @Override
                public KmTypeVisitor visitType(int typeFlags) {
                    if (!Flag.Type.IS_NULLABLE.invoke(typeFlags)) {
                        paramHint.set(paramIndex);
                    }
                    paramIndex++;
                    return null;
                }
            };
        }

        @Override
        public KmConstructorExtensionVisitor visitExtensions(KmExtensionType type) {
            if (type != JvmConstructorExtensionVisitor.TYPE) {
                return null;
            }
            return new JvmConstructorExtensionVisitor(){

                @Override
                public void visit(JvmMethodSignature desc) {
                    assert ("<init>".equals(desc.getName()));
                    descriptor = desc.getDesc();
                }
            };
        }

        @Override
        public void visitEnd() {
            if (this.descriptor.isEmpty()) {
                return;
            }
            this.paramHints.put((Object)"<init>", (Object)this.descriptor, (Object)this.paramHint);
        }
    }

    static class FunctionVisitor
    extends KmFunctionVisitor {
        private final HashBasedTable<String, String, BitSet> paramHints;
        private BitSet paramHint = new BitSet();
        private int paramIndex = 0;
        private String name = "";
        private String descriptor = "";

        FunctionVisitor(HashBasedTable<String, String, BitSet> paramHints) {
            this.paramHints = paramHints;
        }

        @Override
        public KmTypeVisitor visitReceiverParameterType(int typeFlags) {
            if (!Flag.Type.IS_NULLABLE.invoke(typeFlags)) {
                this.paramHint.set(this.paramIndex);
            }
            ++this.paramIndex;
            return null;
        }

        @Override
        public KmValueParameterVisitor visitValueParameter(int paramFlags, String paramName) {
            return new KmValueParameterVisitor(){

                @Override
                public KmTypeVisitor visitType(int typeFlags) {
                    if (!Flag.Type.IS_NULLABLE.invoke(typeFlags)) {
                        paramHint.set(paramIndex);
                    }
                    paramIndex++;
                    return null;
                }
            };
        }

        @Override
        public KmFunctionExtensionVisitor visitExtensions(KmExtensionType type) {
            if (type != JvmFunctionExtensionVisitor.TYPE) {
                return null;
            }
            return new JvmFunctionExtensionVisitor(){

                @Override
                public void visit(JvmMethodSignature desc) {
                    name = desc.getName();
                    descriptor = desc.getDesc();
                }
            };
        }

        @Override
        public void visitEnd() {
            if (this.name.isEmpty() || this.descriptor.isEmpty()) {
                return;
            }
            this.paramHints.put((Object)this.name, (Object)this.descriptor, (Object)this.paramHint);
        }
    }
}

