/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitylake.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securitylake.model.DataLakeEncryptionConfiguration;
import com.amazonaws.services.securitylake.model.DataLakeLifecycleConfiguration;
import com.amazonaws.services.securitylake.model.DataLakeReplicationConfiguration;
import com.amazonaws.services.securitylake.model.transform.DataLakeConfigurationMarshaller;
import java.io.Serializable;

public class DataLakeConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private DataLakeEncryptionConfiguration encryptionConfiguration;
    private DataLakeLifecycleConfiguration lifecycleConfiguration;
    private String region;
    private DataLakeReplicationConfiguration replicationConfiguration;

    public void setEncryptionConfiguration(DataLakeEncryptionConfiguration encryptionConfiguration) {
        this.encryptionConfiguration = encryptionConfiguration;
    }

    public DataLakeEncryptionConfiguration getEncryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public DataLakeConfiguration withEncryptionConfiguration(DataLakeEncryptionConfiguration encryptionConfiguration) {
        this.setEncryptionConfiguration(encryptionConfiguration);
        return this;
    }

    public void setLifecycleConfiguration(DataLakeLifecycleConfiguration lifecycleConfiguration) {
        this.lifecycleConfiguration = lifecycleConfiguration;
    }

    public DataLakeLifecycleConfiguration getLifecycleConfiguration() {
        return this.lifecycleConfiguration;
    }

    public DataLakeConfiguration withLifecycleConfiguration(DataLakeLifecycleConfiguration lifecycleConfiguration) {
        this.setLifecycleConfiguration(lifecycleConfiguration);
        return this;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public DataLakeConfiguration withRegion(String region) {
        this.setRegion(region);
        return this;
    }

    public void setReplicationConfiguration(DataLakeReplicationConfiguration replicationConfiguration) {
        this.replicationConfiguration = replicationConfiguration;
    }

    public DataLakeReplicationConfiguration getReplicationConfiguration() {
        return this.replicationConfiguration;
    }

    public DataLakeConfiguration withReplicationConfiguration(DataLakeReplicationConfiguration replicationConfiguration) {
        this.setReplicationConfiguration(replicationConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEncryptionConfiguration() != null) {
            sb.append("EncryptionConfiguration: ").append(this.getEncryptionConfiguration()).append(",");
        }
        if (this.getLifecycleConfiguration() != null) {
            sb.append("LifecycleConfiguration: ").append(this.getLifecycleConfiguration()).append(",");
        }
        if (this.getRegion() != null) {
            sb.append("Region: ").append(this.getRegion()).append(",");
        }
        if (this.getReplicationConfiguration() != null) {
            sb.append("ReplicationConfiguration: ").append(this.getReplicationConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeConfiguration)) {
            return false;
        }
        DataLakeConfiguration other = (DataLakeConfiguration)obj;
        if (other.getEncryptionConfiguration() == null ^ this.getEncryptionConfiguration() == null) {
            return false;
        }
        if (other.getEncryptionConfiguration() != null && !other.getEncryptionConfiguration().equals(this.getEncryptionConfiguration())) {
            return false;
        }
        if (other.getLifecycleConfiguration() == null ^ this.getLifecycleConfiguration() == null) {
            return false;
        }
        if (other.getLifecycleConfiguration() != null && !other.getLifecycleConfiguration().equals(this.getLifecycleConfiguration())) {
            return false;
        }
        if (other.getRegion() == null ^ this.getRegion() == null) {
            return false;
        }
        if (other.getRegion() != null && !other.getRegion().equals(this.getRegion())) {
            return false;
        }
        if (other.getReplicationConfiguration() == null ^ this.getReplicationConfiguration() == null) {
            return false;
        }
        return other.getReplicationConfiguration() == null || other.getReplicationConfiguration().equals(this.getReplicationConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEncryptionConfiguration() == null ? 0 : this.getEncryptionConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getLifecycleConfiguration() == null ? 0 : this.getLifecycleConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getRegion() == null ? 0 : this.getRegion().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationConfiguration() == null ? 0 : this.getReplicationConfiguration().hashCode());
        return hashCode;
    }

    public DataLakeConfiguration clone() {
        try {
            return (DataLakeConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataLakeConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

