/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitylake.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.securitylake.model.DataLakeConfiguration;
import com.amazonaws.services.securitylake.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateDataLakeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<DataLakeConfiguration> configurations;
    private String metaStoreManagerRoleArn;
    private List<Tag> tags;

    public List<DataLakeConfiguration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Collection<DataLakeConfiguration> configurations) {
        if (configurations == null) {
            this.configurations = null;
            return;
        }
        this.configurations = new ArrayList<DataLakeConfiguration>(configurations);
    }

    public CreateDataLakeRequest withConfigurations(DataLakeConfiguration ... configurations) {
        if (this.configurations == null) {
            this.setConfigurations(new ArrayList<DataLakeConfiguration>(configurations.length));
        }
        for (DataLakeConfiguration ele : configurations) {
            this.configurations.add(ele);
        }
        return this;
    }

    public CreateDataLakeRequest withConfigurations(Collection<DataLakeConfiguration> configurations) {
        this.setConfigurations(configurations);
        return this;
    }

    public void setMetaStoreManagerRoleArn(String metaStoreManagerRoleArn) {
        this.metaStoreManagerRoleArn = metaStoreManagerRoleArn;
    }

    public String getMetaStoreManagerRoleArn() {
        return this.metaStoreManagerRoleArn;
    }

    public CreateDataLakeRequest withMetaStoreManagerRoleArn(String metaStoreManagerRoleArn) {
        this.setMetaStoreManagerRoleArn(metaStoreManagerRoleArn);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateDataLakeRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateDataLakeRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConfigurations() != null) {
            sb.append("Configurations: ").append(this.getConfigurations()).append(",");
        }
        if (this.getMetaStoreManagerRoleArn() != null) {
            sb.append("MetaStoreManagerRoleArn: ").append(this.getMetaStoreManagerRoleArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataLakeRequest)) {
            return false;
        }
        CreateDataLakeRequest other = (CreateDataLakeRequest)obj;
        if (other.getConfigurations() == null ^ this.getConfigurations() == null) {
            return false;
        }
        if (other.getConfigurations() != null && !other.getConfigurations().equals(this.getConfigurations())) {
            return false;
        }
        if (other.getMetaStoreManagerRoleArn() == null ^ this.getMetaStoreManagerRoleArn() == null) {
            return false;
        }
        if (other.getMetaStoreManagerRoleArn() != null && !other.getMetaStoreManagerRoleArn().equals(this.getMetaStoreManagerRoleArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConfigurations() == null ? 0 : this.getConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getMetaStoreManagerRoleArn() == null ? 0 : this.getMetaStoreManagerRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateDataLakeRequest clone() {
        return (CreateDataLakeRequest)super.clone();
    }
}

