/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitylake.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.securitylake.model.CustomLogSourceConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateCustomLogSourceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private CustomLogSourceConfiguration configuration;
    private List<String> eventClasses;
    private String sourceName;
    private String sourceVersion;

    public void setConfiguration(CustomLogSourceConfiguration configuration) {
        this.configuration = configuration;
    }

    public CustomLogSourceConfiguration getConfiguration() {
        return this.configuration;
    }

    public CreateCustomLogSourceRequest withConfiguration(CustomLogSourceConfiguration configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public List<String> getEventClasses() {
        return this.eventClasses;
    }

    public void setEventClasses(Collection<String> eventClasses) {
        if (eventClasses == null) {
            this.eventClasses = null;
            return;
        }
        this.eventClasses = new ArrayList<String>(eventClasses);
    }

    public CreateCustomLogSourceRequest withEventClasses(String ... eventClasses) {
        if (this.eventClasses == null) {
            this.setEventClasses(new ArrayList<String>(eventClasses.length));
        }
        for (String ele : eventClasses) {
            this.eventClasses.add(ele);
        }
        return this;
    }

    public CreateCustomLogSourceRequest withEventClasses(Collection<String> eventClasses) {
        this.setEventClasses(eventClasses);
        return this;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public CreateCustomLogSourceRequest withSourceName(String sourceName) {
        this.setSourceName(sourceName);
        return this;
    }

    public void setSourceVersion(String sourceVersion) {
        this.sourceVersion = sourceVersion;
    }

    public String getSourceVersion() {
        return this.sourceVersion;
    }

    public CreateCustomLogSourceRequest withSourceVersion(String sourceVersion) {
        this.setSourceVersion(sourceVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration()).append(",");
        }
        if (this.getEventClasses() != null) {
            sb.append("EventClasses: ").append(this.getEventClasses()).append(",");
        }
        if (this.getSourceName() != null) {
            sb.append("SourceName: ").append(this.getSourceName()).append(",");
        }
        if (this.getSourceVersion() != null) {
            sb.append("SourceVersion: ").append(this.getSourceVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomLogSourceRequest)) {
            return false;
        }
        CreateCustomLogSourceRequest other = (CreateCustomLogSourceRequest)obj;
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getEventClasses() == null ^ this.getEventClasses() == null) {
            return false;
        }
        if (other.getEventClasses() != null && !other.getEventClasses().equals(this.getEventClasses())) {
            return false;
        }
        if (other.getSourceName() == null ^ this.getSourceName() == null) {
            return false;
        }
        if (other.getSourceName() != null && !other.getSourceName().equals(this.getSourceName())) {
            return false;
        }
        if (other.getSourceVersion() == null ^ this.getSourceVersion() == null) {
            return false;
        }
        return other.getSourceVersion() == null || other.getSourceVersion().equals(this.getSourceVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getEventClasses() == null ? 0 : this.getEventClasses().hashCode());
        hashCode = 31 * hashCode + (this.getSourceName() == null ? 0 : this.getSourceName().hashCode());
        hashCode = 31 * hashCode + (this.getSourceVersion() == null ? 0 : this.getSourceVersion().hashCode());
        return hashCode;
    }

    public CreateCustomLogSourceRequest clone() {
        return (CreateCustomLogSourceRequest)super.clone();
    }
}

